#!/bin/bash
#
#	TCDR install script - kobold2@yahoo.com (Szilard Torok)
#	version: 0.3
#	Wed Oct 16 17:04:05 CEST 2002


	if ! [ $(whoami) = 'root' ] ;then
		echo "You must be root to install TCDR."
		exit 1
	fi

	VER="1.2"

	echo "This will install TCDR v$VER.  Ctrl-C to exit." ;read

	install -D -p --mode=744 -b ./tcdr /usr/local/bin/tcdr && echo "Executable: /usr/local/bin/tcdr"
	install -D -p --mode=644 -b ./tcdrrc /etc/tcdrrc && echo "Config file: /etc/tcdrrc"
	install -D -p --mode=644 -b ./manual.html.gz /usr/local/share/doc/tcdr_$VER/manual.html.gz && echo "Manual: /usr/local/share/doc/tcdr_$VER/manual.html.gz"
	install -D -p --mode=644 -b ./Changelog.gz /usr/local/share/doc/tcdr_$VER/Changelog.gz && echo "Change log: /usr/local/share/doc/tcdr_$VER/Changelog.gz"
	install -D -p --mode=644 -b ./GNU_GPL.gz /usr/local/share/doc/tcdr_$VER/GNU_GPL.gz && echo "Copyright: /usr/local/share/doc/tcdr_$VER/GNU_GPL.gz"
	install -D -p --mode=644 -b ./README.gz /usr/local/share/doc/tcdr_$VER/README.gz && echo "Readme: /usr/local/share/doc/tcdr_$VER/README.gz"
	install -D -p --mode=644 -b ./tcdr.png /usr/local/share/doc/tcdr_$VER/tcdr.png && echo "Logo: /usr/local/share/doc/tcdr_$VER/tcdr.png"
	install -D -p --mode=644 -b ./tcdr.1.gz /usr/local/man/man1/tcdr.1.gz && echo "Man page: /usr/local/man/man1/tcdr.1.gz"

##### Uninstall:
#
	echo "#!/bin/bash" >/usr/local/share/doc/tcdr_$VER/uninstall.sh
	echo "echo \"This will uninstall tcdr version $VER.  Hit any key to continue.\";read">>/usr/local/share/doc/tcdr_$VER/uninstall.sh
	echo "rm -rvf /etc/tcdrrc /usr/local/bin/tcdr /usr/local/share/doc/tcdr_$VER /usr/local/man/man1/tcdr.1.gz" >>/usr/local/share/doc/tcdr_$VER/uninstall.sh
	chmod +x /usr/local/share/doc/tcdr_$VER/uninstall.sh && echo "Uninstall script: /usr/local/share/doc/tcdr_$VER/uninstall.sh"
#
#####

	exit 0

