/*
 * Loadable module to replace the stock console beep routine
 *
 * Requires patches to .../linux/drivers/char/vt_kern.h and
 * .../linux/drivers/char/vt.c
 *
 * dave madden <dhm@proteon.com>
 *
 * changed the patches and some includes for 2.0.21
 * changed calculating different legth and note
 * and changed it up to kernel 2.2.13
 * Gernot Zander <hifi@scorpio.in-berlin.de>
 */


/* Kernel includes */
/* #include <linux/modversions.h> /* must be first include */
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/major.h>
#include <asm/segment.h>
#include <asm/io.h>
#include <linux/module.h>
#include <linux/timer.h>
#include <linux/kernel.h>
#include <linux/signal.h>
#include "sound_config.h"
#include "opl3.h"

/*
 * NB. we must include the kernel idenfication string in to install the module.
 */
#include <linux/version.h>
static char kernel_version[] = UTS_RELEASE;

#ifdef __cplusplus
extern "C" {
#endif

extern int printk( const char* fmt, ... );

extern void	(*kd_nosound)( unsigned long ignored );
extern void	(*kd_mksound)( unsigned int count, unsigned int ticks ); 

static void	(*old_nosound)( unsigned long ignored );
static void	(*old_mksound)( unsigned int count, unsigned int ticks );

static void	 my_nosound( unsigned long ignored );
static void	 my_mksound( unsigned int count, unsigned int ticks );

static void	 opl3_command( int io_addr, unsigned int addr, unsigned int val );
static void	 tenmicrosecu( void );

int	 OPL3_PORT = 0x388;

int
init_module( void )
{
	printk( "Replacing keyboard beeper\n" );

	kd_nosound( 0 );			/* make sure the beeper is turned off now */

	old_nosound = kd_nosound;
	old_mksound = kd_mksound;

	kd_nosound = my_nosound;
	kd_mksound = my_mksound;
	
	return 0;
}

void
cleanup_module( void )
{
  printk( "Restoring old keyboard beeper\n" );

  kd_nosound( 0 );

  kd_nosound = old_nosound;
  kd_mksound = old_mksound;
}

static void	 my_nosound( unsigned long ignored )
{
  opl3_command( OPL3_PORT, KSL_LEVEL + 3, 0xff );	/*
												 * Carrier
												 * volume to
												 * min
												 */
  opl3_command( OPL3_PORT, KSL_LEVEL + 0, 0xff);	/*
												 * Modulator
												 * volume to
												 */

  opl3_command( OPL3_PORT, KEYON_BLOCK + 0, 0x00 );	/*
												 * Note
												 * off
												 */
  
}

static void	 my_mksound( unsigned int count, unsigned int ticks )
{
	static struct timer_list sound_timer = { NULL, NULL, 0, 0, 0 };
        register unsigned int c,o;
	register unsigned char d0;

	cli( );
	del_timer( &sound_timer );
	sti( );
	if (!count) {
	/*	my_nosound(5); don't turn of the sound, is sounds better */
		return;
	}
	if (!ticks) {
		my_nosound(5);
		return;
	}
        /* calculate octave and note to get the same note as with pc
           speaker
        */
	for(o = 0, c = count ; c > 72 ; o++, c/=2);
	c = (c - 36) * 7.08;
	/*
	 * key off
	 */
	opl3_command( OPL3_PORT, KEYON_BLOCK + 0, 0x0d );

	/*
	 * Set Sound Characteristics
	 */
	opl3_command( OPL3_PORT, AM_VIB + 0, 0x03 );
	opl3_command( OPL3_PORT, AM_VIB + 3, 0x05 );

	/*
	 * Set Attack/Decay
	 */
	d0 = 0xe9;
	d0 = d0 - (((ticks)&0xfff0)? 0x42:0);
	d0 = d0 - (((ticks)&0xfffc)? 0x23:0);
	opl3_command( OPL3_PORT, ATTACK_DECAY + 0, d0 );
	opl3_command( OPL3_PORT, ATTACK_DECAY + 3, d0 - 0x11 );

	/*
	 * Set Sustain/Release
	 */
	opl3_command( OPL3_PORT, SUSTAIN_RELEASE + 0, 0xf3 );
	opl3_command( OPL3_PORT, SUSTAIN_RELEASE + 3, 0xf5 );

	/*
	 * Set Wave Select
	 */
	opl3_command( OPL3_PORT, WAVE_SELECT + 0, 0 );
	opl3_command( OPL3_PORT, WAVE_SELECT + 3, 0 );

	/*
	 * Set Feedback/Connection
	 */
	opl3_command (OPL3_PORT, FEEDBACK_CONNECTION + 0, 0x35 );

	opl3_command( OPL3_PORT, KSL_LEVEL + 0, 0 );
	opl3_command( OPL3_PORT, KSL_LEVEL + 3, 0 );

	opl3_command( OPL3_PORT, FNUM_LOW + 0, c ); /* note*/
	opl3_command( OPL3_PORT, KEYON_BLOCK + 0, 0x21 + ((o & 0x7) << 2));/* oktave*/

	sound_timer.expires = jiffies+(ticks << 2);
	sound_timer.function = kd_nosound;
	cli( );
	del_timer( &sound_timer );
	add_timer( &sound_timer );
	sti( );
}

static void
opl3_command (int io_addr, unsigned int addr, unsigned int val)
{
	outb( (unsigned char)(addr & 0xff), io_addr );	/*
													 * Select register
													 *
													 */

	tenmicrosecu ();

	outb( (unsigned char) (val & 0xff), io_addr + 1 );	/*
														 * Write to register
														 *
														 */

	tenmicrosecu ();
	tenmicrosecu ();
	tenmicrosecu ();
}

static void
tenmicrosecu( void )
{
  int	 i;

  for (i = 0; i < 16; i++) inb( 0x80 );
} 

#ifdef __cplusplus
}
#endif

