#ifndef CHAT_H
#define CHAT_H

#include <Xm/Xm.h>
#include <stdio.h>
#include <time.h>


typedef struct userList {
    String nick;
    int shared;
    int link;
    struct userList *next;
} ULIST;


typedef struct channel {
    String name;
    ULIST *users;
    Widget w;
    Widget text;
    Widget entry;
    Widget list;
    struct channel *next;
} CHAN;


typedef struct priv {
    String nick;
    Widget w;
    Widget text;
    Widget entry;
    int    visible;
    struct priv *next;
} PRIV;


typedef struct pingRec {
    String nick;
    time_t start;
    struct pingRec *next;
} PING;


extern CHAN *channels;
extern PRIV *privs;

extern PING *pings;

void Ping(String nick);

void RcvGlobal(int type, String data);
void RcvChannel(int type, String data);

void JoinChannel(String name);
void DoJoinChannel(String name);
void PartChannel(String name);
void DoPartChannel(String name);
void PartAllChannels();

void CloseAllPrivs(void);

void UpdateUserList(int type, String data);

void ChatActions(Widget w, XEvent *ev, String *params, int *numParams);

#endif
