/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include "main.h"
#include "connect.h"
#include "message.h"
#include "msgbox.h"
#include "chnlist.h"
#include "listwin.h"
#include "chat.h"
#include "util.h"

static LISTCHAN *chnList = NULL;

static Widget listWin = NULL;


void DestroyChnListWin(void)
{
    if (listWin) {
	DestroyWin(XtParent(listWin));
	listWin = NULL;
    }
}


static void ListChannelsCB(Widget w, XtPointer clientData,
	XmSelectionBoxCallbackStruct *cbs)
{
    String channel, tmp;
    
    switch (cbs->reason) {
        case XmCR_OK:
	    XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &tmp);
	    channel = strtok(tmp, " ");
	    JoinChannel(channel);
	    XtFree(tmp);
            break;
	case XmCR_CANCEL:
	case XmCR_PROTOCOLS:
	    DestroyChnListWin();
    }
}


void ListChannels(void)
{
    String p;
    
    while (chnList) {
	XtFree(chnList->data);
	p = (String)chnList;
	chnList = chnList->next;
	XtFree(p);
    }

    chnList = NULL;
    
    if (SendMsg(MSG_CLIENT_LIST_CHANNELS, ""))
	Disconnect(strerror(errno));
}


void AddChannel(String s)
{
    LISTCHAN *newChan, *chnPtr, *prevPtr = NULL;

    newChan = XtNew(LISTCHAN);
    newChan->data = XtNewString(s);
    
    for (chnPtr = chnList; chnPtr; chnPtr = chnPtr->next) {
	if (strcasecmp(chnPtr->data, s) > 0)
	    break;
	prevPtr = chnPtr;
    }

    if (prevPtr) {
	newChan->next = prevPtr->next;
	prevPtr->next = newChan;
    } else {
	newChan->next = chnList;
	chnList = newChan;
    }
}


void DoListChannels(void)
{
    LISTCHAN *lc;
    String name, users, topic, p, tmp = XtMalloc(8192);
    XmString *str;
    int i, numChannels;

    DestroyChnListWin();
    if (! chnList) {
	InfoMsg("No channels exist");
	goto end;
    }
     
    listWin = ListWin("chnList", (XtCallbackProc)ListChannelsCB, NULL);
    
    for (numChannels = 0, lc = chnList; lc; numChannels++, lc = lc->next);
    
    str = (XmString*)XtMalloc(numChannels * sizeof(XmString));
    for (i = 0, lc = chnList; i < numChannels; i++, lc = lc->next) {
	name = strtok(lc->data, " ");
	users = strtok(NULL, " ");
	topic = strtok(NULL, "\0");
	if (topic) {
	    for (p = topic; *p; p++) {
		if (! isprint(*p))
		    *p = ' ';
	    }
	} else
	    topic = "";
	sprintf(tmp, "%-35.34s%-10s%s  ", name, users, topic);
        str[i] = XmStringCreateLocalized(tmp);
    }

    XtVaSetValues(listWin,
	    XmNlistItems, str,
	    XmNlistItemCount, numChannels,
	    NULL);
    
    for (i = 0; i < numChannels; i++)
        XmStringFree (str[i]);
    XtFree((String)str);

end:
    XtFree(tmp);
}
