/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/Scale.h>
#include <Xm/Protocols.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "main.h"
#include "transfer.h"


static void DlCancelCB(Widget w, XtPointer clientData,
	XmPushButtonCallbackStruct *cbs)
{
    DOWNLOAD *rec = (DOWNLOAD*)clientData;
    AbortDl(rec, 1, "");
}


Widget DlWin(DOWNLOAD *rec)
{
    Arg args[20];
    int n;
    Widget dlWin, dlForm, dlNameLabel, dlSizeLabel, dlRowCol,
	dlProgBar, dlStatusLabel, dlCancelBtn;
    String title, lblText, tmp = XtMalloc(256), p;
    XmString xms;
    Dimension height;

    dlWin = XtVaCreatePopupShell("dlWin",
	    topLevelShellWidgetClass, topLevel,
	    XmNiconPixmap, napPix,
	    NULL);

    XtVaGetValues(dlWin, XmNtitle, &title, NULL);
    sprintf(tmp, "%s %s", title, rec->nick);
    XtVaSetValues(dlWin,
	    XmNtitle, tmp, XmNiconName, tmp, NULL);
    
    dlForm = XtVaCreateManagedWidget("dlForm",
	    xmFormWidgetClass, dlWin,
	    XmNmarginWidth, 18,
	    XmNmarginHeight, 15,
	    NULL);

    dlNameLabel = XtVaCreateManagedWidget("dlNameLabel",
	    xmTextFieldWidgetClass, dlForm,
	    XmNeditable, False,
	    XmNresizable, False,
	    XmNcursorPositionVisible, False,
	    XmNshadowThickness, 2,
	    XmNhighlightThickness, 0,
	    XmNtopAttachment, XmATTACH_FORM,
	    XmNleftAttachment, XmATTACH_FORM,
	    XmNrightAttachment, XmATTACH_FORM,
	    NULL);

    p = strrchr(rec->dlName, '/') + 1;
    XmTextFieldSetString(dlNameLabel, p);

    dlSizeLabel = XtVaCreateManagedWidget("dlSizeLabel",
	    xmLabelWidgetClass, dlForm,
	    XmNhighlightThickness, 0,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, dlNameLabel,
	    XmNtopOffset, 15,
	    XmNleftAttachment, XmATTACH_FORM,
	    XmNrightAttachment, XmATTACH_FORM,
	    NULL);
	    
    XtVaGetValues(dlSizeLabel, XmNlabelString, &xms, NULL);
    XmStringGetLtoR(xms, XmFONTLIST_DEFAULT_TAG, &lblText);
    sprintf(tmp, "%s %d", lblText, rec->tot);
    XmStringFree(xms);
    XtFree(lblText);
    xms = XmStringCreateLocalized(tmp);
    XtVaSetValues(dlSizeLabel, XmNlabelString, xms, NULL);
    XmStringFree(xms);
    
    dlCancelBtn = XtVaCreateManagedWidget("dlCancelBtn",
	    xmPushButtonWidgetClass, dlForm,
	    XmNleftAttachment, XmATTACH_FORM,
	    XmNbottomAttachment, XmATTACH_FORM,
	    NULL);

    dlRowCol = XtVaCreateManagedWidget("dlRowCol",
	    xmRowColumnWidgetClass, dlForm,
	    XmNorientation, XmHORIZONTAL,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, dlSizeLabel,
	    XmNtopOffset, 15,
	    XmNleftAttachment, XmATTACH_FORM,
	    XmNrightAttachment, XmATTACH_FORM,
	    XmNbottomAttachment, XmATTACH_WIDGET,
	    XmNbottomWidget, dlCancelBtn,
	    XmNbottomOffset, 20,
	    NULL);
    
    dlProgBar = XtVaCreateWidget("dlProgBar",
	    xmScaleWidgetClass, dlRowCol,
	    XmNorientation, XmHORIZONTAL,
	    XmNslidingMode, XmTHERMOMETER,
	    XmNsliderVisual, XmFOREGROUND_COLOR,
	    XmNtraversalOn, False,
	    XmNwidth, 75,
	    XmNhighlightThickness, 0,
	    XmNshadowThickness, 0,
	    XmNeditable, False,
	    NULL);
    
    XtUnmanageChild(XtNameToWidget(dlProgBar, "Title"));

    dlStatusLabel = XtVaCreateWidget("dlStatusLabel",
	    xmTextFieldWidgetClass, dlRowCol,
	    XmNcolumns, 20,
	    XmNeditable, False,
	    XmNtraversalOn, False,
	    XmNcursorPositionVisible, False,
	    XmNmarginHeight, 0,
	    XmNshadowThickness, 0,
	    XmNhighlightThickness, 0,
	    NULL);
    
    XmTextFieldSetString(dlStatusLabel, "");

    XtVaGetValues(dlStatusLabel, XmNheight, &height, NULL);
    XtVaSetValues(dlProgBar, XmNscaleHeight, height, NULL);

    XtManageChild(dlProgBar);
    XtManageChild(dlStatusLabel);
    XtManageChild(dlRowCol);
    
    XtAddCallback(dlForm, XmNfocusCallback,
	    (XtCallbackProc)FocusCB, (XtPointer)rec);

    XtAddCallback(dlCancelBtn, XmNactivateCallback,
	    (XtCallbackProc)DlCancelCB, (XtPointer)rec);

    XmAddWMProtocolCallback(dlWin,
	    XmInternAtom(XtDisplay(dlWin), "WM_DELETE_WINDOW", False),
	    (XtCallbackProc)DlCancelCB, (XtPointer)rec);

    n = 0;
    XtSetArg(args[n], XmNinitialFocus, dlNameLabel); n++;
    XtSetValues(dlForm, args, n);

    XtPopup(dlWin, XtGrabNone);
    XtFree(tmp);
    return dlWin;
}
