/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/Protocols.h>

#include "main.h"
#include "util.h"


static void EntryFocusCB(Widget w, XtPointer clientData,
	XmAnyCallbackStruct *cbs) {
    XtVaSetValues(w, XmNcursorPositionVisible, True, NULL);
}


static void EntryLosingFocusCB(Widget w, XtPointer clientData,
	XmTextVerifyCallbackStruct *cbs) {
    XtVaSetValues(w, XmNcursorPositionVisible, False, NULL);
}


static void InfoCB(Widget w, XtPointer clientData,
	XmAnyCallbackStruct *cbs)
{
    Widget topLevel = (cbs->reason == XmCR_OK) ? XtParent(w) : w;
    XtDestroyWidget(topLevel);
}


void ShowInfo(String name, String *values, int length)
{
    Widget parent, d, rowCol, form, label, entry = NULL;
    Arg args[20];
    int i, n;
    Dimension labelWidth, labelMaxWidth = 0;
    char labelName[20];

    parent = curFocus ? curFocus : topLevel;
    
    n = 0;
    XtSetArg(args[n], XmNautoUnmanage, False); n++;
    XtSetArg(args[n], XmNdefaultPosition, False); n++;
    XtSetArg(args[n], XmNmessageAlignment, XmALIGNMENT_CENTER); n++;
    d = XmCreateTemplateDialog(parent, name, args, n);

    rowCol = XtVaCreateManagedWidget("rowCol",
	    xmRowColumnWidgetClass, d,
	    XmNmarginWidth, 5,
	    NULL);

    for (i = 0; values[i]; i++) {
	form = XtVaCreateWidget("form", xmFormWidgetClass,
		rowCol, NULL);

	sprintf(labelName, "label_%d", i);

	n = 0;
	XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	label = XmCreateLabelGadget(form, labelName, args, n);
	XtManageChild(label);

	XtVaGetValues(label, XmNwidth, &labelWidth, NULL);
	if (labelWidth > labelMaxWidth)
	    labelMaxWidth = labelWidth;

	n = 0;
	XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
	XtSetArg(args[n], XmNeditable, False); n++;
	XtSetArg(args[n], XmNshadowThickness, 1); n++;
	XtSetArg(args[n], XmNmarginWidth, 5); n++;
	XtSetArg(args[n], XmNmarginHeight, 0); n++;
	XtSetArg(args[n], XmNcolumns, length); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNleftWidget, label); n++;
	XtSetArg(args[n], XmNleftOffset, 20); n++;
	entry = XmCreateTextField(form, "entry", args, n);
	XtManageChild(entry);
	XmTextFieldSetString(entry, values[i]);

	XtAddCallback(entry, XmNfocusCallback,
		(XtCallbackProc)EntryFocusCB, NULL);
	XtAddCallback(entry, XmNlosingFocusCallback,
		(XtCallbackProc)EntryLosingFocusCB, NULL);

	XtManageChild(form);
    }

    for (i = 0; values[i]; i++) {
	sprintf(labelName, "form.label_%d", i);
	XtVaSetValues(XtNameToWidget(rowCol, labelName),
		XmNwidth, labelMaxWidth, NULL);
    }

    XtAddCallback(d, XmNokCallback,
	    (XtCallbackProc)InfoCB, NULL);
    XmAddWMProtocolCallback(XtParent(d),
	    XmInternAtom(XtDisplay(d), "WM_DELETE_WINDOW", False),
	    (XtCallbackProc)InfoCB, NULL);
    
    CenterDialog(d);
}
