/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/Label.h>
#include <Xm/MessageB.h>
#include <Xm/Protocols.h>
#include <stdlib.h>

#include "main.h"
#include "search.h"
#include "util.h"


static int link;

static Widget searchDlg = NULL;


static void SearchDlgDestroyCB(Widget w, XtPointer clientData,
	XmAnyCallbackStruct *cbs) {
    XmPushButtonCallbackStruct cbs2;

    cbs2.reason = XmCR_CANCEL;
    XtCallCallbacks(searchDlg, XmNcancelCallback, &cbs2);
}


static void DestroySearchDlg(void)
{
    if (searchDlg) {
	XtRemoveCallback(XtParent(searchDlg), XmNdestroyCallback,
		(XtCallbackProc)SearchDlgDestroyCB, NULL);
	XtDestroyWidget(XtParent(searchDlg));
        searchDlg = NULL;
    }
}


static void EntryFocusCB (Widget w, XtPointer clientData,
	XmAnyCallbackStruct *cbs) {
    XtVaSetValues(w, XmNcursorPositionVisible, True, NULL);
}


static void EntryLosingFocusCB (Widget w, XtPointer clientData,
	XmTextVerifyCallbackStruct *cbs) {
    XtVaSetValues(w, XmNcursorPositionVisible, False, NULL);
}


static void LinkCB(Widget w, XtPointer clientData,
	XtPointer cbs)
{
    link = (int)clientData;
}


static void SearchDlgCB(Widget w, XtPointer clientData,
	XmAnyCallbackStruct *cbs)
{
    if (cbs->reason == XmCR_OK) {
	XtFree(search.artist);
	XtFree(search.title);
	XtFree(search.minLink);
	XtFree(search.minBitrate);
	XtFree(search.minFreq);
	XtFree(search.maxFiles);

	search.artist =
	    XmTextFieldGetString(XtNameToWidget(w, "*artist"));
	search.title =
	    XmTextFieldGetString(XtNameToWidget(w, "*title"));
	search.minBitrate =
	    XmTextFieldGetString(XtNameToWidget(w, "*bitRate"));
	search.minFreq =
	    XmTextFieldGetString(XtNameToWidget(w, "*freq"));
	search.maxFiles =
	    XmTextFieldGetString(XtNameToWidget(w, "*maxFiles"));

	search.minLink = XtMalloc(3);
	sprintf(search.minLink, "%d", link);
    }

    DestroySearchDlg();
    if (cbs->reason == XmCR_OK)
	Search2();
}


void SearchDlg()
{
    String values[5];
    Widget parent, rowCol, form, label, entry = NULL, linkMenu;
    Arg args[20];
    XmString optLabel[11];
    int i, j, n, columns[] = {35, 35, 10, 10, 10};
    Dimension labelWidth, labelMaxWidth = 0;
    char labelName[20];
    String entryName[] = {"artist", "title", "bitRate", "freq", "maxFiles"};

    DestroySearchDlg();
    
    parent = curFocus ? curFocus : topLevel;

    values[0] = search.artist;
    values[1] = search.title;
    values[2] = search.minBitrate;
    values[3] = search.minFreq;
    values[4] = search.maxFiles;
    link = atoi(search.minLink);
    
    n = 0;
    XtSetArg(args[n], XmNautoUnmanage, False); n++;
    XtSetArg(args[n], XmNdefaultPosition, False); n++;
    XtSetArg(args[n], XmNnoResize, True); n++;
    XtSetArg(args[n], XmNmessageAlignment, XmALIGNMENT_CENTER); n++;
    searchDlg = XmCreateTemplateDialog(parent, "searchDlg", args, n);

    rowCol = XtVaCreateManagedWidget("rowCol",
	    xmRowColumnWidgetClass, searchDlg,
	    XmNmarginWidth, 5, NULL);

    for (i = 0; i < 6; i++) {
	form = XtVaCreateWidget("form", xmFormWidgetClass,
		rowCol, NULL);

	sprintf(labelName, "label_%d", i);
	
	n = 0;
	XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n], XmNmarginHeight, 6); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	label = XmCreateLabel(form, labelName, args, n);
	XtManageChild(label);

	XtVaGetValues(label, XmNwidth, &labelWidth, NULL);
	if (labelWidth > labelMaxWidth)
	    labelMaxWidth = labelWidth;

	if (i == 5) {
	    for (j = 0; j < 11; j++)
		optLabel[j] = XmStringCreateLocalized (linkStr[j]);

	    linkMenu = XmVaCreateSimpleOptionMenu (form, "linkMenu",
		    NULL, 0, atoi(search.minLink), LinkCB,
		    XmVaPUSHBUTTON, optLabel[0], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[1], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[2], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[3], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[4], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[5], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[6], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[7], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[8], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[9], NULL, NULL, NULL,
		    XmVaPUSHBUTTON, optLabel[10], NULL, NULL, NULL,
		    XmNtopAttachment, XmATTACH_FORM,
		    XmNbottomAttachment, XmATTACH_FORM,
		    XmNleftAttachment, XmATTACH_WIDGET,
		    XmNleftWidget, label,
		    XmNleftOffset, 20,
		    XmNmarginWidth, 0,
		    XmNmarginHeight, 0,
		    NULL);

	    for (j = 0; j < 11; j++)
		XmStringFree(optLabel[j]);

	    XtUnmanageChild(XtNameToWidget(linkMenu, "OptionLabel"));
	    XtManageChild (linkMenu);
	} else {
	    n = 0;
	    XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
	    XtSetArg(args[n], XmNmarginWidth, 5); n++;	
	    XtSetArg(args[n], XmNmarginHeight, 2); n++;	
	    XtSetArg(args[n], XmNcolumns, columns[i]); n++;
	    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	    XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	    XtSetArg(args[n], XmNleftWidget, label); n++;
	    XtSetArg(args[n], XmNleftOffset, 20); n++;
	    entry = XmCreateTextField(form, entryName[i], args, n);
	    XtManageChild(entry);
	    XmTextSetString(entry, values[i]);

	    XtAddCallback(entry, XmNfocusCallback,
		    (XtCallbackProc)EntryFocusCB, NULL);
	    XtAddCallback(entry, XmNlosingFocusCallback,
		    (XtCallbackProc)EntryLosingFocusCB, NULL);
	}
	XtManageChild(form);
    }

    for (i = 0; i < 6; i++) {
	sprintf(labelName, "form.label_%d", i);
	XtVaSetValues(XtNameToWidget(rowCol, labelName),
		XmNwidth, labelMaxWidth,
		NULL);
    }

    XtAddCallback(searchDlg, XmNokCallback,
	    (XtCallbackProc)SearchDlgCB, NULL);
    XtAddCallback(searchDlg, XmNcancelCallback,
	    (XtCallbackProc)SearchDlgCB, NULL);
    XmAddWMProtocolCallback(XtParent(searchDlg),
	    XmInternAtom(XtDisplay(searchDlg), "WM_DELETE_WINDOW", False),
	    (XtCallbackProc)SearchDlgCB, NULL);
    XtAddCallback(XtParent(searchDlg), XmNdestroyCallback,
	    (XtCallbackProc)SearchDlgDestroyCB, NULL);
    
    XtVaSetValues(searchDlg, XmNinitialFocus, rowCol, NULL);

    CenterDialog(searchDlg);
}
