#ifndef TRANSFER_H
#define TRANSFER_H

#include <Xm/Xm.h>
#include <time.h>


typedef struct {
    String        fileName;
    String        dlName;
    String        nick;
    time_t        start;
    int           tot;
    int           count;
    int           offset;
    Widget        w;
    int           fd;
    int           mp3Fd;
    XtInputId     inputId;
    XtIntervalId  timerId;
} DOWNLOAD;
    

typedef struct ulRec {
    String        fileName;
    String        nick;
    int           tot;
    int           count;
    int           fd;
    int           mp3Fd;
    int           inputId;
    struct ulRec  *next;
} UPLOAD;
    

extern DOWNLOAD *downloads;
extern UPLOAD *uploads;

extern int destIp, destPort;

void EndDl(DOWNLOAD *rec, int dlStat, int aborted);
void AbortDl(DOWNLOAD *rec, int dlStat, String err);
void Download(int n, int mode);

void EndUl(UPLOAD *rec, int ulStat);
void FwUpload(String data);

void SetDataPort(int port, int manual);

#endif
