/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>

#include "main.h"
#include "connect.h"
#include "message.h"
#include "info.h"
#include "msgbox.h"
#include "util.h"


void Whois(String nick)
{
    if (SendMsg(MSG_CLIENT_WHOIS, nick))
	Disconnect(strerror(errno));
}


void ShowWhois(String data)
{
    regmatch_t pmatch[18];
    String values[18], timeStr = XtMalloc(256);
    String tmp, dtxt, htxt;
    int i, j, r, len, link;
    int time, days, hours, minutes, seconds;
    char timeTmp[80];
    
    enum {NICK, LEVEL, TIME, CHANNELS, STATUS, SHARED, DOWNLOADS,
	  UPLOADS, CONNECTION, CLIENT, TOT_DOWNLOADS, TOT_UPLOADS,
	  IP_ADDR, CONN_PORT, DATA_PORT, EMAIL, SERVER};

    r = RegEx(data, "^([^ ]+) \"?([^ \"]+)\"? ([-0-9]+) \"(.*)\" \"([^ ]+)\""
	    " ([0-9]+) ([0-9]+) ([0-9]+) ([0-9]+) \"(.+)\" *([0-9]*)"
	    " *([0-9]*) *([^ ]*) *([0-9]*) *([0-9]*) *([^ ]*) *([^ ]*)$",
	    18, pmatch);
    if (r <= 0) {
	ErrMsg("ShowWhois: regex error");
	XtFree(timeStr);
	return;
    }

    for (i = 0, j = 1; i < 17; i++, j++) {
	if (! (len = pmatch[j].rm_eo - pmatch[j].rm_so))
	    break;
	switch (i) {
	    case TIME:
		tmp = (String)XtCalloc(len + 1, 1);
		strncpy(tmp, data + pmatch[j].rm_so, len);
		time = atol(tmp);
		XtFree(tmp);
		days = time / 86400;
		hours = (time / 3600) % 24;
		minutes = (time / 60) % 60;
		seconds = time % 60;
		dtxt = "day";
		if (days > 1)
		    dtxt = "days";
		htxt = "hr";
		if (hours > 1)
		    htxt = "hrs";
		sprintf(timeStr, "%d sec", seconds);
		if (minutes) {
		    strcpy(timeTmp, timeStr);
		    sprintf(timeStr, "%d min  %s", minutes, timeTmp);
		}
		if (hours) {
		    strcpy(timeTmp, timeStr);
		    sprintf(timeStr, "%d %s  %s", hours, htxt, timeTmp);
		}
		if (days) {
		    strcpy(timeTmp, timeStr);
		    sprintf(timeStr, "%d %s  %s", days, dtxt, timeTmp);
		}
		values[i] = XtNewString(timeStr);
		break;
	    case CONNECTION:
		tmp = (String)XtCalloc(len + 1, 1);
		strncpy(tmp, data + pmatch[j].rm_so, len);
		link = atoi(tmp);
		XtFree(tmp);
		values[i] = XtNewString(linkStr[link]);
		break;
	    default:
		values[i] = (String)XtCalloc(len + 1, 1);
		tmp = data + pmatch[j].rm_so;
		if (i == CHANNELS) {
		    while (*tmp == ' ') {
			tmp++;
			len--;
		    }
		}
		strncpy(values[i], tmp, len);
	}
    }
    values[i] = NULL;

    ShowInfo("whois", values, 30);

    for (j = 0; j < i; j++)
        XtFree(values[j]);
    XtFree(timeStr);
}


void ShowWhowas(String data)
{
    String values[4];
    String tmp;
    char timeStr[80];
    enum {NICK, LEVEL, LAST_SEEN, END};
    struct tm *tm;
    time_t time;
    
    tmp = XtNewString(data);
    
    values[NICK] = strtok(tmp, " ");
    values[LEVEL] = strtok(NULL, " ");
    if (*(values[LEVEL]) == '\"') {
	*(values[LEVEL] + strlen(values[LEVEL]) - 1) = 0;
	(values[LEVEL])++;
    }
    time = (time_t)atol(strtok(NULL, " "));
    tm = gmtime(&time);
    strftime(timeStr, 80, "%Y-%m-%d  %H:%M", tm);
    values[LAST_SEEN] = timeStr;
    values[END] = NULL;

    ShowInfo("whowas", values, 20);
    XtFree(tmp);
}
