.TH xmnap 1 "Oct 17 2002"
.SH NAME
xmnap - a Motif napster client
.SH SYNOPSIS
\fBxmnap\fP [\fIconfig_file\fP]
.SH DESCRIPTION
\fIxmnap\fP is a simple Motif napster client.
.PP
The first time you start up \fIxmnap\fP, a configuration dialog will
pop up that lets you enter your preferred settings.  This dialog should
be pretty self-explanatory.  If you are behind a firewall, set the data
port to '0'.  The dialog can be called up at a later stage by clicking
on the "tool icon" in the main window, or by using the \fI/config\fP
command.
.PP
You can give an optional argument to \fIxmnap\fP when running it, which
will set the name of the configuration file to use for this instance of
\fIxmnap\fP.  It is possible to run several instances simultaneously
with completely different configurations.  Just be sure that you use
unique port numbers.
.PP
Resume of a partially downloaded file from a previous session will only
work if it has been saved with its original name.
.SH MAIN WINDOW BUTTONS
.TP
.BR Connect " (keyboard shortcut: Ctrl-c)"
Connect to server
.TP
.BR Disc " (keyboard shortcut: Ctrl-d)"
Disconnect from server
.TP
.BR Search " (keyboard shortcut: Ctrl-s)"
Search for MP3 files
.TP
.BR Browse " (keyboard shortcut: Ctrl-b)"
Browse a user's files
.TP
.BR Whois " (keyboard shortcut: Ctrl-w)"
Show whois info for a user
.TP
.BR Config " (keyboard shortcut: Ctrl-o)"
Configuration dialog
.TP
.BR Quit " (keyboard shortcut: Ctrl-q)"
Exit program
.SH TEXTUAL COMMANDS
Commands that only work with opennap servers are marked with a (*).
.PP
Partial entry of commands is allowed (like /br for /browse), as long
as there is no ambiguity.
.PP
Some of the commands require privileges.  To be regarded as privileged,
you need either have a certain user level, or have a higher level than
the target user, depending on the type of command.  There are five
user levels: 'leech', 'user', 'moderator', 'admin' and 'elite' in low
to high order, with 'user' being the default for new users.
.PP
Certain commands are only available in channel windows (where the 
description mentions "the current channel".
.TP
\fB/ban\fP \fIuser\fP|\fIip\fP
Ban \fIuser\fP or \fIip\fP from server (moderator or higher).
.TP
\fB/browse\fP \fIuser\fP
Browse \fIuser\fP's shared files.
.TP
\fB/chlevel\fP \fIc\fP [\fIlevel\fP] (*)
Set the minimum level required to join channel \fIc\fP (moderator or higher).
To see the current level of a channel, use the command without the
\fIlevel\fP parameter.
.TP
\fB/clear\fP \fIc\fP [\fIreason\fP]
Clear channel \fIc\fP from users with a lower level than yours.
.TP
\fB/cloak\fP
Toggle your invisible state (moderator or higher).
.TP
\fB/config\fP
Show configuration dialog.
.TP
\fB/connect\fP
Connect to the last server used.
.TP
\fB/dataport\fP \fIuser\fP \fIport\fP
Set the data port for \fIuser\fP to \fIport\fP (moderator or higher).
.TP
\fB/deop\fP \fIc\fP \fIuser\fP (*)
Remove \fIuser\fP as operator on channel \fIc\fP (moderator or higher).
.TP
\fB/disconnect\fP
Disconnect from server.
.TP
\fB/gmsg\fP \fItext\fP
Send global message to all users (admin or higher).
.TP
\fB/join\fP \fIchannel\fP
Join channel \fIchannel\fP.
.TP
\fB/kick\fP \fIc\fP \fIuser\fP [\fIreason\fP] (*)
Kick \fIuser\fP with a lower level than yours from channel \fIc\fP.
.TP
\fB/kill\fP \fIuser\fP [\fIreason\fP]
Kill (disconnect) \fIuser\fP with a lower level than yours.
.TP
\fB/level\fP \fIuser\fP \fIlevel\fP
Change level of \fIuser\fP with a lower level than yours.
.TP
\fB/links\fP (*)
Show links between servers.
.TP
\fB/list\fP
List available channels.
.TP
\fB/listbans\fP
List banned users and ip:s.
.TP
\fB/me\fP \fItext\fP (*)
Send action description \fItext\fP on the current channel.
.TP
\fB/msg\fP \fIuser\fP \fItext\fP
Send a private message to \fIuser\fP.
.TP
\fB/motd\fP
Show server's "Message Of The Day".
.TP
\fB/muzzle\fP \fIuser\fP [\fIreason\fP]
Muzzle \fIuser\fP with a lower level than yours.
.TP
\fB/online\fP
Show hotlist users currently online.
.TP
\fB/op\fP \fIc\fP [\fIuser\fP] (*)
Set \fIuser\fP as operator on channel \fIc\fP (moderator or higher).
If you omit the \fIuser\fP parameter, a list of current channel
operators will be returned in the form of a private message from
pseudo-user 'ChanServ'.
.TP
\fB/opmsg\fP \fItext\fP
Send a message to all users with level moderator or higher (moderator or
higher).
.TP
\fB/part\fP
Part the current channel.
.TP
\fB/ping\fP \fIuser\fP
Ping \fIuser\fP.
.TP
\fB/quit\fP
Exit program.
.TP
\fB/search\fP [\fIword ...\fP]
Search for artist or title containing the word(s) you enter.  Only the
artist field is used in this case (the title field is cleared), but that
doesn't have any impact on the search result since the server treats
the artist and title fields equal when searching for MP3 files.
If you don't enter any search word, the usual search dialog box will
pop up.
.TP
\fB/server\fP [\fIadr\fP:\fIpt\fP:\fImeta\fP]
Connect to server \fIadr\fP at port \fIpt\fP, treating the server as a
"metaserver" (like the usual napster servers) if \fImeta\fP is '1', else
like a normal server.  If you omit the server string, the server page
of the configuration dialog will pop up.
.TP
\fB/stats\fP (*)
Show server statistics.
.TP
\fB/topic\fP \fIc\fP \fItopic\fP
Set the topic of channel \fIc\fP to \fItopic\fP (moderator or higher).
.TP
\fB/ullist\fP
Display statistics about active uploads.
.TP
\fB/unban\fP \fIuser\fP|\fIip\fP
Remove the ban on a user or ip (moderator or higher).
.TP
\fB/unmuzzle \fIuser\fP
Unmuzzle \fIuser\fP with a lower level than yours.
.TP
\fB/usermode\fP [\fIparms\fP] (*)
Set user mode.  See the opennap documentation for an explanation of
the parameter syntax.  This command seems to work for all users, although
it is mainly of interest to users with level moderator or higher.
NOTE: The user mode will be reset upon next login, either by the
server, or, if you have defined 'usermode' in the auto-commands, to
that setting.  In other words, regard the changes you make with this
command as temporary.  To see the current state, use the command without
parameters.
.TP
\fB/version\fP
Show server version (moderator or higher).
.TP
\fB/whois\fP \fIuser\fP
Show whois info for \fIuser\fP.
.SH CHANNEL/PRIVATE WINDOWS
If you press the right mouse button in the user list of a channel window
or in the text box of a private window, you will get a pop-up menu
with various commands.
.SS Keyboard shortcuts in channel windows
.TP
.B Ctrl-l
Clear received text
.TP
.B Ctrl-p
Part channel
.SS Keyboard shortcuts in private windows
.TP
.B Ctrl-l
Clear received text
.TP
.B Ctrl-c
Close window
.SH FONTS
If you would like to change the fonts used in the program, the easiest
way to do this is to enter it in your .Xdefaults/.Xresources file.
.SS
Examples:
.TP
Default for the whole program
XmNap*fontList: lucidasans-18
.TP
Main window status labels
XmNap*statusLbl.fontList: lucidasans-bold-14
.TP
Info window
XmNap*miscInfoText.fontList: lucidasans-18
.TP
Received text in channel windows (preferably a monospaced font)
XmNap*chanText.fontList: lucidasanstypewriter-18
.TP
Channel window user list
XmNap*userList.fontList: lucidasans-18
.TP
Text entry box in channel windows
XmNap*chanEntry.fontList: lucidasanstypewriter-18
.TP
Received text in private windows (preferably a monospaced font)
XmNap*privText.fontList: lucidasanstypewriter-18
.TP
Text entry box in private windows
XmNap*privEntry.fontList: lucidasanstypewriter-18
.TP
Other lists (should be a monospaced font)
XmNap*XmSelectionBox*ItemsList.fontList: lucidasanstypewriter-18
.PP
There are of course many other resources you can change in addition to
the fonts.  Take a look in the included 'XmNap.ad'.  I have tried to
make the resource names as self-explanatory as possible.  The
XmNap-colors.* files are examples of using different colors from the
default ones.  To use any of them, rename the file to 'XmNap' and put
it in your home directory, or copy the contents to your
\&.Xdefaults/.Xresources file.
.SH FILES
.TP
.B ~/.xmnaprc
Default configuration file.
.SH BUGS
Please report any problems to <matsp888@yahoo.com>
