#include <cdaudio.h>
#include <stdio.h>
#include <time.h>

int
strchar(char *buffer, char repchar, int len)
{
   int index;
   
   if(len < 0)
     return 0;
   
   for(index = 0; index < len; index++)
     buffer[index] = repchar;
   
   buffer[index] = '\0';
   return 0;
}

int
main(int argc, char **argv)
{
   FILE *conf;
   
   int index;
   time_t tim;
   struct cddb_serverlist list;
   char spacing[256];
   char server[256];
   
   cddb_read_sites(&list);
   
   if(argc < 2)
     conf = stdout;
   else
     conf = fopen(argv[1], "w");
   
   fputs("# CDDB configuration file generated by cddbconfgen\n", conf);
   
   tim = time(NULL);
   fprintf(conf, "# Created %s\n", ctime(&tim));
   fputs("cddb on\n", conf);
   
   for(index = 0; index < list.list_len; index++) {
      snprintf(server, 256, "%s:%d", list.list_host[index].host_hostname, list.list_host[index].host_port);
      strchar(spacing, ' ', 32 - strlen(server));
      fprintf(conf, "server %s%s# %s\n", server, spacing, list.list_host[index].host_city);
   }
   
   return 0;
}
