/*
This is part of the audio CD player library
Copyright (C)1998 Tony Arcieri

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*/

#include <cdaudio.h>
#include <config.h>
#include <string.h>

int
data_process_control_codes(char *outbuffer, char *inbuffer, int len)
{
   int index;
   int outbufferindex = 0;
   
   for(index = 0; index < len; index++) {
      if(inbuffer[index] == '\\') {
	 switch(inbuffer[++index]) {
	  case 'n':
	    outbuffer[outbufferindex++] = '\n';
	    break;
	  case 't':
	    outbuffer[outbufferindex++] = '\t';
	    break;
	  case '\\':
	    outbuffer[outbufferindex++] = '\\';
	    break;
	 }
      } else if(inbuffer[index] == '\0') {
	 outbuffer[outbufferindex] = '\0';
	 return 0;
      } else
	outbuffer[outbufferindex++] = inbuffer[index];
   }
   
   return 0;
}

int
data_format_extended_info(char *outbuffer, struct disc_data *data, int track, int len)
{
   int index, copyindex;
   int outbufferindex = 0;
   char procbuffer[256];
   
   if(track == 0) {
      if(data->data_extendedindex == 0) {
	 strcpy(outbuffer, "");
	 return 0;
      }
      
      for(index = 0; index < data->data_extendedindex; index++) {
	 data_process_control_codes(procbuffer, data->data_extended[index], 256);
	 for(copyindex = 0; copyindex < 256; copyindex++) {
	    if(procbuffer[copyindex] == '\0')
	      break;
	    else {
	       outbuffer[outbufferindex++] = procbuffer[copyindex];
	       if(outbufferindex >= len) {
		  outbuffer[len - 1] = '\0';
	       }
	    }
	 }
      }
      
      outbuffer[outbufferindex] = '\0';
      return 0;
   } else {
      track--;
      
      if(data->data_track[track].track_extendedindex == 0) {
	 strcpy(outbuffer, "");
	 return 0;
      }
      
      for(index = 0; index < data->data_track[track].track_extendedindex; index++) {
	 data_process_control_codes(procbuffer, data->data_track[track].track_extended[index], 256);
	 for(copyindex = 0; copyindex < 256; copyindex++) {
	    if(procbuffer[copyindex] == '\0')
	      break;
	    else {
	       outbuffer[outbufferindex++] = procbuffer[copyindex];
	       if(outbufferindex >= len) {
		  outbuffer[len - 1] = '\0';
		  return 0;
	       }
	    }
	 }
      }
      
      outbuffer[outbufferindex] = '\0';
   }
   
   return 0;
}
