# 
#  Progress bar
#

package provide mpTk 0.6.15


proc mpTk::Progress::Update {w n1 n2 op} {
    variable prg

    if {[string length $n2]} {
	upvar 1 $n1 a
	if {[catch {set v $a($n2)}]} {set a($n2) 0; set v 0}
    } else {
	upvar 1 $n1 v
	if {[catch {set v}]} {set v 0}
    }

    set rw [expr {$v/100.0}]

    if {$rw != $prg(oldrw)} {
	place configure $w.bar -relwidth $rw
	update idletasks
	set prg(oldrw) $rw
    }
}


proc mpTk::Progress::pbar {w variable} {
    variable prg

    set prg(oldrw) 0.0

    frame $w -bd 0 -width 100 -height 12 -bg #b8b8b8 -class Progress

    frame $w.bar -bd 0 -bg #4040a0
    place $w.bar -x 0 -y 0 -relwidth 0.0 -relheight 1.0

    bindtags $w [list $w Progress [winfo toplevel $w] all]

    uplevel #0 [list trace variable $variable w \
	    [list ::mpTk::Progress::Update $w]]

    bind $w <Destroy> \
	    [list trace vdelete $variable w {::mpTk::Progress::Update %W}]

    return $w
}
