/* mapping table of MathML elements */
#include "MathML.h"
#include "MathMLentities.h"
static ElemMapping    MathMLElemMappingTable[] =
{
   /* This table MUST be in alphabetical order */
   {"DOCTYPE", SPACE, MathML_EL_DOCTYPE, L_OtherValue, FALSE},
   {"DOCTYPE_line", SPACE, MathML_EL_DOCTYPE_line, L_OtherValue, FALSE},
   {"XMLPI", SPACE, MathML_EL_XMLPI, L_OtherValue, FALSE},
   {"XMLPI_line", SPACE, MathML_EL_XMLPI_line, L_OtherValue, FALSE},
   {"XMLcomment", SPACE, MathML_EL_XMLcomment, L_OtherValue, FALSE},
   {"XMLcomment_line", SPACE, MathML_EL_XMLcomment_line, L_OtherValue, FALSE},
   {"c", SPACE, MathML_EL_TEXT_UNIT, L_MathMLValue, TRUE},
   {"maligngroup", 'E', MathML_EL_MALIGNGROUP, L_MathMLValue, FALSE},
   {"malignmark", 'E', MathML_EL_MALIGNMARK, L_MathMLValue, FALSE},
   {"math", SPACE, MathML_EL_MathML, L_MathMLValue, TRUE},
   {"menclose", SPACE, MathML_EL_MENCLOSE, L_MathMLValue, FALSE},
   {"merror", SPACE, MathML_EL_MERROR, L_MathMLValue, FALSE},
   {"mf", SPACE, MathML_EL_MF, L_MathMLValue, FALSE},  /* for compatibility with an old version of MathML: WD-math-970704 */
   {"mfenced", SPACE, MathML_EL_MFENCED, L_MathMLValue, FALSE},
   {"mfrac", SPACE, MathML_EL_MFRAC, L_MathMLValue, FALSE},
   {"mglyph", 'E', MathML_EL_MGLYPH, L_MathMLValue, FALSE},
   {"mi", SPACE, MathML_EL_MI, L_MathMLValue, FALSE},
   {"mlabeledtr", SPACE, MathML_EL_MLABELEDTR, L_MathMLValue, FALSE},
   {"mmultiscripts", SPACE, MathML_EL_MMULTISCRIPTS, L_MathMLValue, FALSE},
   {"mn", SPACE, MathML_EL_MN, L_MathMLValue, FALSE},
   {"mo", SPACE, MathML_EL_MO, L_MathMLValue, FALSE},
   {"mover", SPACE, MathML_EL_MOVER, L_MathMLValue, FALSE},
   {"mpadded", SPACE, MathML_EL_MPADDED, L_MathMLValue, FALSE},
   {"mphantom", SPACE, MathML_EL_MPHANTOM, L_MathMLValue, FALSE},
   {"mprescripts", SPACE, MathML_EL_PrescriptPairs, L_MathMLValue, FALSE},
   {"mroot", SPACE, MathML_EL_MROOT, L_MathMLValue, FALSE},
   {"mrow", SPACE, MathML_EL_MROW, L_MathMLValue, FALSE},
   {"ms", SPACE, MathML_EL_MS, L_MathMLValue, FALSE},
   {"mspace", 'E', MathML_EL_MSPACE, L_MathMLValue, FALSE},
   {"msqrt", SPACE, MathML_EL_MSQRT, L_MathMLValue, FALSE},
   {"mstyle", SPACE, MathML_EL_MSTYLE, L_MathMLValue, FALSE},
   {"msub", SPACE, MathML_EL_MSUB, L_MathMLValue, FALSE},
   {"msubsup", SPACE, MathML_EL_MSUBSUP, L_MathMLValue, FALSE},
   {"msup", SPACE, MathML_EL_MSUP, L_MathMLValue, FALSE},
   {"mtable", SPACE, MathML_EL_MTABLE, L_MathMLValue, FALSE},
   {"mtd", SPACE, MathML_EL_MTD, L_MathMLValue, FALSE},
   {"mtext", SPACE, MathML_EL_MTEXT, L_MathMLValue, FALSE},
   {"mtr", SPACE, MathML_EL_MTR, L_MathMLValue, FALSE},
   {"munder", SPACE, MathML_EL_MUNDER, L_MathMLValue, FALSE},
   {"munderover", SPACE, MathML_EL_MUNDEROVER, L_MathMLValue, FALSE},
   {"none", SPACE, MathML_EL_Construct, L_MathMLValue, FALSE},
   {"", SPACE, 0, L_MathMLValue, FALSE}	 /* Last entry. Mandatory */
};

static AttributeMapping MathMLAttributeMappingTable[] =
{
   /* The first entry MUST be unknown_attr */
   /* The rest of this table MUST be in alphabetical order */
   {"unknown_attr", "", 'A', MathML_ATTR_Unknown_attribute, L_MathMLValue},

   {"accent", "", 'A', MathML_ATTR_accent, L_MathMLValue},
   {"accentunder", "", 'A', MathML_ATTR_accentunder, L_MathMLValue},
   {"actiontype", "", 'A', MathML_ATTR_actiontype, L_MathMLValue},
   {"align", "", 'A', MathML_ATTR_align, L_MathMLValue},
   {"alignmentscope", "", 'A', MathML_ATTR_alignmentscope, L_MathMLValue},
   {"alt", "", 'A', MathML_ATTR_alt, L_MathMLValue},
   {"altimg", "", 'A', MathML_ATTR_altimg, L_MathMLValue},
   {"alttext", "", 'A', MathML_ATTR_alttext, L_MathMLValue},
   {"background", "", 'A', MathML_ATTR_background_, L_MathMLValue},
   {"bevelled", "", 'A', MathML_ATTR_bevelled, L_MathMLValue},
   {"class", "", 'A', MathML_ATTR_class, L_MathMLValue},
   {"close", "", 'A', MathML_ATTR_close, L_MathMLValue},
   {"columnalign", "mtd", 'A', MathML_ATTR_columnalign_mtd, L_MathMLValue},
   {"columnalign", "", 'A', MathML_ATTR_columnalign, L_MathMLValue},
   {"columnlines", "", 'A', MathML_ATTR_columnlines, L_MathMLValue},
   {"columnspacing", "", 'A', MathML_ATTR_columnspacing, L_MathMLValue},
   {"columnspan", "", 'A', MathML_ATTR_columnspan, L_MathMLValue},
   {"columnwidth", "", 'A', MathML_ATTR_columnwidth, L_MathMLValue},
   {"color", "", 'A', MathML_ATTR_color, L_MathMLValue},
   {"denomalign", "", 'A', MathML_ATTR_denomalign, L_MathMLValue},
   {"depth", "", 'A', MathML_ATTR_depth_, L_MathMLValue},
   {"display", "", 'A', MathML_ATTR_display, L_MathMLValue},
   {"displaystyle", "", 'A', MathML_ATTR_displaystyle, L_MathMLValue},
   {"edge", "", 'A', MathML_ATTR_edge, L_MathMLValue},
   {"equalcolumns", "", 'A', MathML_ATTR_equalcolumns, L_MathMLValue},
   {"equalrows", "", 'A', MathML_ATTR_equalrows, L_MathMLValue},
   {"fence", "", 'A', MathML_ATTR_fence, L_MathMLValue},
   {"fontfamily", "", 'A', MathML_ATTR_fontfamily, L_MathMLValue},
   {"fontstyle", "", 'A', MathML_ATTR_fontstyle, L_MathMLValue},
   {"fontsize", "", 'A', MathML_ATTR_fontsize, L_MathMLValue},
   {"fontweight", "", 'A', MathML_ATTR_fontweight, L_MathMLValue},
   {"form", "", 'A', MathML_ATTR_form, L_MathMLValue},
   {"frame", "", 'A', MathML_ATTR_frame, L_MathMLValue},
   {"framespacing", "", 'A', MathML_ATTR_framespacing, L_MathMLValue},
   {"groupalign", "maligngroup", 'A', MathML_ATTR_groupalign_malgr, L_MathMLValue},
   {"groupalign", "", 'A', MathML_ATTR_groupalign, L_MathMLValue},
   {"height", "", 'A', MathML_ATTR_height_, L_MathMLValue},
   {"id", "", 'A', MathML_ATTR_id, L_MathMLValue},
   {"index", "", 'A', MathML_ATTR_index, L_MathMLValue},
   {"lang", "", 'A', MathML_ATTR_Language, L_MathMLValue},
   {"largeop", "", 'A', MathML_ATTR_largeop, L_MathMLValue},
   {"linebreak", "", 'A', MathML_ATTR_linebreak_, L_MathMLValue},
   {"linethickness", "", 'A', MathML_ATTR_linethickness, L_MathMLValue},
   {"lquote", "", 'A', MathML_ATTR_lquote, L_MathMLValue},
   {"lspace", "", 'A', MathML_ATTR_lspace, L_MathMLValue},
   {"mathbackground", "", 'A', MathML_ATTR_mathbackground, L_MathMLValue},
   {"mathcolor", "", 'A', MathML_ATTR_mathcolor, L_MathMLValue},
   {"mathsize", "", 'A', MathML_ATTR_mathsize, L_MathMLValue},
   {"mathvariant", "", 'A', MathML_ATTR_mathvariant, L_MathMLValue},
   {"maxsize", "", 'A', MathML_ATTR_maxsize, L_MathMLValue},
   {"minlabelspacing", "", 'A', MathML_ATTR_minlabelspacing, L_MathMLValue},
   {"minsize", "", 'A', MathML_ATTR_minsize, L_MathMLValue},
   {"mode", "", 'A', MathML_ATTR_display, L_MathMLValue},
   {"movablelimits", "", 'A', MathML_ATTR_movablelimits, L_MathMLValue},
   {"notation", "", 'A', MathML_ATTR_notation, L_MathMLValue},
   {"numalign", "", 'A', MathML_ATTR_numalign, L_MathMLValue},
   {"open", "", 'A', MathML_ATTR_open, L_MathMLValue},
   {"other", "", 'A', MathML_ATTR_other, L_MathMLValue},
   {"overflow", "", 'A', MathML_ATTR_overflow, L_MathMLValue},
   {"rowalign", "mtr", 'A', MathML_ATTR_rowalign_mtr, L_MathMLValue},
   {"rowalign", "mlabeledtr", 'A', MathML_ATTR_rowalign_mtr, L_MathMLValue},
   {"rowalign", "mtd", 'A', MathML_ATTR_rowalign_mtr, L_MathMLValue},
   {"rowalign", "", 'A', MathML_ATTR_rowalign, L_MathMLValue},
   {"rowlines", "", 'A', MathML_ATTR_rowlines, L_MathMLValue},
   {"rowspacing", "", 'A', MathML_ATTR_rowspacing, L_MathMLValue},
   {"rowspan", "", 'A', MathML_ATTR_rowspan_, L_MathMLValue},
   {"rquote", "", 'A', MathML_ATTR_rquote, L_MathMLValue},
   {"rspace", "", 'A', MathML_ATTR_rspace, L_MathMLValue},
   {"scriptlevel", "", 'A', MathML_ATTR_scriptlevel, L_MathMLValue},
   {"scriptminsize", "", 'A', MathML_ATTR_scriptminsize, L_MathMLValue},
   {"scriptsizemultiplier", "", 'A', MathML_ATTR_scriptsizemultiplier, L_MathMLValue},
   {"selection", "", 'A', MathML_ATTR_selection, L_MathMLValue},
   {"separator", "", 'A', MathML_ATTR_separator, L_MathMLValue},
   {"separators", "", 'A', MathML_ATTR_separators, L_MathMLValue},
   {"side", "", 'A', MathML_ATTR_side, L_MathMLValue},
   {"stretchy", "", 'A', MathML_ATTR_stretchy, L_MathMLValue},
   {"style", "", 'A', MathML_ATTR_style_, L_MathMLValue},
   {"subscriptshift", "", 'A', MathML_ATTR_subscriptshift, L_MathMLValue},
   {"superscriptshift", "", 'A', MathML_ATTR_superscriptshift, L_MathMLValue},
   {"symmetric", "", 'A', MathML_ATTR_symmetric, L_MathMLValue},
   {"width", "", 'A', MathML_ATTR_width_, L_MathMLValue},
   {"xml:space", "", 'A', MathML_ATTR_xml_space, L_MathMLValue},
   {"xref", "", 'A', MathML_ATTR_xref, L_MathMLValue},
   {"zzghost", "", 'A', MathML_ATTR_Ghost_restruct, L_MathMLValue},

   {"", "", EOS, 0, L_MathMLValue}		/* Last entry. Mandatory */
};

