	{ Thot presentation schema for SVG

	  V. Quint	February 1998-2001	}

PRESENTATION SVG;

VIEWS
   Formatted_view,
   Structure_view merge with Structure_view,
   Alternate_view merge with Alternate_view,
   Links_view merge with Links_view;

#define STRUCT_INDENT 1.5
#define TAG_FONTSIZE 12 pt
#define DOC_FONTSIZE 12 pt
#define TAG_Style Roman
#define TAG_Weight Normal
#define TAG_Visibility 7
#define ATTR_Style Roman
#define ATTR_Weight Normal
#define ATTR_Visibility 6
#define ALT_Visibility 8
#define INVALID_Style Roman
#define INVALID_Weight Normal
#define INVALID_Visibility 7
#define INVALID_Font Helvetica
 
#ifdef BLACK_WHITE
#define TAG_Color Black
#define ATTR_Color Black
#define ATTRVALUE_Color Black
#define INVALID_Color Black
#else
#define TAG_Color Blue
#define ATTR_Color Blue
#define ATTRVALUE_Color Black
#define INVALID_Color Red
#endif
 
#define TAG_Font Helvetica
#define ATTR_Font Helvetica

DEFAULT

   BEGIN
   HorizRef: * . Top;
   VertRef: * . Left;
   HorizPos: Left = Enclosing . Left;
   VertPos:  Top = Enclosing . Top;
   Visibility: Enclosing =;
   FillPattern: Enclosing =;
   Depth: Enclosing =;
   Font: Enclosing =;
   IN Structure_view
	BEGIN
	VertPos: Top = Previous . Bottom;
	Width: Enclosed . Width;
	HorizRef: Enclosed . HRef;
	END;
   IN Alternate_view
	BEGIN
	VertPos: Top = Previous . Bottom;
	Width: Enclosing . Width;
	Height: Enclosed . Height;
	HorizRef: Enclosed . HRef;
	END;
   END;

BOXES

   ElementName: BEGIN
	Content: (ElemName);
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   VerticalLine: BEGIN
	Content: Graphics 'W';
	Visibility: 0;
	IN Structure_view BEGIN
		VertPos: Top = Creator . Top;
		HorizPos: Left = Enclosing . Left;
		Height: Creator . Height;
		Width: 1.1;
		LineWeight: 1 px;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   AttrName: BEGIN
        Content: (Text ' ' AttributeName Text '=');
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
        END;

   AttrValue: BEGIN
        Content: (AttributeValue);
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
                END;
        END;

   AttrNameAndValue: BEGIN
        Content: (Text ' ' AttributeName Text '=' AttributeValue);
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
        END;

  UnknownAttrValue: BEGIN
	Content: (AttributeValue);
	Visibility: 0;
	IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
                Font: INVALID_Font;
		Style: INVALID_Style;
		Visibility: INVALID_Visibility;
		Foreground: INVALID_Color;
		END;	
	END;

   ATTR_xml_space_default: BEGIN
	Content: Text ' xml:space=default';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

   ATTR_xml_space_preserve: BEGIN
	Content: Text ' xml:space=preserve';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

{ presentation boxes }

   Comment_Start:
	BEGIN
	Content: Text '<!--';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		END;
	END;

   Comment_End:
	BEGIN
	Content: Text '-->';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		END;
	END;

   PI_Start:
	BEGIN
	Content: Text '<?';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		END;
	END;

   PI_End:
	BEGIN
	Content: Text '?>';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		END;
	END;


 DOCTYPE_S: BEGIN
	Content: Text '<!DOCTYPE ';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		Size: TAG_FONTSIZE;
		HorizRef: Enclosed . HRef;
		END;
	END;

 DOCTYPE_E: BEGIN
	Content: Text '>';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		Size: TAG_FONTSIZE;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		END;
	END;

 Unknown_End: BEGIN
	Content: Text '>';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: INVALID_Style;
		Visibility: INVALID_Visibility;
		Foreground: Creator =;
		END;
	END;

   IndexBox: BEGIN
	Content: Picture 'index.gif';
	HorizPos: Left = Root . Left;
	VertPos: Top = Creator . Top;
	VertOverflow : Yes;
	HorizOverflow : Yes;
	Inline: No;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

RULES

   Document:
	BEGIN
	Size: 12 pt;
	Font: helvetica;
        Visibility: 10;
	Width: Enclosing . Width;
	Height: Enclosing . Height min;
	IN Structure_view BEGIN
		Width: Enclosing . Width;
		PaddingLeft: 0.4;
		Font: Helvetica;
		END;
	END;

   SVG:
	BEGIN
	CreateBefore(ElementName);
        CreateWith(VerticalLine);
	Width: Enclosing . Width;
        Height: Enclosing . Height;
	HorizRef: *.Bottom;
        if NOT within SVG BEGIN
           VertPos: Top = Previous . Bottom;
	   Foreground: transparent;
	   Background: Black;
	   FillPattern: backgroundcolor;
	END;
	PageBreak: No;
	LineBreak: No;
	Adjust: Left;
	Hyphenate: No;
	Gather: Yes;
	LineWeight: 1 pt;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
        	Height	: Enclosed . Height;
		Font: TAG_Font;
		Foreground: Enclosing =;
	        Background: Enclosing =;
	        FillPattern: nopattern;
		END;
	IN Alternate_view BEGIN
		Width: Enclosing . Width;
        	Height	: Enclosed . Height;
	   	MarginTop: 0;
	   	MarginBottom: 0;
		Foreground: Enclosing =;
	        Background: Enclosing =;
	        FillPattern: nopattern;
		END;		
	END;

   g:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   defs:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	END;

   path:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	HorizPos: Left = Enclosing . Left UserSpecified;
	VertPos:  Top = Enclosing . Top UserSpecified;
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   rect:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: 2.5 cm UserSpecified;
	Height: 1.5 cm UserSpecified;
	HorizPos: Left = Enclosing . Left UserSpecified;
	VertPos:  Top = Enclosing . Top UserSpecified;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   circle:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: 2 cm UserSpecified;
	Height: * . Width;
	HorizPos: VMiddle = Enclosing . Left + 1 cm  UserSpecified;
	VertPos:  HMiddle = Enclosing . Top + 1 cm  UserSpecified;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   ellipse:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: 2.5 cm UserSpecified;
	Height: 1.5 cm UserSpecified;
	HorizPos: VMiddle = Enclosing . Left + 1.3 cm  UserSpecified;
	VertPos:  HMiddle = Enclosing . Top + 0.8 cm  UserSpecified;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   line_:
	BEGIN
	CreateBefore (ElementName);
        HorizPos: Left = Enclosing . Left UserSpecified;
        VertPos:  Top = Enclosing . Top UserSpecified;
        Width: Right = Enclosing . Left;
        Height:  Bottom = Enclosing . Top;
       	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   polyline:
	BEGIN
	CreateBefore (ElementName);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   polygon:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   text_:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: Enclosed . Width;
   	HorizPos: Left = Enclosing . Left Userspecified;
   	VertPos:  HRef = Enclosing . Top + 10 pt Userspecified;
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Height: Enclosed . Height;
		Width: Enclosing . Width;
		END;
	END;

   tspan:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos:  HRef = Previous . HRef;
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Height: Enclosed . Height;
	        Width: Enclosed . Width;
		HorizPos: Left = Previous . Right;
		VertPos:  HRef = Previous . HRef;
		END;	
	END;

   use_:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   image:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
   	HorizPos: Left = Enclosing . Left Userspecified;
   	VertPos:  HRef = Enclosing . Top + 10 pt Userspecified;
	Width: Enclosed . Width;
        Height: Enclosed . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   symbol_:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   desc:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Visibility: ALT_Visibility;
		Line;
		END;
	END;

   title:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Visibility: ALT_Visibility;
		Line;
		END;
	END;

   a:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   script:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	END;

   style__:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	END;

   switch:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view BEGIN
		Height: Enclosed . Height;
		Width: Enclosing . Width;
		VertPos: Top = Previous . Bottom;
		END;
	END;

   foreignObject:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
   	HorizPos: Left = Enclosing . Left Userspecified;
   	VertPos:  HRef = Enclosing . Top + 10 pt Userspecified;
	Foreground: Black;
	FillPattern: nopattern;
	Background: transparent;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Height: Enclosed . Height;
		Width: Enclosing . Width;
		VertPos: Top = Previous . Bottom;
		END;
	END;

   metadata:
	BEGIN
	CreateBefore (ElementName);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Visibility: ALT_Visibility;
		Line;
		END;
	END;

   XMLcomment:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: 10;
		Width: Enclosing . Width ;
		Height: Enclosed . Height;
		END;
	END;

   XMLcomment_line:
        BEGIN
        IF First CreateFirst(Comment_Start);
        IF Last CreateLast(Comment_End);
	IN Structure_view BEGIN
	        HorizPos: Left = Enclosing . Left;
	        VertPos: Top = Previous . Bottom + 0.2;
	        Width: Enclosed . Width;
		END;
        END;

   XMLPI:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: 10;
		Width: Enclosing . Width ;
		END;
	END;

   XMLPI_line:
        BEGIN
        IF First CreateFirst(PI_Start);
        IF Last CreateLast(PI_End);
	IN Structure_view BEGIN
	        HorizPos: Left = Enclosing . Left;
	        VertPos: Top = Previous . Bottom + 0.2;
	        Width: Enclosed . Width;
		END;
        END;

  DOCTYPE:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width ;
		END;
	END;

  DOCTYPE_line:
	BEGIN
	Visibility: 0;
	IF First CreateFirst(DOCTYPE_S);
	IF Last CreateLast(DOCTYPE_E);
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosed . Width;
		VertPos: Top = Previous . Bottom;
		END;
	END;

   Unknown_namespace:
	BEGIN
	Visibility: 0;
	if NOT AnyAttributes
	  CreateAfter(Unknown_End);
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Visibility: INVALID_Visibility;
		Style: INVALID_Style;
		Weight: INVALID_Weight;
		Foreground: INVALID_Color;
		Font: INVALID_Font;
		END;
	END;

   TEXT_UNIT:
	BEGIN
	HorizRef: Enclosed . HRef;
	HorizPos: Left = Previous . Right;
        VertPos: HRef = Previous . HRef;
	Width: Enclosed . Width;
        Height: Enclosed . Height;
	IN Structure_view BEGIN
		if NOT within XMLcomment_line AND NOT within XMLPI_line AND NOT within DOCTYPE_line
		   BEGIN
		   HorizPos: Left = Enclosing . Left;
		   VertPos: Top = Previous . Bottom;
		   END;
		if within XMLcomment_line BEGIN
		   HorizPos: Left = Previous . Right;
                   VertPos: HRef = Previous . HRef;
		   END;
		if within XMLPI_line BEGIN
		   HorizPos: Left = Previous . Right;
                   VertPos: HRef = Previous . HRef;
		   END;
		if within DOCTYPE_line BEGIN
		   HorizPos: Left = Previous . Right;
		   END;
		END;
	IN Alternate_view BEGIN
	        Width: Enclosed . Width;
        	VertPos: HRef = Previous . HRef;
		END;
	END;

   GRAPHICS_UNIT:
	BEGIN
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

   SYMBOL_UNIT:
	BEGIN
   	HorizPos: Left = Previous . Right;
   	VertPos: HRef = Previous . HRef;
	HorizRef: Enclosed . HRef;
	IN Structure_view
   		VertPos: HRef = Previous . HRef;
	END;

   PICTURE_UNIT:
	BEGIN
	Width: Enclosing . Width;
        Height: Enclosing . Height;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

   SVG_Image: BEGIN
	LineBreak: No;
	PageBreak: No;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

ATTRIBUTES

  Language:
	BEGIN
        CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  id:
        BEGIN
        CreateBefore(AttrName);
        CreateBefore(AttrValue);
        END;

  class:
        BEGIN
        CreateBefore(AttrName);
        CreateBefore(AttrValue);
        END;
 
  style_:
        BEGIN
        CreateBefore(AttrName);
        CreateBefore(AttrValue);
        END;
 
  xml_space = xml_space_default:
	CreateBefore (ATTR_xml_space_default);

  xml_space = xml_space_preserve:
	CreateBefore (ATTR_xml_space_preserve);

  Highlight:
	BEGIN
        if TEXT_UNIT
	   CreateAfter (IndexBox);
	if NOT TEXT_UNIT
	   CreateLast (IndexBox);
	END;

  font_family:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  font_size:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  font_style = normal_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Style: roman;
	END;
  font_style = italic:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Style: italics;
	IN Structure_view
	   Style: Enclosing =;
	END;
  font_style = oblique_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Style: oblique;
	IN Structure_view
	   Style: Enclosing =;
	END;
  font_style = inherit:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Style: Enclosing =;
	END;

  font_variant = normal_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	END;
  font_variant = small_caps:
	BEGIN
	CreateBefore(AttrNameAndValue);
	END;
  font_variant = inherit:
	BEGIN
	CreateBefore(AttrNameAndValue);
	END;

  font_weight = normal_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Weight: normal;
	END;
  font_weight = bold_:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Weight: bold;
	IN Structure_view
	   Weight: Enclosing =;
	END;
  font_weight = bolder:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Weight: bold;
	IN Structure_view
	   Weight: Enclosing =;
	END;
  font_weight = lighter:
	BEGIN
	CreateBefore(AttrNameAndValue);
	IN Structure_view
	   Weight: Enclosing =;
	END;
  font_weight = w100:
	BEGIN
	CreateBefore(AttrNameAndValue);
	END;
  font_weight = w200:
	BEGIN
	CreateBefore(AttrNameAndValue);
	END;
  font_weight = w300:
	BEGIN
	CreateBefore(AttrNameAndValue);
	END;
  font_weight = w400:
	BEGIN
	CreateBefore(AttrNameAndValue);
        Weight: normal;
	END;
  font_weight = w500:
	BEGIN
	CreateBefore(AttrNameAndValue);
	END;
  font_weight = w600:
	BEGIN
	CreateBefore(AttrNameAndValue);
	END;
  font_weight = w700:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Weight: bold;
	IN Structure_view
	   Weight: Enclosing =;
	END;
  font_weight = w800:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Weight: bold;
	IN Structure_view
	   Weight: Enclosing =;
	END;
  font_weight = w900:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Weight: bold;
	IN Structure_view
	   Weight: Enclosing =;
	END;
  font_weight = inherit:
	BEGIN
	CreateBefore(AttrNameAndValue);
	Weight: Enclosing =;
	END;

  text_decoration:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;

  viewBox:
        BEGIN
        CreateBefore(AttrName);
        CreateBefore(AttrValue);
        END;

  x:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
   	HorizPos: Left = Enclosing . Left;
	IN Structure_view
	   HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Links_view
	   HorizPos: Left = Enclosing . Left;
	END;

  y:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	if not text_
   	   VertPos:  Top = Enclosing . Top;
	if text_
	   VertPos:  HRef = Enclosing . Top;
   	IN Structure_view
	   VertPos: Top = Previous . Bottom;
	IN Alternate_view
	   VertPos: Top = Previous . Bottom;
	IN Links_view
	   VertPos: Top = Previous . Bottom;
	END;

  height_:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  width_:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  fill:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  stroke:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  stroke_width:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  transform:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  requiredFeatures:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  requiredExtensions:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  systemLanguage:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  externalResourcesRequired:
	CreateBefore (AttrNameAndValue);

  d:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  pathLength:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  cx:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;

  cy:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
   	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

  r:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  rx:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  ry:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  x1:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  y1:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  x2:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  y2:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  points:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  dx:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  dy:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  xlink_href:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  preserveAspectRatio:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  target_:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  type:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  media:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  title_:
	BEGIN
	CreateBefore (AttrName);
	CreateBefore (AttrValue);
	END;

  Unknown_attribute:
	BEGIN
	if TEXT_UNIT
	   CreateBefore(UnknownAttrValue);
	if PICTURE_UNIT
	   CreateBefore(UnknownAttrValue);
	if Unknown_namespace
	   CreateAfter(UnknownAttrValue);
	if Unknown_namespace and LastAttr
	   CreateAfter(Unknown_End);
	if NOT TEXT_UNIT and NOT PICTURE_UNIT and NOT Unknown_namespace
  	   CreateBefore(UnknownAttrValue);
	END;
 
END
