	{ Thot presentation schema for Generic XML

	  L. Carcone	January 2001	}

PRESENTATION XML;

VIEWS 
   Formatted_view,
   Structure_view merge with Structure_view;

#define STRUCT_INDENT 1.5
#define TAG_FONTSIZE 12 pt
#define DOC_FONTSIZE 12 pt
#define TAG_Style Roman
#define TAG_Weight Normal
#define TAG_Visibility 7
#define ATTR_Style Roman
#define ATTR_Weight Normal
#define ATTR_Visibility 6
#define COMMENT_Visibility 5
#define COMMENT_Font Helvetica
#define COMMENT_Style Italics
#define COMMENT_Weight Normal
 
#ifdef BLACK_WHITE
#define TAG_Color Black
#define ATTR_Color Black
#define ATTRVALUE_Color Black
#else
#define TAG_Color Blue
#define ATTR_Color Blue
#define ATTRVALUE_Color Black
#endif
 
#define TAG_Font Helvetica
#define ATTR_Font Helvetica

DEFAULT

   BEGIN
   HorizRef: Enclosed . HRef;
   VertRef: * . Left;
   Width: Enclosing . Width;
   Height: Enclosed . Height;
   VertPos: Top = Previous . Bottom;
   HorizPos: Left = Enclosing . Left;
   Hyphenate: Enclosing =;
   LineSpacing: Enclosing =;
   LineWeight: Enclosing =;
   LineBreak: Yes;
   PageBreak: Yes;
   Visibility: Enclosing =;
   Font: Enclosing =;
   Style: Enclosing =;
   Weight: Enclosing =;
   Underline: Enclosing =;
   Thickness: Enclosing =;
   Size: Enclosing =;
   Adjust: Enclosing =;
   Indent: Enclosing =;
   Depth: Enclosing =;
   FillPattern: nopattern;
   IN Structure_view
	BEGIN
	VertPos: Top = Previous . Bottom;
	Width: Enclosed . Width;
	END;
   END;

BOXES

{ presentation boxes }

   ElementName: BEGIN
	Content: (ElemName);
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style;
		Weight: TAG_Weight;
		Visibility: TAG_Visibility;
		Foreground: TAG_Color;
		END;
	END;

   VerticalLine: BEGIN
	Content: Graphics 'W';
	Visibility: 0;
	IN Structure_view BEGIN
		VertPos: Top = Creator . Top;
		HorizPos: Left = Enclosing . Left;
		Height: Creator . Height;
		Width: 1.1;
		LineWeight: 1 px;
		Visibility: TAG_Visibility;
		Foreground: TAG_Color;
		END;
	END;

   AttrName: BEGIN
	Content: (Text ' ' AttributeName Text '=');
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style;
 		Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;
		Foreground: ATTR_Color;
		END;
	END;

   AttrValue: BEGIN
	Content: (AttributeValue);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Style: ATTR_Style;
		Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;
		Foreground: ATTRVALUE_Color;
		END;
	END;

  ATTR_xml_space_default: BEGIN
	Content: Text ' xml:space=default';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

  ATTR_xml_space_preserve: BEGIN
	Content: Text ' xml:space=preserve';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

   Comment_Start:
	BEGIN
	Content: Text '<!--';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		END;
	END;

   Comment_End:
	BEGIN
	Content: Text '-->';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		END;
	END;

   PI_Start:
	BEGIN
	Content: Text '<?';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		END;
	END;

   PI_End:
	BEGIN
	Content: Text '?>';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		END;
	END;

 IndexBox: BEGIN
	Content: Picture 'index.gif';
	HorizPos: Left = Root . Left;
	VertPos: Top = Creator . Top;
	VertOverflow : Yes;
	HorizOverflow : Yes;
	Width : Enclosed . Width;
	Inline: No;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;

 EmptyBox: BEGIN
	Content: Text '<>';
	Width : Enclosed . Width;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	END;

 DOCTYPE_S: BEGIN
	Content: Text '<!DOCTYPE ';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		Size: TAG_FONTSIZE;
		END;
	END;

 DOCTYPE_E: BEGIN
	Content: Text '>';
	Visibility: 0;
	IN Structure_view BEGIN
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		Visibility: Enclosing =;
		Foreground: TAG_Color;
		Size: TAG_FONTSIZE;
		END;
	END;

RULES

   Document:
	BEGIN
	Depth: 0;
	Adjust: Left;
	Indent: 0;
	Font: Times;
	Style: Roman;
	Weight: Normal;
	LineWeight: 0;
	Height: Enclosing . Height min;
	Size: DOC_FONTSIZE;
	PaddingBottom: 2 cm;
	PaddingLeft: 0.5 cm;
	PaddingRight: 0.5 cm;
	IN Structure_view BEGIN
		Visibility: 10;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left;
		PaddingLeft: 0.4;
		Font: Helvetica;
		END;
	END;

   XML:
	BEGIN
	VertPos: Top = Enclosing . Top;
	CreateBefore(ElementName);
	CreateWith(VerticalLine);
	IN Structure_view BEGIN
		VertPos: Top = Previous . Bottom;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	        END;
	END;

   XMLcomment:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: COMMENT_Visibility;
		Font: COMMENT_Font;
		Style: COMMENT_Style; Weight: COMMENT_Weight;
		Width: Enclosing . Width ;
		END;
	END;

   XMLcomment_line:
        BEGIN
        IF First CreateFirst(Comment_Start);
        IF Last CreateLast(Comment_End);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: COMMENT_Visibility;
		Width: Enclosed . Width;
		VertPos: Top = Previous . Bottom + 0.2;
		END;
        END;

   XMLPI:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: COMMENT_Visibility;
		Font: COMMENT_Font;
		Style: COMMENT_Style; Weight: COMMENT_Weight;
		Width: Enclosing . Width;
		END;
	END;

   XMLPI_line:
        BEGIN
        IF First CreateFirst(PI_Start);
        IF Last CreateLast(PI_End);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: COMMENT_Visibility;
		Width: Enclosed . Width;
		VertPos: Top = Previous . Bottom + 0.2;
		END;
        END;


  DOCTYPE:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosing . Width;
		END;
	END;

  DOCTYPE_line:
	BEGIN
	Visibility: 0;
	IF First CreateFirst(DOCTYPE_S);
	IF Last CreateLast(DOCTYPE_E);
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Width: Enclosed . Width;
		VertPos: Top = Previous . Bottom;
		END;
	END;

   TEXT_UNIT:
	BEGIN
	Width: Enclosed . Width;
	IN Structure_view BEGIN
		if NOT within XMLcomment_line AND NOT within XMLPI_line AND NOT within DOCTYPE_line
		   BEGIN
		   HorizPos: Left = Enclosing . Left;
		   VertPos: Top = Previous . Bottom;
		   END;
		if within XMLcomment_line BEGIN
		   HorizPos: Left = Previous . Right;
                   VertPos: HRef = Previous . HRef;
		   END;
		if within XMLPI_line BEGIN
		   HorizPos: Left = Previous . Right;
                   VertPos: HRef = Previous . HRef;
		   END;
		if within DOCTYPE_line
                   BEGIN
		   HorizPos: Left = Previous . Right;
                   VertPos: HRef = Previous . HRef;
                   END;
		END;
	END;

   GRAPHICS_UNIT:
	BEGIN
	Visibility: Enclosing =;
	Height: Enclosing . Height;
	Width: Enclosing . Width;	
	IN Structure_view
	   Visibility: 0;
	END;

   PICTURE_UNIT:
	BEGIN
	CreateBefore(ElementName);
	LineBreak: No;
	PageBreak: No;
	HorizRef: * . Bottom;
	IN Structure_view BEGIN
		Height: 0;
		Width: 0;
		Visibility: 1;
		VertPos: Top = Previous . Bottom;
		HorizPos: Left = Enclosing . Left;
		END;
	END;

ATTRIBUTES

  id:
        BEGIN
        CreateBefore(AttrName);
        CreateBefore(AttrValue);
        END;

  class:
        BEGIN
        CreateBefore(AttrName);
        CreateBefore(AttrValue);
        END;

  xml_space = xml_space_default:
	CreateBefore (ATTR_xml_space_default);

  xml_space = xml_space_preserve:
	CreateBefore (ATTR_xml_space_preserve);

  Highlight:
	BEGIN
        if TEXT_UNIT
	   CreateAfter (IndexBox);
        if SYMBOL_UNIT
	   CreateAfter (IndexBox);
        if PICTURE_UNIT
	   CreateAfter (IndexBox);
	if not TEXT_UNIT and not SYMBOL_UNIT and not PICTURE_UNIT
	   CreateLast (IndexBox);
	END;

{ 
  bar:
	BEGIN
	CreateBefore(AttrName);
	CreateBefore(AttrValue);
	END;
}

END
