	{ Thot presentation schema for GraphML

	  V. Quint	February 1998	}

PRESENTATION GraphML;

VIEWS
   Formatted_view,
   Structure_view merge with Structure_view,
   Alternate_view merge with Alternate_view;

#define STRUCT_INDENT 1.5
#define TAG_FONTSIZE 12 pt
#define DOC_FONTSIZE 12 pt
#define TAG_Style Roman
#define TAG_Weight Normal
#define TAG_Visibility 7
#define ATTR_Style Roman
#define ATTR_Weight Normal
#define ATTR_Visibility 6
#define ALT_Visibility 8
 
#ifdef BLACK_WHITE
#define TAG_Color Black
#define ATTR_Color Black
#define ATTRVALUE_Color Black
#else
#define TAG_Color Blue
#define ATTR_Color Blue
#define ATTRVALUE_Color Black
#endif
 
#define TAG_Font Helvetica
#define ATTR_Font Helvetica

DEFAULT

   BEGIN
   HorizRef: * . Top;
   VertRef: * . Left;
   HorizPos: Left = Enclosing . Left;
   VertPos:  Top = Enclosing . Top;
   Visibility: Enclosing =;
   FillPattern: Enclosing =;
   Depth: Enclosing =;
   IN Structure_view
	BEGIN
	VertPos: Top = Previous . Bottom;
	Width: Enclosed . Width;
	END;
   IN Alternate_view
	BEGIN
	VertPos: Top = Previous . Bottom;
	Width: Enclosing . Width;
	Height: Enclosed . Height;
	END;
   END;

BOXES

   SVG_S: BEGIN
	Content: Text 'svg';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   G_S:
	BEGIN
	Content: Text 'g';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   DEFS_S:
	BEGIN
	Content: Text 'defs';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   SPLINE_S:
	BEGIN
	Content: Text 'spline';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   CLOSEDSPLINE_S:
	BEGIN
	Content: Text 'closedspline';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   RECT_S:
	BEGIN
	Content: Text 'rect';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   CIRCLE_S:
	BEGIN
	Content: Text 'circle';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   ELLIPSE_S:
	BEGIN
	Content: Text 'ellipse';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   LINE_S:
	BEGIN
	Content: Text 'line';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   POLYLINE_S:
	BEGIN
	Content: Text 'polyline';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   POLYGON_S:
	BEGIN
	Content: Text 'polygon';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   TEXT_S:
	BEGIN
	Content: Text 'text';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   TSPAN_S:
	BEGIN
	Content: Text 'tspan';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   USE_S:
	BEGIN
	Content: Text 'use';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   IMAGE_S:
	BEGIN
	Content: Text 'image';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   SYMBOL_S:
	BEGIN
	Content: Text 'symbol';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   DESC_S:
	BEGIN
	Content: Text 'desc';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   TITLE_S:
	BEGIN
	Content: Text 'title';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   A_S:
	BEGIN
	Content: Text 'a';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   SCRIPT_S:
	BEGIN
	Content: Text 'script';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   STYLE_S:
	BEGIN
	Content: Text 'style';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   FOREIGNOBJECT_S:
	BEGIN
	Content: Text 'foreignObject';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   METADATA_S:
	BEGIN
	Content: Text 'metadata';
	Visibility: 0;
	IN Structure_view BEGIN
		Size: TAG_FONTSIZE;
		Font: TAG_Font;
		Style: TAG_Style; Weight: TAG_Weight;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

{ Boxes for diplaying attributes and their value }

  ATTR_id: BEGIN
        Content: Text ' id=';
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
        END;
  VALUE_id: BEGIN
        Content: (id);
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
                END;
        END;

  ATTR_class: BEGIN
        Content: Text ' class=';
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
        END;
  VALUE_class: BEGIN
        Content: (class);
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
                END;
        END;
 
  ATTR_style: BEGIN
        Content: Text ' style=';
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
                END;
        END;
  VALUE_style: BEGIN
        Content: (style_);
        Visibility: 0;
        IN Structure_view BEGIN
                HorizPos: Left = Previous . Right;
                VertPos: HRef = Previous . HRef;
                Size: TAG_FONTSIZE;
                Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
                Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
                END;
        END;

 ATTR_xml_space_default: BEGIN
	Content: Text ' xml:space=default';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

 ATTR_xml_space_preserve: BEGIN
	Content: Text ' xml:space=preserve';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

   ATTR_viewBox: BEGIN
	Content: Text '  viewBox=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_viewBox: BEGIN
	Content: (viewBox);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_x: BEGIN
	Content: Text '  x=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_x: BEGIN
	Content: (x);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_y: BEGIN
	Content: Text '  y=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_y: BEGIN
	Content: (y);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_height_: BEGIN
	Content: Text '  height=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_height_: BEGIN
	Content: (height_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_width_: BEGIN
	Content: Text '  width=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_width_: BEGIN
	Content: (width_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_fill: BEGIN
	Content: Text '  fill=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_fill: BEGIN
	Content: (fill);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_stroke: BEGIN
	Content: Text '  stroke=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_stroke: BEGIN
	Content: (stroke);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_stroke_width: BEGIN
	Content: Text '  stroke-width=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_stroke_width: BEGIN
	Content: (stroke_width);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_transform: BEGIN
	Content: Text '  transform=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_transform: BEGIN
	Content: (transform);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_linestyle_solid: BEGIN
	Content: Text '  linestyle=solid';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

   ATTR_linestyle_dashed: BEGIN
	Content: Text '  linestyle=dashed';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

   ATTR_linestyle_dotted: BEGIN
	Content: Text '  linestyle=dotted';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

   ATTR_extResourcesReq_false: BEGIN
	Content: Text '  externalResourcesRequired=false';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   ATTR_extResourcesReq_true: BEGIN
	Content: Text '  externalResourcesRequired=true';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

   ATTR_points: BEGIN
	Content: Text '  points=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_points: BEGIN
	Content: (points);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_arrowhead_none: BEGIN
	Content: Text '  arrowhead=none';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   ATTR_arrowhead_start: BEGIN
	Content: Text '  arrowhead=start';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   ATTR_arrowhead_end_: BEGIN
	Content: Text '  arrowhead=end';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   ATTR_arrowhead_both: BEGIN
	Content: Text '  arrowhead=both';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;

   ATTR_cx: BEGIN
	Content: Text '  cx=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_cx: BEGIN
	Content: (cx);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_cy: BEGIN
	Content: Text '  cy=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_cy: BEGIN
	Content: (cy);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_r: BEGIN
	Content: Text '  r=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_r: BEGIN
	Content: (r);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_rx: BEGIN
	Content: Text '  rx=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_rx: BEGIN
	Content: (rx);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_ry: BEGIN
	Content: Text '  ry=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_ry: BEGIN
	Content: (ry);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_x1: BEGIN
	Content: Text '  x1=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_x1: BEGIN
	Content: (x1);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_y1: BEGIN
	Content: Text '  y1=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_y1: BEGIN
	Content: (y1);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_x2: BEGIN
	Content: Text '  x2=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_x2: BEGIN
	Content: (x2);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_y2: BEGIN
	Content: Text '  y2=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_y2: BEGIN
	Content: (y2);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_dx: BEGIN
	Content: Text '  dx=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_dx: BEGIN
	Content: (dx);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_dy: BEGIN
	Content: Text '  dy=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_dy: BEGIN
	Content: (dy);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_xlink_href: BEGIN
	Content: Text '  xlink:href=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_xlink_href: BEGIN
	Content: (xlink_href);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_preserveAspectRatio: BEGIN
	Content: Text '  preserveAspectRatio=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_preserveAspectRatio: BEGIN
	Content: (preserveAspectRatio);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_target: BEGIN
	Content: Text '  target=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_target: BEGIN
	Content: (target_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_type: BEGIN
	Content: Text '  type=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_type: BEGIN
	Content: (type);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_media: BEGIN
	Content: Text '  media=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_media: BEGIN
	Content: (media);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

   ATTR_title: BEGIN
	Content: Text '  title=';
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTR_Color;
		END;
	END;
   VALUE_title: BEGIN
	Content: (title_);
	Visibility: 0;
	IN Structure_view BEGIN
		HorizPos: Left = Previous . Right;
		VertPos: HRef = Previous . HRef;
		Size: TAG_FONTSIZE;
		Font: ATTR_Font; Style: ATTR_Style; Weight: ATTR_Weight;
		Visibility: ATTR_Visibility;  Foreground: ATTRVALUE_Color;
		END;
	END;

{ presentation boxes }

   VerticalLine: BEGIN
	Content: Graphics 'W';
	Visibility: 0;
	IN Structure_view BEGIN
		VertPos: Top = Creator . Top;
		HorizPos: Left = Enclosing . Left;
		Height: Creator . Height;
		Width: 1.1;
		LineWeight: 1 px;
		Visibility: TAG_Visibility;  Foreground: TAG_Color;
		END;
	END;

   Comment_Start:
	BEGIN
	Content: Text '<!--';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		END;
	END;

   Comment_End:
	BEGIN
	Content: Text '-->';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		END;
	END;

   PI_Start:
	BEGIN
	Content: Text '<?';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		END;
	END;

   PI_End:
	BEGIN
	Content: Text '?>';
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		HorizRef: Enclosed . HRef;
		Foreground: TAG_Color;
		VertPos: HRef = Previous . HRef;
		HorizPos: Left = Previous . Right;
		END;
	END;

 IndexBox: BEGIN
	Content: Picture 'index.gif';
	HorizPos: Left = Root . Left;
	VertPos: Top = Creator . Top;
	VertOverflow : Yes;
	HorizOverflow : Yes;
	Inline: No;
	Visibility: Creator =;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

RULES

   GraphML:
	BEGIN
	CreateBefore(SVG_S);
        CreateWith(VerticalLine);
	HorizRef: *.Bottom;
        Width: 10 cm;
        Height: 5 cm;
        if NOT within GraphML BEGIN
           VertPos: Top = Previous . Bottom;
	   Foreground: transparent;
	   Background: Black;
	   FillPattern: backgroundcolor;
	END;
	PageBreak: No;
	LineBreak: No;
	Justify: No;
	Hyphenate: No;
	Gather: Yes;
	LineWeight: 1 pt;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
	        if not within use_
		    Visibility: 10;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
        	Height	: Enclosed . Height;
		Font: TAG_Font;
		Foreground: Enclosing =;
	        Background: Enclosing =;
	        FillPattern: nopattern;
		END;
	IN Alternate_view BEGIN
		Width: Enclosing . Width;
        	Height	: Enclosed . Height;
	   	MarginTop: 0;
	   	MarginBottom: 0;
		Foreground: Enclosing =;
	        Background: Enclosing =;
	        FillPattern: nopattern;
		END;		
	END;

   g:
	BEGIN
	CreateBefore (G_S);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   defs:
	BEGIN
	CreateBefore (DEFS_S);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	END;

   Spline:
	BEGIN
	CreateBefore (SPLINE_S);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	MarginTop: 5 px;
	MarginLeft: 5 px;
	MarginBottom: 5 px;
	MarginRight: 5 px;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		MarginTop: 0;
		MarginLeft: 0;
		MarginBottom: 0;
		MarginRight: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   ClosedSpline:
	BEGIN
	CreateBefore (CLOSEDSPLINE_S);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	MarginTop: 5 px;
	MarginLeft: 5 px;
	MarginBottom: 5 px;
	MarginRight: 5 px;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		MarginTop: 0;
		MarginLeft: 0;
		MarginBottom: 0;
		MarginRight: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   rect:
	BEGIN
	CreateBefore (RECT_S);
	CreateWith (VerticalLine);
	Width: 2.5 cm UserSpecified;
	Height: 1.5 cm UserSpecified;
	HorizPos: Left = Enclosing . Left + 1 pt UserSpecified;
	VertPos:  Top = Enclosing . Top + 1 pt UserSpecified;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   circle:
	BEGIN
	CreateBefore (CIRCLE_S);
	CreateWith (VerticalLine);
	Width: 2 cm UserSpecified;
	Height: * . Width;
	HorizPos: VMiddle = Enclosing . Left + 1 cm  UserSpecified;
	VertPos:  HMiddle = Enclosing . Top + 1 cm  UserSpecified;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   ellipse:
	BEGIN
	CreateBefore (ELLIPSE_S);
	CreateWith (VerticalLine);
	Width: 2.5 cm UserSpecified;
	Height: 1.5 cm UserSpecified;
	HorizPos: VMiddle = Enclosing . Left + 1.3 cm  UserSpecified;
	VertPos:  HMiddle = Enclosing . Top + 0.8 cm  UserSpecified;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   line_:
	BEGIN
	CreateBefore (LINE_S);
        HorizPos: Left = Enclosing . Left + 1 pt UserSpecified;
        VertPos:  Top = Enclosing . Top + 1 pt UserSpecified;
        Width: Right = Enclosing . Left + 4 pt;
        Height:  Bottom = Enclosing . Top + 4 pt;
       	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   polyline:
	BEGIN
	CreateBefore (POLYLINE_S);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   polygon:
	BEGIN
	CreateBefore (POLYGON_S);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   text_:
	BEGIN
	CreateBefore (TEXT_S);
	CreateWith (VerticalLine);
	Width: Enclosed . Width;
   	HorizPos: Left = Enclosing . Left + 1 pt Userspecified;
   	VertPos:  HRef = Enclosing . Top + 10 pt Userspecified;
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Height: Enclosed . Height;
		Width: Enclosing . Width;
		END;
	END;

   tspan:
	BEGIN
	CreateBefore (TSPAN_S);
	CreateWith (VerticalLine);
	HorizPos: Left = Previous . Right;
	VertPos:  HRef = Previous . HRef;
	HorizRef: Enclosed . HRef;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Height: Enclosed . Height;
	        Width: Enclosed . Width;
		HorizPos: Left = Previous . Right;
		VertPos:  HRef = Previous . HRef;
		END;	
	END;

   use_:
	BEGIN
	CreateBefore (USE_S);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   image:
	BEGIN
	CreateBefore (IMAGE_S);
	CreateWith (VerticalLine);
   	HorizPos: Left = Enclosing . Left + 1 pt Userspecified;
   	VertPos:  HRef = Enclosing . Top + 10 pt Userspecified;
	Width: Enclosed . Width;
        Height: Enclosed . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   symbol_:
	BEGIN
	CreateBefore (SYMBOL_S);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   desc:
	BEGIN
	CreateBefore (DESC_S);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Visibility: ALT_Visibility;
		Line;
		END;
	END;

   title:
	BEGIN
	CreateBefore (TITLE_S);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Visibility: ALT_Visibility;
		Line;
		END;
	END;

   a:
	BEGIN
	CreateBefore (A_S);
	CreateWith (VerticalLine);
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		Height: Enclosed . Height;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view
		Visibility: 0;
	END;

   script:
	BEGIN
	CreateBefore (SCRIPT_S);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	END;

   style__:
	BEGIN
	CreateBefore (STYLE_S);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	END;

   foreignObject:
	BEGIN
	CreateBefore (FOREIGNOBJECT_S);
	CreateWith (VerticalLine);
   	HorizPos: Left = Enclosing . Left + 1 pt Userspecified;
   	VertPos:  HRef = Enclosing . Top + 10 pt Userspecified;
	Foreground: Black;
	FillPattern: nopattern;
	Background: transparent;
	IN Structure_view BEGIN
	        if within use_
	            Visibility: 0;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Height: Enclosed . Height;
		Width: Enclosing . Width;
		VertPos: Top = Previous . Bottom;
		END;
	END;

   metadata:
	BEGIN
	CreateBefore (METADATA_S);
	CreateWith (VerticalLine);
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: Enclosing =;
		Size: DOC_FONTSIZE;
		Width: Enclosing . Width - STRUCT_INDENT;
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
		Font: TAG_Font;
		END;
	IN Alternate_view BEGIN
		Visibility: ALT_Visibility;
		Line;
		END;
	END;

   XMLcomment:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: 10;
		Width: Enclosing . Width ;
		END;
	END;

   XMLcomment_line:
        BEGIN
        IF First CreateFirst(Comment_Start);
        IF Last CreateLast(Comment_End);
	IN Structure_view BEGIN
	        HorizPos: Left = Enclosing . Left;
	        VertPos: Top = Previous . Bottom + 0.2;
	        Width: Enclosed . Width;
		END;
        END;

   XMLPI:
	BEGIN
	Visibility: 0;
	IN Structure_view BEGIN
		Visibility: 10;
		Width: Enclosing . Width ;
		END;
	END;

   XMLPI_line:
        BEGIN
        IF First CreateFirst(PI_Start);
        IF Last CreateLast(PI_End);
	IN Structure_view BEGIN
	        HorizPos: Left = Enclosing . Left;
	        VertPos: Top = Previous . Bottom + 0.2;
	        Width: Enclosed . Width;
		END;
        END;

   TEXT_UNIT:
	BEGIN
	HorizRef: Enclosed . HRef;
	HorizPos: Left = Previous . Right;
        VertPos: HRef = Previous . HRef;
	Width: Enclosed . Width;
        Height: Enclosed . Height;
	IN Structure_view BEGIN
		if NOT within XMLcomment_line AND NOT within XMLPI_line
		   BEGIN
		   HorizPos: Left = Enclosing . Left;
		   VertPos: Top = Previous . Bottom;
		   END;
		if within XMLcomment_line BEGIN
		   HorizPos: Left = Previous . Right;
                   VertPos: HRef = Previous . HRef;
		   END;
		if within XMLPI_line BEGIN
		   HorizPos: Left = Previous . Right;
                   VertPos: HRef = Previous . HRef;
		   END;
		END;
	IN Alternate_view BEGIN
	        Width: Enclosed . Width;
        	VertPos: HRef = Previous . HRef;
		END;
	END;

   GRAPHICS_UNIT:
	BEGIN
	Width: Enclosing . Width;
	Height: Enclosing . Height;
	Depth: Enclosing + 2;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

   PICTURE_UNIT:
	BEGIN
	Width: Enclosing . Width;
        Height: Enclosing . Height;
	Depth: Enclosing + 2;
	IN Structure_view
		Visibility: 0;
	IN Alternate_view
		Visibility: 0;
	END;

ATTRIBUTES

  id:
        BEGIN
        CreateBefore(ATTR_id);
        CreateBefore(VALUE_id);
        END;

  class:
        BEGIN
        CreateBefore(ATTR_class);
        CreateBefore(VALUE_class);
        END;
 
  style_:
        BEGIN
        CreateBefore(ATTR_style);
        CreateBefore(VALUE_style);
        END;
 
  xml_space = xml_space_default:
	CreateBefore (ATTR_xml_space_default);

  xml_space = xml_space_preserve:
	CreateBefore (ATTR_xml_space_preserve);

  Highlight:
	BEGIN
        if TEXT_UNIT
	   CreateAfter (IndexBox);
	if NOT TEXT_UNIT
	   CreateLast (IndexBox);
	END;

  viewBox:
        BEGIN
        CreateBefore(ATTR_viewBox);
        CreateBefore(VALUE_viewBox);
        END;

  x:
	BEGIN
	CreateBefore (ATTR_x);
	CreateBefore (VALUE_x);
   	HorizPos: Left = Enclosing . Left;
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	END;

  y:
	BEGIN
	CreateBefore (ATTR_y);
	CreateBefore (VALUE_y);
	if not text_
   	        VertPos:  Top = Enclosing . Top;
	if text_
	        VertPos:  HRef = Enclosing . Top;
   	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

  height_:
	BEGIN
	CreateBefore (ATTR_height_);
	CreateBefore (VALUE_height_);
	END;

  width_:
	BEGIN
	CreateBefore (ATTR_width_);
	CreateBefore (VALUE_width_);
	END;

  fill:
	BEGIN
	CreateBefore (ATTR_fill);
	CreateBefore (VALUE_fill);
	END;

  stroke:
	BEGIN
	CreateBefore (ATTR_stroke);
	CreateBefore (VALUE_stroke);
	END;

  stroke_width:
	BEGIN
	CreateBefore (ATTR_stroke_width);
	CreateBefore (VALUE_stroke_width);
	END;

  transform:
	BEGIN
	CreateBefore (ATTR_transform);
	CreateBefore (VALUE_transform);
	END;

  linestyle_ = solid_:
	BEGIN
	CreateBefore (ATTR_linestyle_solid);
	LineStyle: Solid;
	IN Structure_view
		LineStyle: Enclosing =;
	END;
  linestyle_ = dashed_:
	BEGIN
	CreateBefore (ATTR_linestyle_dashed);
	LineStyle: Dashed;
	IN Structure_view
		LineStyle: Enclosing =;
	END;
  linestyle_ = dotted_:
	BEGIN
	CreateBefore (ATTR_linestyle_dotted);
	LineStyle: Dotted;
	IN Structure_view
		LineStyle: Enclosing =;
	END;

  externalResourcesRequired = false:
	CreateBefore (ATTR_extResourcesReq_false);
  externalResourcesRequired = true:
	CreateBefore (ATTR_extResourcesReq_true);

  points:
	BEGIN
	CreateBefore (ATTR_points);
	CreateBefore (VALUE_points);
	END;

  arrowhead = none_:
	CreateBefore (ATTR_arrowhead_none);
  arrowhead = start:
	CreateBefore (ATTR_arrowhead_start);
  arrowhead = end_:
	CreateBefore (ATTR_arrowhead_end_);
  arrowhead = both:
	CreateBefore (ATTR_arrowhead_both);

  cx:
	BEGIN
	CreateBefore (ATTR_cx);
	CreateBefore (VALUE_cx);
	IN Structure_view
		HorizPos: Left = Enclosing . Left + STRUCT_INDENT;
	IN Alternate_view
		HorizPos: Left = Enclosing . Left;
	END;

  cy:
	BEGIN
	CreateBefore (ATTR_cy);
	CreateBefore (VALUE_cy);
   	IN Structure_view
		VertPos: Top = Previous . Bottom;
	IN Alternate_view
		VertPos: Top = Previous . Bottom;
	END;

  r:
	BEGIN
	CreateBefore (ATTR_r);
	CreateBefore (VALUE_r);
	END;

  rx:
	BEGIN
	CreateBefore (ATTR_rx);
	CreateBefore (VALUE_rx);
	END;

  ry:
	BEGIN
	CreateBefore (ATTR_ry);
	CreateBefore (VALUE_ry);
	END;

  x1:
	BEGIN
	CreateBefore (ATTR_x1);
	CreateBefore (VALUE_x1);
	END;

  y1:
	BEGIN
	CreateBefore (ATTR_y1);
	CreateBefore (VALUE_y1);
	END;

  x2:
	BEGIN
	CreateBefore (ATTR_x2);
	CreateBefore (VALUE_x2);
	END;

  y2:
	BEGIN
	CreateBefore (ATTR_y2);
	CreateBefore (VALUE_y2);
	END;

  dx:
	BEGIN
	CreateBefore (ATTR_dx);
	CreateBefore (VALUE_dx);
	END;

  dy:
	BEGIN
	CreateBefore (ATTR_dy);
	CreateBefore (VALUE_dy);
	END;

  xlink_href:
	BEGIN
	CreateBefore (ATTR_xlink_href);
	CreateBefore (VALUE_xlink_href);
	END;

  preserveAspectRatio:
	BEGIN
	CreateBefore (ATTR_preserveAspectRatio);
	CreateBefore (VALUE_preserveAspectRatio);
	END;

  target_:
	BEGIN
	CreateBefore (ATTR_target);
	CreateBefore (VALUE_target);
	END;

  type:
	BEGIN
	CreateBefore (ATTR_type);
	CreateBefore (VALUE_type);
	END;

  media:
	BEGIN
	CreateBefore (ATTR_media);
	CreateBefore (VALUE_media);
	END;

  title_:
	BEGIN
	CreateBefore (ATTR_title);
	CreateBefore (VALUE_title);
	END;
  
END
