/* 
   WebDAV 207 multi-status response handling
   Copyright (C) 1999-2000, Joe Orton <joe@orton.demon.co.uk>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.
  
   Alternatively, you can redistribute it and/or modify it under the
   terms of the GNU Library General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at
   your option) any later version.

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   License for more details.

   You should have received copies of the GNU Library General Public
   License and the GNU General Public License along with this software; 
   if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
   Cambridge, MA 02139, USA.

*/

#ifndef DAV207_H
#define DAV207_H

#include "hip_xml.h"
#include "http_utils.h" /* for struct http_status */

/* You handle everything inside DAV:prop.
 * This provides handling for everything outside it. */

/* The multi-status DAV elements */

#define DAV_ELM_multistatus (1001)
#define DAV_ELM_response (1002)
#define DAV_ELM_responsedescription (1003)
#define DAV_ELM_href (1004)
#define DAV_ELM_propstat (1005)
#define DAV_ELM_prop (1006)
#define DAV_ELM_status (1007)

struct dav_propstat {
    void *prop; /* for you to store your property information in */
    struct http_status status;
    char *status_line;
    char *description;
    struct dav_propstat *next;
};

struct dav_response {
    char *href;
    struct http_status status;
    char *status_line;
    struct dav_propstat *first;
    struct dav_propstat *last;
    struct dav_propstat *current;
    struct dav_response *next;
};

struct dav_multistatus {
    struct dav_response *first;
    struct dav_response *last;
    struct dav_response *current;
    char *description;
};

extern const struct hip_xml_elm dav_207_elms[];

struct dav_207_parser {
    struct dav_multistatus ms;
    struct dav_response *current;
    void *private; /* use to store any private info */
    struct hip_xml_elmlist *list_207; /* FIXME: hack */
    struct hip_xml_parser parser;
};

/* layer on top of hip_xml_init */
int dav_207_init( struct dav_207_parser *ctx, struct hip_xml_elmlist *list );
int dav_207_finish( struct dav_207_parser *p );

int dav_207_startelm( void *userdata, const struct hip_xml_state *s,
		      const char *name, const char ** atts );
int dav_207_endelm( void *userdata, const struct hip_xml_state *s,
		    const char *cdata );

/* Frees the response... 
 * calling freeprop(userdata,prop) to free the props found */
void dav_207_free( struct dav_207_parser *ctx,
		   void (*freeprop)( void *ud, struct dav_response *rsp,
				     struct dav_propstat *pstat ), 
		   void *userdata );

int dav_207_check( hip_xml_elmid parent, hip_xml_elmid child );

int dav_207_getcurrentpropstat( struct dav_207_parser *p, 
				struct dav_propstat **pstat );

#endif /* DAV207_H */
