/* 
   WebDAV Redirect References
   Copyright (C) 2000, Joe Orton <joe@orton.demon.co.uk>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.
  
   Alternatively, you can redistribute it and/or modify it under the
   terms of the GNU Library General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at
   your option) any later version.

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   License for more details.

   You should have received copies of the GNU Library General Public
   License and the GNU General Public License along with this software; 
   if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
   Cambridge, MA 02139, USA.

   $Id: dav_redref.c,v 1.4 2000/03/08 19:52:18 joe Exp $   
*/

/* WebDAV Redirect Reference support.
 * Written to draft-ietf-webdav-redirectref-protocol-02.txt.
 */

#include <config.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "dav_redref.h"
#include "string_utils.h"
#include "httpdav.h"

/* Creates a redirect reference resource at URI, with given target. */
int dav_mkref( const char *uri, const char *target ) {
    http_req_t req;
    sbuffer body;
    int ret;

    body = sbuffer_create();
    if( body == NULL ) {
	return PROTO_ERROR;
    }
    
    if( sbuffer_concat( 
	body, "<?xml version='1.0'?><propertyupdate xmlns='DAV:'>"
	"<set><prop><resourcetype><redirectref/></resourcetype>"
	"<reftarget><href>", target, "</href></reftarget></prop></set>"
	"</propertyupdate>", NULL ) ) {
	return PROTO_ERROR;
    }
    
    http_request_init( &req, "MKRESOURCE", uri );
    req.body_buffer = sbuffer_data(body);
    req.body = http_body_buffer;
    strcat( req.headers, "Content-type: text/xml" );
    
    ret = http_request( &req );
    
    if( ret != PROTO_OK || req.class == 207 ) {
	/* TODO: 207 response handling. */
	ret = PROTO_ERROR;
    }
    
    http_request_end( &req );
    sbuffer_destroy( body );
    
    return ret;
}

/* Is the resource at URI a redirect reference resource?
 * Returns:
 *   PROTO_OK:      yes it is
 *   PROTO_FAILED:  oh no it isn't
 *   PROTO_ERROR:   fatal error
 */
int dav_isref( const char *uri ) {
    /* PROPFIND on URI, check DAV:resourcetype */
    return PROTO_ERROR;
}

/* Removes the reference resource at URI */
int dav_rmref( const char *uri ) {
    return PROTO_ERROR;
}
