/* 
   WebDAV Redirect References
   Copyright (C) 2000, Joe Orton <joe@orton.demon.co.uk>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.
  
   Alternatively, you can redistribute it and/or modify it under the
   terms of the GNU Library General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at
   your option) any later version.

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   License for more details.

   You should have received copies of the GNU Library General Public
   License and the GNU General Public License along with this software; 
   if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
   Cambridge, MA 02139, USA.

*/

#ifndef DAV_REDREF_H
#define DAV_REDREF_H

/* Creates a redirect reference resource at URI, with given target. */
int dav_mkref( const char *uri, const char *target );

/* Is the resource at URI a redirect reference resource?
 * Returns:
 *   PROTO_OK:      yes, it is
 *   PROTO_FAILED:  no, it isn't
 *   PROTO_ERROR:   fatal error
 */
int dav_isref( const char *uri );

/* Removes the reference resource at URI */
int dav_rmref( const char *uri );

/* ??? Modifies a reference resource at URI to point to new target. */
int dav_chref( const char *uri, const char *target );

#endif /* DAV_REDREF_H */
