/* 
   HTTP utility functions
   Copyright (C) 1999-2000, Joe Orton <joe@orton.demon.co.uk>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.
  
   Alternatively, you can redistribute it and/or modify it under the
   terms of the GNU Library General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at
   your option) any later version.

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   License for more details.

   You should have received copies of the GNU Library General Public
   License and the GNU General Public License along with this software; 
   if not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
   Cambridge, MA 02139, USA.

*/

#ifndef HTTP_UTILS_H
#define HTTP_UTILS_H

#include <config.h>

#include <sys/types.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif

#ifdef HAVE_DEBUG_FUNC
#include "common.h"
#endif

#define HTTP_QUOTES "\"'"
#define HTTP_WHITESPACE " \r\n\t"

/* Handy macro to free things. */
#define HTTP_FREE(x) \
do { if( (x)!=NULL ) free( (x) ); (x) = NULL; } while(0)

#define EOL "\r\n"
#define HTTP_PORT 80

time_t http_dateparse( const char *date );

#undef min
#define min(a,b) ((a)<(b)?(a):(b))

#ifndef HAVE_DEBUG_FUNC
/* CONSIDER: mutt has a nicer way of way of doing debugging output... maybe
 * switch to like that. */
#ifdef DEBUGGING
#define DEBUG if(0) http_debug
#else /* !DEBUGGING */
#define DEBUG http_debug
#endif /* DEBUGGING */

void http_debug( int ch, char *, ... )
#ifdef __GNUC__
                __attribute__ ((format (printf, 2, 3)))
#endif /* __GNUC__ */
;

#endif /* HAVE_DEBUG_FUNC */

/* Storing an HTTP status result */
struct http_status {
    int major_version;
    int minor_version;
    int status_code;
    int class;
    const char *reason_phrase;
};

/* Parser for strings which follow the Status-Line grammar from 
 * RFC2616.
 *  Returns:
 *    0 on success, *s will be filled in.
 *   -1 on parse error.
 */
int http_parse_statusline( const char *status_line, struct http_status *s );

#endif /* HTTP_UTILS_H */
