/* 
   cadaver, command-line DAV client
   Copyright (C) 1999-2000, Joe Orton <joe@orton.demon.co.uk>
                                                                     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef COMMANDS_H
#define COMMANDS_H

#if 0
#include "propedit.h"
#endif

extern bool child_running; /* true when we have a child running */

const struct command *get_command( const char *name );

char *resolve_path( const char *path, const char *filename, bool isdir );

int is_collection( const char *res );

void init_locking(const char *fn);
void finish_locking(const char *fn);

/* 0-ary functions (okay, not really functions then I suppose) */
void execute_lpwd( void );
void execute_showlocks(void );
void execute_pwd( void );

/* 1-ary */
void execute_help( const char *arg );
void execute_mkcol( const char *filename );
void execute_delete( const char *filename );
void execute_rmcol( const char *filename );
void execute_cat( const char *filename );
void execute_less( const char *filename );
void execute_ls( const char *path );
void execute_lcd( const char *path );
void execute_cd( const char *path );
void execute_lock( const char *lock );
void execute_unlock( const char *res );
void execute_discover( const char *res );
void execute_steal( const char *res );
void execute_edit( const char *remote );

void execute_propnames( const char *res );

/* 2-ary */
void execute_get( const char *remote, const char *local );
void execute_put( const char *local, const char *remote );

/* many-ary */
void execute_lls( int argc, char * const argv[] );
void execute_echo( int count, const char **many );
void multi_mget( int argc, const char *argv[] );
void multi_mput( int argc, const char *argv[] );
void multi_move( int argc, const char *argv[] );
void multi_copy( int argc, const char *argv[] );
void multi_cat( int argc, const char *argv[] );
void multi_less( int argc, const char *argv[] );
void multi_mkcol( int argc, const char *argv[] );
void multi_delete( int argc, const char *argv[] );
void multi_rmcol( int argc, const char *argv[] );

#endif
