
#ifndef COMMON_H
#define COMMON_H

#include <config.h>

#include <sys/types.h>

#include <stdio.h>

#define DEBUG_SOCKET (1<<0)
#define DEBUG_FILES (1<<1)
#define DEBUG_RCFILE (1<<2)
#define DEBUG_HTTP (1<<3)
#define DEBUG_FTP (1<<4)
#define DEBUG_XML (1<<5)
#define DEBUG_GNOME (1<<6)
#define DEBUG_HTTPAUTH (1<<7)
#define DEBUG_HTTPPLAIN (1<<8)
#define DEBUG_FILESEXTRA (1<<9)
#define DEBUG_LOCKS (1<<10)
#define DEBUG_XMLPARSE (1<<11)
#define DEBUG_HTTPBODY (1<<12)
#define DEBUG_FLUSH (1<<22)

/* This way doesn't rely on DEBUG(a,b...) which confused old compilers
 * and decent compilers can optimize out the if(0) paths.
 */

#ifdef DEBUGGING
extern int debug_mask;
#define DEBUG debug

#ifdef __GNUC__
#define DEBUG_FATAL(x) \
debug(x,"Fatal error in " __FUNCTION__ " at line %d\n", __LINE__ );
#else /* !__GNUC__ */
#define DEBUG_FATAL(x) debug(x, "Fatal error.\n" );
#endif /* !__GNUC__ */

#else
#define DEBUG if(0) debug
#define DEBUG_FATAL(x) if(0)
#endif

void debug( int ch, char *, ... )
#ifdef __GNUC__
                __attribute__ ((format (printf, 2, 3)))
#endif /* __GNUC__ */
;

/* A signal hander */
typedef void (*sig_handler)( int );

#define min(a,b) ((a)<(b)?(a):(b))

#ifdef __EMX__
/* siebert: strcasecmp is stricmp */
#define strcasecmp stricmp
#endif

/* boolean */
/* FIXME: curses defines bool as well, with no namespace protection
 * (the swines). */
typedef char bool;
#define true 1
#define false 0

#if !defined( HAVE_STRDUP ) || !defined( strdup )
char *strdup( const char *s );
#endif

#ifndef HAVE_STRNDUP
char *strndup( const char *s, size_t n );
#endif

#if !HAVE_STRERROR && !defined(strerror)
char *strerror (int errnum);
#endif

void md5_hexify( unsigned char md5_buf[16], char *buffer );

void md5_unhexify( const char *buffer, unsigned char md5_buf[16] );

/* This from wget */
#define HEXD2asc(x) (((x) < 10) ? ((x) + '0') : ((x) - 10 + 'a'))

#endif

