/* 
   WebDAV locking
   Copyright (C) 1999-2000, Joe Orton <joe@orton.demon.co.uk>
                                                                     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef DAVLOCKS_H
#define DAVLOCKS_H

#include "httpdav.h"

enum dav_lock_scope {
    dav_lockscope_exclusive,
    dav_lockscope_shared
};

enum dav_lock_type {
    dav_locktype_write
};

struct dav_lock {
    char *uri;
    int depth;
    enum dav_lock_type type;
    enum dav_lock_scope scope;
    char *token;
    char *owner;
    int timeout;
    struct dav_lock *next;
    struct dav_lock *prev;
};

struct lock_result {
    struct dav_lock lock;
    int status;
    char *href;
    char *reason;
    struct lock_result *next;
};

int dav_lock( struct dav_lock *lock );
int dav_unlock( struct dav_lock *lock );
int dav_lock_discover( const char *uri, struct lock_result **locks );

void dav_lock_free( struct dav_lock *lock );
void dav_lock_add( struct dav_lock **list, struct dav_lock *lock );
void dav_lock_remove( struct dav_lock **list, struct dav_lock *lock );
struct dav_lock *dav_lock_find( struct dav_lock *list, const char *uri );

extern struct dav_lock *lock_list;

void dav_locklist_free( struct dav_submit_locks *list );

#endif /* DAVLOCKS_H */
