

#ifndef FRONTEND_H
#define FRONTEND_H

#include <sys/types.h>

/* Connection Status API.
 *
 * fe_connection() is called to indicate what state the connection is
 * in. Note, the status may bounce between fe_connected and
 * fe_connecting many times during an operation - especially if
 * connected to a WebDAV server which doesn't implement HTTP/1.1
 * persistent connections.
 */

typedef enum {
    fe_namelookup, /* Looking up hostname */
    fe_connecting, /* Connecting to server */
    fe_connected /* Connection established */
} fe_conn_status;

extern void fe_connection( fe_conn_status status );

extern void fe_transfer_progress( size_t progress, size_t total );

typedef enum {
    fe_login_server,
    fe_login_proxy
} fe_login_context;

/* The user is required to authenticate themselves for given context,
 * in the given realm on the given hostname.
 * (The Netscape UI for this is: "Enter username for REALM at HOSTNAME:")
 * Must return:
 *    0:  Success. *username must be be NULL, *password may be NULL, to
 *    indicate the user does not have a password.
 * non-zero: User cancelled operation. *username and *password ignored.
 */
extern int 
fe_login( fe_login_context ctx, const char *realm, const char *hostname,
	  char **username, char **password );

#endif
