/* 
   sitecopy, for managing remote web sites.
   Copyright (C) 1998, Joe Orton <joe@orton.demon.co.uk>
                                                                     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef PROTOCOL_H
#define PROTOCOL_H

#include <sys/types.h>

#include "common.h"

#define PROTO_OK 0
/* Misc error */
#define PROTO_ERROR -1
/* Hostname lookup failed */
#define PROTO_LOOKUP -2
/* Local hostname could not be found */
#define PROTO_LOCALHOST -3
/* Could not connect to remote host */
#define PROTO_CONNECT -4
/* Could not find local file */
#define PROTO_FILE -5
/* The operation is not supported by the driver */
#define PROTO_UNSUPPORTED -6
/* Could not authorize user on server */
#define PROTO_AUTH -7
/* Condition not met */
#define PROTO_FAILED -8
/* Nothing found */
#define PROTO_NONE -9

enum proto_filetype {
    proto_file,
    proto_link,
    proto_dir
};

struct proto_file {
    char *filename;
    enum proto_filetype type;
    size_t size;
    time_t modtime;
    mode_t mode;
    unsigned char checksum[16];
    int depth;
    struct proto_file *next;
};

typedef void (*proto_read_block) ( 
    void *userdata, const char *buf, const size_t len );

struct proto_host {
    char *hostname;
    int port;
    char *username;
    char *password;
};

#endif PROTOCOL_H
