/*
 *	$Id: httpdget.h,v 1.15 2000/04/26 22:10:33 solyga Exp $
 */

#undef	DEBUG


#include <stdio.h>
#include <errno.h>
#include <unistd.h>		/* getopt(), read(), write(), close(), STDIN_FILENO */
#include <stdlib.h>		/* strtol(), malloc() */
#include <sys/types.h>		/* open(), socket(), connect(), ulong */
#include <sys/stat.h>		/* open() */
#include <fcntl.h>		/* open(), O_RDONLY */
#include <string.h>		/* strlen() */
#include <sys/socket.h>		/* socket(), connect() */
#include <netdb.h>		/* gethostbyname() */
#include <netinet/in.h>		/* htons(), struct_sockaddr_in, struct in_addr */
#include <arpa/inet.h>		/* inet_addr() */
#include <limits.h>		/* INT_MAX, INT_MIN */
#include <time.h>		/* time() */


#define VERBOSE_CHANNEL	stderr
#define HELP_CHANNEL	stdout	
#define	VERSION_CHANNEL	stdout
#define ERROR_CHANNEL	stderr
#define DEBUG_CHANNEL	stderr

#define	DEFAULT_PROTOCOL	"http"
#define	DEFAULT_HOST		"localhost"
#define	DEFAULT_PORT_STR	"80"
#define	DEFAULT_PATH		""		/* no leading slash (manual) */
#define	DEFAULT_COOKIE		"none=0"
#define	ANSWER_BUFFER_SIZE	(16*1024)
#define	HEADER_BASE_SIZE	(1024)
#define	HEADER_MAX_SIZE		(16*1024)
#define	HASH_MARKS		(80)		/* relative */
#define	HASH_SIZE		(1024)		/* absolute */
#define	HASH_PREFIX		"(abs)"		/* prefix indicating abs. */
#define	VERBOSE_LEVEL_MAX	4	/* current maximum (man & help) */

#define	RETVAL_OK		 0
#define	RETVAL_MALLOC		 1
#define	RETVAL_BUG		 2
#define	RETVAL_PROTOCOL		 3	/* unknown protocol specified */
#define	RETVAL_HOSTNAME		 4	/* hostname unresolved */
#define	RETVAL_PORT		 5	/* invalid port specified */
#define	RETVAL_CONNECT		 6	/* connect failed */
#define	RETVAL_SERVER_PROTOCOL	 7	/* answer is non-http */
#define	RETVAL_NO_SUCCESS	 8	/* non-successful server status */
#define	RETVAL_LENGTH		 9	/* body length != Content-Length */
#define	RETVAL_OFFSET		10	/* offset request failed */
#define	RETVAL_ERROR		11

/*
 * status codes from rfc2616
 */
/* informational */
#define	HTTP_CONTINUE				100
#define	HTTP_SWITCHING_PROTOCOLS		101
/* successful */
#define	HTTP_OK					200
#define	HTTP_CREATED				201
#define	HTTP_ACCEPTED				202
#define	HTTP_NON_AUTHORITATIVE_INFORMATION	203
#define	HTTP_NO_CONTENT				204
#define	HTTP_RESET_CONTENT			205
#define	HTTP_PARTIAL_CONTENT			206
/* redirect */
#define	HTTP_MULTIPLE_CHOICES			300
#define	HTTP_MOVED_PERMANENTLY			301
#define	HTTP_FOUND				302	/* moved temporarily */
#define	HTTP_SEE_OTHER				303
#define	HTTP_NOT_MODIFIED			304
#define	HTTP_USE_PROXY				305
#define	HTTP_TEMORARY_REDIRECT			307
/* client error */
#define	HTTP_BAD_REQUEST			400
#define	HTTP_UNAUTHORIZED			401
#define	HTTP_PAYMENT_REQUIRED			402
#define	HTTP_FORBIDDEN				403
#define	HTTP_NOT_FOUND				404
#define	HTTP_METHOD_NOT_ALLOWED			405
#define	HTTP_NOT_ACCEPTABLE			406
#define	HTTP_PROXY_AUTHENTICATION_REQUIRED	407
#define	HTTP_REQUEST_TIME_OUT			408
#define	HTTP_CONFLICT				409
#define	HTTP_GONE				410
#define	HTTP_LENGTH_REQUIRED			411
#define	HTTP_PRECONDITION_FAILED		412
#define	HTTP_REQUEST_ENTITY_TOO_LARGE		413
#define	HTTP_REQUEST_URI_TOO_LARGE		414
#define	HTTP_UNSUPPORTED_MEDIA_TYPE		415
#define	HTTP_REQUESTED_RANGE_NOT_SATISFIABLE	416
#define	HTTP_EXPECTATION_FAILED			417
/* server error */
#define	HTTP_INTERNAL_SERVER_ERROR		500
#define	HTTP_NOT_IMPLEMENTED			501
#define	HTTP_BAD_GATEWAY			502
#define	HTTP_SERVICE_UNAVAILABLE		503
#define	HTTP_GATEWAY_TIME_OUT			504
#define	HTTP_HTTP_VERSION_NOT_SUPPORTED		505

#define	HTTP_UNKNOWN				-1


#define VERSION_NUMBER		"0.03.01"
#define DATE_OF_LAST_MOD	"2000-04-27"
#define	MY_EMAIL_ADDRESS	"Steffen Solyga <solyga@absinth.net>"

#define	MIN( A, B )		( (A)<(B) ? (A) : (B) )
#define	NON_ASCII( A )		( (A)==0||(A)>0x7f?1:0 )

#define	N_( A )			A
/* taken from resolv/herror.c of glibc-2.0.7 */
const char *h_errlist[] = {
        N_("Resolver Error 0 (no error)"),
        N_("Unknown host"),                     /* 1 HOST_NOT_FOUND */
        N_("Host name lookup failure"),         /* 2 TRY_AGAIN */
        N_("Unknown server error"),             /* 3 NO_RECOVERY */
        N_("No address associated with name"),  /* 4 NO_ADDRESS */
};


typedef unsigned char	UCHAR;
