.\"
.\"	$Id: httpdget.man,v 1.9 2000/04/26 22:10:04 solyga Exp $
.\"
.TH [%s PRG_NAME] [%d MANUAL_NUMBER] "[%s DATE_OF_LAST_MOD]" "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"
.SH NAME
[%s prg_name] \- get resource from web server
.SH SYNOPSIS
.B [%s prg_name]
.RB [ -hHvV ]
.RB [ -c
.IR cookies ]
.RB [ -n
.IR bytes ]
.RB [ -o
.IR offset ]
.RI [ URL ]

.SH DESCRIPTION
.B [%s Prg_name]
attempts to receive
.I bytes
bytes from the resource specified by
.I URL
starting at offset
.IR offset
and redirects the stream to
.IR stdout .
By default,
.B [%s prg_name]
accesses the whole resource
.IR http://[%s DEFAULT_HOST]:[%s DEFAULT_PORT_STR]/[%s DEFAULT_PATH] .

If the range specified by
.IR offset
and/or
.I bytes
is too large to be completely satisfied,
.B [%s prg_name]
provides as much bytes as obtainable (possibly none) and exits
successfully.

.SH OPTIONS
.TP
.BI "\-c " cookie(s)
send given cookie(s) to server
.TP
.B -h
display some helpful information on
.I [%s HELP_CHANNEL_STR]
and exit successfully
.TP
.B -H
print hash marks on
.IR [%s VERBOSE_CHANNEL_STR] .
If the resource size ist known,
.I [%d HASH_MARKS]
hash marks are printed until the transmission is complete.
Otherwise one hash mark stands for
.I [%d HASH_SIZE]
received bytes. In this case the hashes are prefixed by the string
.IR [%s HASH_PREFIX] .
.TP
.BI "\-n " bytes
read only (up to)
.I bytes
bytes (default infinit)
.TP
.BI "\-o " offset
start reading at offset
.I offset
(default 0)
.TP
.B -v
raise verbosity level on
.I
[%s VERBOSE_CHANNEL_STR]
by one (maximum [%d VERBOSE_LEVEL_MAX])
.TP
.B -V
display version and compilation info on
.I [%s VERSION_CHANNEL_STR]
and exit successfully

.SH URL RESOLUTION
.B [%s Prg_name]
does
.I not
care much about
.IR "RFC 2616" .
Don't like to explain the algorithm in detail, just keep in mind the following 
rules:
.TP
.B 1.
use
.I //host
to specify a host different from [%s DEFAULT_HOST]
.TP
.B 2.
use
.I //:port/
to specify a port other than [%s DEFAULT_PORT_STR]
.TP
.B 3.
use
.I http://
to specify the protocol - there is no other protocol available (see the
program name)
.TP
.B 4.
use
.I dir/
to receive a directory listing (or the default file in there) - without the
trailing slash you will probably get a 301 moved permanently error
.TP
The following examples show usual expansions:
.TP
file         -->  [%s DEFAULT_PROTOCOL]://[%s DEFAULT_HOST]:[%s DEFAULT_PORT_STR]/file
.TP
dir/file     -->  [%s DEFAULT_PROTOCOL]://[%s DEFAULT_HOST]:[%s DEFAULT_PORT_STR]/dir/file
.TP
//host/file  -->  [%s DEFAULT_PROTOCOL]://host:[%s DEFAULT_PORT_STR]/file
.TP
//:88        -->  [%s DEFAULT_PROTOCOL]://[%s DEFAULT_HOST]:88/[%s DEFAULT_PATH]

.SH RETURN VALUE
On success, [%d RETVAL_OK] is returned. In the error case a value >0 is
returned.

.SH ERRORS
.TP
.B [%d RETVAL_MALLOC]
not enough memory available
.TP
.B [%d RETVAL_BUG]
a program bug has seen the light
.TP
.B [%d RETVAL_PROTOCOL]
unknown protocol specified
.TP
.B [%d RETVAL_HOSTNAME]
unknown host specified
.TP
.B [%d RETVAL_PORT]
invalid port specified
.TP
.B [%d RETVAL_CONNECT]
connect failed
.TP
.B [%d RETVAL_SERVER_PROTOCOL]
contacted server does not speak http
.TP
.B [%d RETVAL_NO_SUCCESS]
server sent non-successful status code
.TP
.B [%d RETVAL_LENGTH]
the received resource size differs from the expected one
.TP
.B [%d RETVAL_OFFSET]
the requested offset cannot be satisfied by the server
.TP
.B [%d RETVAL_ERROR]
the error is different from those explained above

.SH EXAMPLES
Save http://[%s DEFAULT_HOST]:[%s DEFAULT_PORT_STR]/[%s DEFAULT_PATH]
to disk
.TP
.BR "[%s prg_name]" " > file"
.TP
Finish a previously terminated download
.TP
.BR "[%s prg_name]" " -o `"disksize " file` //download.com/file >> file"
.TP
Play back a remote cdda file (fast connection needed)
.TP
.BR "[%s prg_name]" " -Hv //local.cdda.server/song.cdr |" " cddaplay" " -v"

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR httpdtalk (1),
.BR httpdtype (1),
.BR cddaplay (1),
.BR disksize (1)
