.TH [%s PRG_NAME] [%d MANUAL_NUMBER] "[%s DATE_OF_LAST_MOD]" "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"
.SH NAME
[%s prg_name] \- talk with a web server
.SH SYNOPSIS
.B [%s prg_name]
.RB [ -hrvV ]
.RB [ -p
.IR port ]
.RI [ host ]
.SH DESCRIPTION
.I [%s Prg_name]
connects to the http demon running on
.IR host ,
sends the query read from stdin to
.IR host
and writes the answer to
[%s STD_CHANNEL_STR].
By default,
.I [%s prg_name]
connects to host
.IR [%s DEFAULT_HOST]
at port
.IR [%d DEFAULT_PORT] .

If stdin is a character device (terminal), the input is read (and sent) line
by line where each line is terminated with CR+LF by
.IR [%s prg_name] .
Otherwise the input is read (and sent) as binary in blocks of
[%d INPUT_BUFFER_SIZE] bytes.

If
.I [%s prg_name]
is linked with the GNU readline library (and stdin is a character device),
the well-known readline(3) features are available (cmd line editing, history);
the history file is
.IR ~/[%s HIST_FN] .
Use the
.B -V
option to find out whether readline is linked and
.B -r
to prevent the usage of readline.

When redirecting the output to a pipe the whole document requested is buffered
by
.IR [%s prg_name] .
Thus you may run out of memory when requesting very large documents, be aware.
Furthermore, if you redirect the output to a pager like more(1), you must not
use terminal input for
.IR [%s prg_name] ,
because your input would be read by
.I [%s prg_name]
and by the pager as well. Issue "cat - | more" to study this.

.I [%s Prg_name]
exits when the server closes the connection and the whole document has been
written to stdout or when reading EOF (Ctrl-D) from the input terminal.
As last resort you may always send SIGINT (Ctrl-C) to the program.

.SH OPTIONS
.TP
.B -h
display some helpful information on
.I [%s HELP_CHANNEL_STR]
and exit successfully
.TP
.B -r
don't use readline(3) (if linked)
.TP
.B -v
raise verbosity level for
.I
[%s VERBOSE_CHANNEL_STR]
by one
.TP
.B -V
display version and compilation info on
.I [%s VERSION_CHANNEL_STR]
and exit successfully
.TP
.BI "\-p " port
connect to port
.I port
instead of port 
.I [%d DEFAULT_PORT]

.SH RETURN VALUE
On success, [%d RETVAL_OK] is returned. On error, a value >0 is returned.

.SH ERRORS
.TP
.B [%d RETVAL_MALLOC]
not enough memory available
.TP
.B [%d RETVAL_BUG]
a program bug has seen the light (drop me a mail)
.TP
.B [%d RETVAL_SIGINT]
program terminated by foreign SIGINT (Ctrl-C)
.TP
.B [%d RETVAL_ERROR]
the error is different from those explained above

.SH REQUEST METHODS
The commands that can be used as
.IR [%s prg_name] 's 
input should begin with a so called HTTP/1.0
.I request method
defined in
.IR "RFC 1945" .
Here's a short listing:
.TP
.B GET
retrieve whatever information is identified by the request URI
(usually header and body)
.TP
.B HEAD
retrieve metainformation about the resource identified by the request URI
(header only, definitely no body)
.TP
.B POST
make the entity enclosed a new subordinate of the resource identified by
the request URI
.TP
.B PUT
store the enclosed entity under the supplied request URI
.TP
.B DELETE
delete the resource identified by the request URI
.TP
.B LINK
establish a link relationship between the existing resource identified by
the request URI and other existing resources
.TP
.B UNLINK
remove one or more link relationships from the existing resource identified
by the request URI

.SH EXAMPLES
Retrieve a listing of the http-root directory at [%s DEFAULT_HOST]
port [%d DEFAULT_PORT]:
.TP
.RB "echo GET / HTTP/1.0 |" " [%s prg_name]"
.TP
Save /index.html to disk and be entertained:
.TP
.RB "echo GET / |" " [%s prg_name] -vv" " www.absinth.net > index.html"
.TP
View the corresponding header (check the file size):
.TP
.RB "echo HEAD /index.html HTTP/1.0 |" " [%s prg_name]" " www.absinth.net"

.SH FILES
.TP
.B ~/[%s HIST_FN]
command line history

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR httpdtype (1),
.BR httpdget (1)
