#include <xmlparse.h>
#include <stdio.h>


static void processingInstruction(void *userData, const char *target, const char *data);
static void endElement(void *userData, const char *name);
static void startElement(void *userData, const char *name, const char **atts);
static void characterData(void *userData, const char *s, int len);

    
class Expat_Wrapper {

 public:

  Expat_Wrapper (const char *encoding, FILE *outstream);
 ~Expat_Wrapper ();

  ProcessFile (const char *filename);
       
 protected:
    
  virtual void CharacterData(const char *s, int len);
  virtual void StartElement(const char *name, const char **atts);
  virtual void EndElement(const char *name);
  virtual void ProcessingInstruction(const char *target, const char *data);
  virtual void ReportError(const char *filename, const char *errmsg,
                           int errcode, int errline, int errcol);
  virtual void FileError (const char *filename);
      
 protected:

  typedef struct {
    XML_Parser parser;
    int *retPtr;
  } PROCESS_ARGS;

 private:
    
  FILE *outfp;
  XML_Parser parser;

  void Init (const char *encoding);

  friend void processingInstruction(void *userData, const char *target, const char *data);
  friend void endElement(void *userData, const char *name);
  friend void startElement(void *userData, const char *name, const char **atts);
  friend void characterData(void *userData, const char *s, int len);

};
