/****h* knsbookmark/knsbookmark.h [0.2.2] ************************************
 * NAME
 *   knsbookmark -- convert netscape bookmarkfile into kfm tree structure
 *
 * COPYRIGHT
 *   (c) 1998  Ewald Arnold <earnold@w-4.de>  (home)
 *                          <earnold@rafi.de> (work)
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SEE ALSO
 *   knsbokmark.c, expat-library
 *
 *****************************************************************************
 */

#include <xmlparse.h>
#include <time.h>

/****** knsbookmark.h/defines [0.2.1] ****************************************
 * NAME
 *   defines -- common macros
 *
 * SOURCE
 */

#define SIM_SED     /* search/replace strings internally, don't use sed */

#ifdef _DEBUG
#define READ_SIZE 16
#else
#define READ_SIZE (1024*8)
#endif

#define KDE_LINK ".kdelnk"

#define MAX_DEPTH 100         /* no of nested entries */

#define  i18n(s)  (s)

#define ALIASID    1
#define ALIASOF   -1
#define NOALIAS    0

/******/

/****** knsbookmark.h/Element [0.2.1] ****************************************
 * NAME
 *   Element -- keep all info about a bookmark entry
 *
 * SOURCE
 */

struct Element {
         char       *elem;
         char       *href;
         char       *data;
         time_t      last_mod,
                     last_visit,
                     add_date;
         int         folded;
         int         isalias;
         int         aliasid;
};

/******/

/****** knsbookmark.h/StringList [0.2.1] *************************************
 * NAME
 *   StringList -- element of a single linked list (used to keep track of aliases)
 *
 * SOURCE
 */

struct StringList {
    char              *str;
    struct StringList *next;
    int                id;
};

/******/

/****** knsbookmark.h/SearchReplace [0.2.1] **********************************
 * NAME
 *   SearchReplace -- keep pair of search and replace string
 *
 * SOURCE
 */

struct SearchReplace {
    char              *search;
    char              *replace;
};

/******/

/****** knsbookmark.h/PROCESS_ARGS [0.2.1] ***********************************
 * NAME
 *   PROCESS_ARGS -- dont know
 *
 * SOURCE
 */
/*
typedef struct {
  XML_Parser parser;
  int *retPtr;
} PROCESS_ARGS;
*/

/******/
