#! /bin/sh
#\
exec tclsh "$0" "$@"

global mVersion defaultDir installDir homeDir
set mVersion "0.2.2"
set defaultDir "/usr/local/lib"
set homeDir $env(HOME)


proc checkdir {defaultdir} {
    set dir [getinput "Enter the directory prefix where you would like to\n\
install the package." $defaultdir]
    if {[file exists $dir]} {
	if {[file isdirectory $dir]} {
	    if {[file writable $dir]} {
		return $dir
	    } else {
		set action [getchoice "Unable to write to $dir. Type \[q\]\
to quit,\nor any other key to try a different name."]
		if {$action == "q"} {
		    exit
		} else {
		    return ""
		}
	    }
	} else {
	    set action [getchoice "$dir exists, but is a regular file, \
not a directory.\nType \[q\] to quit, or any other key to try a \
different name."]
	    if {$action == "q"} {
		exit
	    } else {
		return ""
	    }
	}

    } else {
	set action [getchoice "$dir does not exist. Would you like to create it?\n\
Type \[c\] to create, \[q\] to quit, or any other key\n\
to try a different name."]
	switch -- $action {
	    "c" { return [trycreate $dir] }
	    "q" { exit }
	    default { return "" }
	}
    }
}


proc trycreate {prefix} {
    if {[catch [file mkdir $prefix] result] != 0} {
	set action [getchoice "Unable to create $prefix. Type \[q\] \
to quit,\n or any other key to try a different name."]
	if {$action == "q"} {
	    exit
	} else {
	    return ""
	}
    } else {
	return $prefix
    }
}

proc doinstall {prefix} {
    global mVersion installDir
    
    # Arrgh! relative path!
    # set pkgdir [file dirname [info script]]
    set pkgdir [pwd]
    set mpkg [file join $pkgdir "mapster.tar"]
    puts "Unpacking Mapster files ...\n\n"
    set installDir [file join $prefix "mapster-$mVersion"]
    file mkdir $installDir
    cd $installDir
    exec tar xf $mpkg
}

proc getexecname {prefix} {
    global homeDir

    switch -regexp $prefix {
	"/.+/lib$" {
	    set pos [expr {[string first /lib $prefix] - 1}]
	    set execprefix [string range $prefix 0 $pos]
	    set defaultname "$execprefix/bin/mapster"
	}
	"/.+/share$" {
	    set pos [expr {[string first /share $prefix] - 1}]
	    set execprefix [string range $prefix 0 $pos]
	    set defaultname "$execprefix/bin/mapster"
	}
	"^/usr/local/.+" {
	    set defaultname "/usr/local/bin/mapster"
	}
	"^/usr/.+" {
	    set defaultname "/usr/bin/mapster"
	}
	"^/opt/.+" {
	    set defaultname "/opt/bin/mapster"
	}
	default {
	    # set homedir $env(HOME)
	    # if {[string match $env(HOME)* $prefix]} {}
	    if {[string match $homeDir* $prefix]} {
		#set defaultname "$env(HOME)/bin/mapster"
		set defaultname "$homeDir/bin/mapster"
	    } else {
		set defaultname "/usr/local/bin/mapster"
	    }
	}
    }
    return [getinput "Enter the full path of the mapster \
executable." $defaultname]
}

proc checkexec {filename} {
    if {$filename == "/"} {
	error "I wouldn't do that if I were you!\n\n"
    }
    if {[file exists $filename]} {
	if {[file writable $filename]} {
	    set action [getchoice "$filename already exists. Would you like \
to replace it?\n Type \[r\] to replace, \[q\] to quit, or any other key to\n\
try a different name."]
	    switch -- $action {
		"r" { return $filename }
		"q" { exit }
		default { return "" }
	    }
	} else {
	    set action [getchoice "$filename exists and is unwritable.\n\
Type \[q\] to quit, or any other key to try a different name."]
	    if {$action == "q"} {
		exit
	    } else {
		return "" 
	    }
	}
    } else {
	return $filename
    }
}


proc getinput {prompt defaultval} {
    puts -nonewline "$prompt\n\[Default: $defaultval\]\n? "
    gets stdin result
    if {$result != ""} {
	return $result
    } else {
	return $defaultval
    }
}

proc getchoice {prompt} {
    puts -nonewline "$prompt\n\? "
    gets stdin result
    return [string tolower $result]
}

proc normalpath {path} {
    if {$path != "" && ([file pathtype $path] == "relative" || \
	    [regexp "^~.*" $path])} {
	set origdir [pwd]
	set dirname [file dirname $path]
	set filename [file tail $path]
	if {$filename == $path} {
	    set filename ""
	}
	cd $dirname
	set absdir [pwd]
	cd $origdir
	return [string trimright [file join $absdir $filename] "/"]
    } else {
	return [string trimright $path "/"]
    }
}

# Main program follows
puts " + + + + + + + + + + + + + + + + + + + + + + + + + + +\n\
+ + + + + + + Installing Mapster v0.2.1 + + + + + + +\n\
+ + + + + + + + + + + + + + + + + + + + + + + + + + +\n\n"

while 1 {
    set prefix [normalpath [checkdir $defaultDir]]
    if {$prefix != ""} {
	doinstall $prefix
	break
    }
}

while 1 {
    set executable [checkexec [getexecname $prefix]]
    if {$executable != ""} {
	set realfile [file join $installDir "bin" "mapster"]
	file mkdir [file dirname $executable]
	exec ln -sf $realfile $executable
	break
    }
}

# get installation date
set installdate [clock format [clock seconds]]

# check whether the installation prefix is on the package
# search path
set envset 0
set chkpath [split $auto_path]
if {[lsearch $chkpath $prefix] < 0} {
    set envset \
	"\n\nIMPORTANT NOTE:\n\
The directory where you installed Mapster is not in Tcl's\n\
search path. Therefore you will need to set the TCLLIBPATH\n\
environment variable in order to run Mapster. Example (Bash syntax):\n\n\
TCLLIBPATH=\"$prefix /usr/local/lib /arf/woof/tcl\"\n\
export TCLLIBPATH\n"
} else {
set envset ""
}

# write installation log
set logfile [file join $installDir "install.log"]
if {[catch {set channel [open $logfile "w"]}] != 0} {
    error "Installation completed, but couldn't write log file.\n\
This must be a bug! Please contact mgushee@havenrock.com with details."
}
puts $channel \
    "Mapster 0.2.1\n\
--------------\n\n\
Installed $installdate\n\n\
The following files were installed:\n\n\
$installDir and its contents\n\
$executable (symlink to $realfile)\n\n\
    To uninstall, simply remove these files.\n\
    $envset"

close $channel

puts "\n\n + + + + + + + + + + + + + + + + + + + + + + + + + + +\n\
    Mapster has been successfully installed. For details of\n\
    of the installation, see $logfile.\n\n\
    For instructions on using Mapster, see the user's guide,\n\
    $installDir/doc/mapster-user.html\
    $envset\
    \n + + + + + + + + + + + + + + + + + + + + + + + + + + +\n"