;  htmlx: Emacs extensions for web development
;  Copyright (c) 1998  Matthew C. Gushee
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.

;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.

;  You should have received a copy of the GNU General Public License
;  along with this program; see the file COPYING.  If not, write to
;  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;  Boston, MA 02111-1307, USA.


; ABOUT THIS PACKAGE

; This is a prerelease version of HTMLX, intended for distribution with
; the mapster image map editor. This version contains only the code
; for using mapster as a helper application to Emacs. I am releasing
; it in this form for purposes of forward compatibility---i.e., if and 
; when I release the full-fledged HTMLX/SGMLX package, it will include
; this function, and you should be able to just replace this code with the
; full version and continue using mapster with Emacs in the same way.
; That's the theory, anyway; my plans may change, so I'm not promising
; anything.

; By the way, this function is not very smart about pathnames---you
; need to be careful to enter a relative pathname that will work on the
; server as well as your local system. There's nothing in the code to fix
; the pathname if you give it something like ~/html/images/goofy.gif.

; Important Note:
; ------------
; This code has been tested only with XEmacs v. 20.3 and 21.0.65. If
; you find you need to change anything to make it work with FSF Emacs or
; other versions of XEmacs, please let me know what you did. Thanks.

; please send comments, praise, bug reports to mgushee@havenrock.com


(defvar htmlx-image-map-command nil
  "Command to call external imagemap editor")
(defvar htmlx-image-map-options nil
  "Options to be fed to imagemap editor")

(setq htmlx-image-map-command "mapster -O-")
(setq htmlx-image-map-options '((mapalt ."-A") (defurl . "-D") 
				(mapname . "-N"))

(defun htmlx-create-image-map (imgfile imgalt mapname defurl mapalt)
  "Select IMGFILE, MAPNAME, etc. interactively, then
call external program to create the image map."
  (interactive
   "fImage file: \nsALT text for IMG tag: \nsHTML name of map: \nsDefault URL: \nsALT text for map tag: ")
  (let* ((command (concat htmlx-image-map-command
			  (if (not (equal mapalt ""))
			      (progn
				(if (string-match " " mapalt)
				    (setq mapalt
					  (concat "\"" mapalt "\"")))
				(concat " -A " mapalt)))
			  (if (not (equal defurl ""))
			      (concat " -D " defurl))
			  (if (not (equal mapname ""))
			      (concat " -N " mapname))
			  (if (not (equal imgfile ""))
			      (concat " " imgfile))))
	 (mapdata (exec-to-string command)))
    (insert (concat "<img src=\""
		    imgfile
		    "\" alt=\""
		    imgalt
		    "\" usemap=\"#"
		    mapname
		    "\">\n\n"))
    (insert mapdata)))

(provide 'htmlx)