#
# FILE:
# pagestats.pl
#
# FUNCTION:
# utilities for creating summary page statistics.
#
# USAGE:
# require "pagestats.pl";
#
# HISTORY:
# Written Linas Vepstas May 1998
#
# --------------------------------------------------------
# --------------------------------------------------------
# The geturlist routine will extract the list of URLS 
#	from a report file.  It'll place the number of urls 
#	found in the $numurls variable, the method in $method[], 
#	urls in $url[].
#

sub geturlist {

	$numurls = 0;
	local ($i) = 0;
	
	LINE: while (<>) {
		local (@splat) = split;

		# get the number of url's we expect to read
		if (/number of request/) {
			$numurls = $splat[5];
			next LINE;
		}
	
		# read each url into an array
		if ($i < $numurls) {
			$method[$i] = $splat[1];
			$url[$i] = $splat[2];
			if (("GET"  =~ $method[$i]) ||
			    ("POST" =~ $method[$i]) ||
			    ("HEAD" =~ $method[$i]) ||
			    ("PUT"  =~ $method[$i])) {
				# print ("duude $i $splat[0] $splat[1] $url[$i] \n") if /:/ ;
				++ $i;
			}
		} else {
			# break out of loop only if numurls is positive
			if (0 < $numurls) { last; }
		}
	}
}

# --------------------------------------------------------
# --------------------------------------------------------
# The getelapsedtime routine reads the report file and deduces
# how long the trial ran.  It does this be looking for two strings,
# one that goes "Trial started at", and another, "Trial ended at"
# and using the dates to compute how long the trial ran.
# It returns the elapsed time in seconds.

sub getelapsedtime {
	local ($garbage, $tmp, $startsecs, $endsecs, $startdate, $enddate);
	local ($ss, $es);

	LINE: while (<>) {

		# get the number of url's we expect to read
		if (/Start collecting stats at/) {
			chop;
			($garbage, $tmp) = split (/stats at /);
			($startsecs, $startdate) = split (/ /, $tmp, 2);
			next LINE;
		}
	
		if (/Last complete stats taken at/) {
			chop;
			($garbage, $tmp) = split (/taken at /);
			($endsecs, $enddate) = split (/ /, $tmp, 2);
			# break out of the loop
			last;
		}
	}

	# convert date strings to seconds
	# subtract start from end to get the elapsed time
	require "utils.pl";

	$es = &maketime ($enddate);
	$ss = &maketime ($startdate);
	if ($startsecs - $ss) { die "Bad parsing of dates; $startsecs, $ss, stopped"; }
	if ($endsecs - $es) { die "Bad parsing of dates; $endsecs, $es, stopped"; }
     
	$es - $ss;
}

# --------------------------------------------------------
# --------------------------------------------------------
# The getstats routine will extract a statistic from the
# report files.  It requires as input the following:
# @statname a list of stats to collect info on
#
# it reutrns:
# $numfiles the number of files read
# $numstats
# %nobs array of the number of observations for each stat
# %meantime
# %msqtime

sub getstats {
	local ($i) = 0;
	local ($j);
	local ($s);
	local ($se);
	local ($input_line);
	local ($get_runtime) = 1;


	$numfiles = 0;
	$total_elapsed_time = 0;

	# make a weak attempt to make sure that the list "titles" is defined.
	$#titles = -1; 

	$_ = <>;
SUMMARY:
	for (;;) {
		if ($get_runtime) {
			$runtime = &getelapsedtime;
			$total_elapsed_time += $runtime;
			$get_runtime = 0;
		}

		# search for the begining of each section
		if (/Statistics Summary/) {

			# let determine if we've seen this section title before.
			# If we have not seen it before, then initialize the 
			# stats array for it.
			chop;
			# make a copy, since grep will overwrite $_
			$input_line = $_;
			@foundit = grep (/$input_line/, @titles);

			# zero elements means we've never seen it before.
			if (0 == @foundit) {
				push (@titles, $input_line);

				# initialize arrays; make sure that they contain
				# a value of zero so that we can += to them later.
				for ($i=0; $i<=$#statname; $i++) {
					$s = $statname [$i];
					$nobs{$s, $input_line} = 0;
					$meantime{$s, $input_line} = 0;
					$msqtime{$s, $input_line} = 0;
					$mintime{$s, $input_line} = 99999999;
					$maxtime{$s, $input_line} = -1;
				}
			}

			$j = $input_line;
			while (<>) {
				# study;

				# go to the next summary stanza
				if (/(Avg)/) { 
					$_ = <>;
					next SUMMARY; 
				}

				# handle null, empty stanzas
				if (/Statistics Summary/) { 
					next SUMMARY; 
				}

				# search for the particular statistic
				for ($i=0; $i<=$#statname; $i++) {
					$s = $statname [$i];
					($se = $s) =~ s/ //;  #remove the blank, for pattern match
					if (/\b$se\b/) {
						@split = split;

						# nobs (number of observations ) in the third column
						$nobs{$s, $j} += $split[3];  

						# avg time in the first column must be unwieghted
						# by the number of observations
						$meantime {$s, $j} += $split[1] * $split[3];

						# more math for mean-square time
						$tmp = $split[1] * $split[1] * $split[3];
						$tmp += $split[3] * $split[2] * $split[2];
						$msqtime {$s, $j} += $tmp;

						# min and max observations
						if ($split[4] < $mintime {$s, $j}) {
							$mintime {$s, $j } = $split[4];
						}
						if ($split[6] > $maxtime {$s, $j}) {
							$maxtime {$s, $j } = $split[6];
						}
				 		# print "Running nobs total for url $j is $nobs{$s, $j} \n";
						# last;
					}
				}
			}
		}
	
		if (eof) {
			print "Info: Finished processing file $ARGV \n";
			$numfiles ++;
			$get_runtime = 1;
			$_ = <>;		# wierdness to work around empty stanzas
			last SUMMARY unless $_;
			next SUMMARY; 
		}
		$_ = <>;
	}
}

# --------------------------------------------------------

sub round {
	return (int($_[0]*1000+0.5)/1000);
}

1;
# ===================== end of file ========================
