#
# FILE:
# utils.pl
#
# FUNCTION:
# assorted utilities
#
# USAGE:
# require "utils.pl";
#
# HISTORY:
# Written Linas Vepstas August 1998
#

# --------------------------------------------------------
# --------------------------------------------------------
# The maketime routine converts an ascii date to seconds.
# It accepts as an argument a string similar to 
# Sat Aug  1 23:26:51 1998
# and returns the UTC seconds for that date.


sub maketime {

	# split the date string apart into its components
	local ($wday, $mname, $mday, $clocktime, $year, $tz) = split (/ +/, $_[0]);
	local ($hour, $min, $sec) = split (/:/, $clocktime);
	local ($mon);

	
	# convert the ascii month to a numeric value
	MONTH: {
		if ($mname =~ /Jan/) {$mon = 0; last MONTH; }
		if ($mname =~ /Feb/) {$mon = 1; last MONTH; }
		if ($mname =~ /Mar/) {$mon = 2; last MONTH; }
		if ($mname =~ /Apr/) {$mon = 3; last MONTH; }
		if ($mname =~ /May/) {$mon = 4; last MONTH; }
		if ($mname =~ /Jun/) {$mon = 5; last MONTH; }
		if ($mname =~ /Jul/) {$mon = 6; last MONTH; }
		if ($mname =~ /Aug/) {$mon = 7; last MONTH; }
		if ($mname =~ /Sep/) {$mon = 8; last MONTH; }
		if ($mname =~ /Oct/) {$mon = 9; last MONTH; }
		if ($mname =~ /Nov/) {$mon = 10; last MONTH; }
		if ($mname =~ /Dec/) {$mon = 11; last MONTH; }
	}
	
	# see if timezone preceeds or follows year
	if ($year =~ /\D+/) {
		$tmp = $year;
		$year = $tz;
		$tz = $tmp;
	}

	$year -= 1900;

	require "timelocal.pl";
	timelocal ($sec, $min, $hour, $mday, $mon, $year);
}

1;
# ===================== end of file ========================
