 
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef WIN32
#include <sys/param.h>
#endif /* WIN32 */

#include "checksum.h"
#include "errexit.h"
#include "generic.h"


/* ******************************************************************* */
/* we calculate a simple check sum here to make sure we got a response */
/* back that matches what was expected. .............................. */
/* ******************************************************************* */
int
calc_simple_check_sum (wlString &mbuf, check_sum_info_t &check_sum_info)
{
    char *current, *bodystart, *tailend;
    int longest_length = -1;
    int longest_line = -1;
    int length = -1;
    int sum = 0;
    int line = -1;

    /* Avoid destroying the contents of the orig buffer. */
    wlString mb = mbuf;

    /* have to skip over the header, since the header has time and date*/
    /* in it, and if this turns out to be the longest line, we will use*/
    /* it to calculate the check sum....  Not good.................... */
    line = 0;
    current = mb;
    tailend = current + mb.Memlen();

    bodystart = strstr (current, "\r\n\r\n");
    char * lflf = strstr (current, "\n\n");
    if (NULL == bodystart) bodystart = lflf;
    if (NULL == bodystart) 
    {
        prt("Warning: calc_simple_check_sum(): couldn't find end of header!\n");
        check_sum_info.sum    = -1;
        check_sum_info.size   = -1;
        check_sum_info.line   = -1;
        check_sum_info.length = -1;
        sum = -1;
        return(sum);
    }
    /* if both non-nul, pick the shorter of the two */
    if (bodystart && lflf && (bodystart > lflf)) bodystart = lflf;

    bodystart += strspn (bodystart, "\r\n");

    current = bodystart;
    PDBG("header ends at line %d\n",line);


#if 0
/* this old-style handle hack is disabled; we will rescuscitate someday ... */
    /* *************************************************************** */
    /* Handle hack                                                     */
    /* look for "andle=NNNNNNNN" fields and change them to             */
    /* "andle=XXXXXXXX" so they checksum consistently. ............... */
    /* this should handle "&handle=", "&Handle=", etc. ............... */
    /* alternatively, newer format handles are of the form             */
    /* "andle=HNNNNNN", take care of these as well. .................. */
    /* *************************************************************** */
    /* start off with an empty handle ................................ */
    /* handle values are saved for use on the next request if the next */
    /* request has a <<HANDLE>> string in it. ........................ */
    save_handle[0] = '\0';
    current = bodystart;
    while(current < tailend) {
        next = strstr(current,"andle=");
        if (next) {
            tmp = next;
            strncpy(tmp_str,tmp,30);
            tmp_str[30] = '\0';
            next = next+strlen("andle=");
            /* have we found a handle value in the correct format????? */
            if (isdigit(*next) || ((*next=='H') && (isdigit(*(next+1))))) {
                PDBG1("Found a handle value....\n");
                PDBG1("before: %s\n",tmp_str);
                /* change the digits to X's.  Save the handle value for use*/
                /* on the next request.  It gets substituted for <<HANDLE>>*/
                to = &save_handle[0];
                /* copy the H into save_handle, but don't translate it.....*/
                if (*next == 'H') {
                    *to = *next;
                    to++;
                    next++;
                  }
                /* replace the digits by X's ..............................*/
                while(isdigit(*next)) {
                    *to = *next;
                    to++;
                    *next = 'X';
                    next++;
                }
                /* terminate the save_handle string .......................*/
                *to = '\0';
                strncpy(tmp_str,tmp,30);
                tmp_str[30] = '\0';
                PDBG1("after:  %s\n",tmp_str);
                PDBG1("save_handle=%s\n",save_handle);
                current = next;
            } else {
                /* the handle string value is not either NNNNN or HNNNNNN  */
                /* skip over this one and look for the next one..........  */
                current = next;
            }
        } else      
            {
                break;
            }
    }
#endif 


    /* add all of the char values in the html together to get a check  */
    /* sum. Also find the length of the longest line.................  */
    line = 0;
    sum = 0;
    current = bodystart;
    while(current < tailend) 
    {
        char * line_end = strchr (current, '\n');
        length = line_end - current;
        if (length > longest_length) 
        {
            longest_length = length;
            longest_line = line;
        }
        while((*current != '\n') && (current < tailend)) 
        {
            sum += (unsigned char) *current;
            current++;
        }
        current++;
        line++;
    }
    /* sum up the chars in that line. ............................... */
    /* add in the line number shifted left 8 bits ................... */
    /* add in the line length shifted left 4 bits. .................. */
    /* add in the number of lines in the file shift left 12 bits..... */
    /* we save all of this info in check_sum_info in case we get a    */
    /* mismatch to try to decipher why the mismatch occurred. ....... */
    check_sum_info.sum    = sum;
    check_sum_info.size   = line;
    check_sum_info.line   = longest_line;
    check_sum_info.length = longest_length;
    sum = sum + line*4096+ longest_line * 256 + longest_length * 16;
    return(sum);
}

/* ===================== END OF FILE ===================== */
