/**************************************************************************
 *                                                                        *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.                        *
 *                                                                        *
 *  These coded instructions, statements, and computer programs were	  *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.                 *
 *                                                                        *
 **************************************************************************/


#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#ifdef WIN32
#include <process.h>
#include <winsock.h>
#endif /* WIN32 */

#include "sysdep.h"

/* strerror() returns the last network error as a string  */
/* its a standard POSIX, SVID, BSD and ISO9899 call, but, */ 
/* hey, whats a standard to microsoft?                    */

#ifdef WIN32

/* This is a hack because Win32 doesn't support errno handling. */

char *
strerror (int errnum) 
{
	static char buf[200];

	int wsa_error;
/* the values below are from winsock2.h ....................... */
#ifndef WSAEREFUSED
#define WSAEREFUSED (WSABASEERR+112)
#endif

#define WSA_MIN_ERROR           WSAEWOULDBLOCK
#define WSA_MAX_ERROR           WSAEREFUSED
#define WSA_ERROR_COUNT         WSA_MAX_ERROR-WSA_MIN_ERROR+1

	char *wsa_error_names[WSA_ERROR_COUNT]={
		"WSAEWOULDBLOCK",         /*  (WSABASEERR+35)   */
		"WSAEINPROGRESS",         /*  (WSABASEERR+36)   */
		"WSAEALREADY",            /*  (WSABASEERR+37)   */
		"WSAENOTSOCK",            /*  (WSABASEERR+38)   */
		"WSAEDESTADDRREQ",        /*  (WSABASEERR+39)   */
		"WSAEMSGSIZE",            /*  (WSABASEERR+40)   */
		"WSAEPROTOTYPE",          /*  (WSABASEERR+41)   */
		"WSAENOPROTOOPT",         /*  (WSABASEERR+42)   */
		"WSAEPROTONOSUPPORT",     /*  (WSABASEERR+43)   */
		"WSAESOCKTNOSUPPORT",     /*  (WSABASEERR+44)   */
		"WSAEOPNOTSUPP",          /*  (WSABASEERR+45)   */
		"WSAEPFNOSUPPORT",        /*  (WSABASEERR+46)   */
		"WSAEAFNOSUPPORT",        /*  (WSABASEERR+47)   */
		"WSAEADDRINUSE",          /*  (WSABASEERR+48)   */
		"WSAEADDRNOTAVAIL",       /*  (WSABASEERR+49)   */
		"WSAENETDOWN",            /*  (WSABASEERR+50)   */
		"WSAENETUNREACH",         /*  (WSABASEERR+51)   */
		"WSAENETRESET",           /*  (WSABASEERR+52)   */
		"WSAECONNABORTED",        /*  (WSABASEERR+53)   */
		"WSAECONNRESET",          /*  (WSABASEERR+54)   */
		"WSAENOBUFS",             /*  (WSABASEERR+55)   */
		"WSAEISCONN",             /*  (WSABASEERR+56)   */
		"WSAENOTCONN",            /*  (WSABASEERR+57)   */
		"WSAESHUTDOWN",           /*  (WSABASEERR+58)   */
		"WSAETOOMANYREFS",        /*  (WSABASEERR+59)   */
		"WSAETIMEDOUT",           /*  (WSABASEERR+60)   */
		"WSAECONNREFUSED",        /*  (WSABASEERR+61)   */
		"WSAELOOP",               /*  (WSABASEERR+62)   */
		"WSAENAMETOOLONG",        /*  (WSABASEERR+63)   */
		"WSAEHOSTDOWN",           /*  (WSABASEERR+64)   */
		"WSAEHOSTUNREACH",        /*  (WSABASEERR+65)   */
		"WSAENOTEMPTY",           /*  (WSABASEERR+66)   */
		"WSAEPROCLIM",            /*  (WSABASEERR+67)   */
		"WSAEUSERS",              /*  (WSABASEERR+68)   */
		"WSAEDQUOT",              /*  (WSABASEERR+69)   */
		"WSAESTALE",              /*  (WSABASEERR+70)   */
		"WSAEREMOTE",             /*  (WSABASEERR+71)   */
		"WSANOTUSED",             /*  <WSABASEERR+72>   */
		"WSANOTUSED",             /*  <WSABASEERR+73>   */
		"WSANOTUSED",             /*  <WSABASEERR+74>   */
		"WSANOTUSED",             /*  <WSABASEERR+75>   */
		"WSANOTUSED",             /*  <WSABASEERR+76>   */
		"WSANOTUSED",             /*  <WSABASEERR+77>   */
		"WSANOTUSED",             /*  <WSABASEERR+78>   */
		"WSANOTUSED",             /*  <WSABASEERR+79>   */
		"WSANOTUSED",             /*  <WSABASEERR+80>   */
		"WSANOTUSED",             /*  <WSABASEERR+81>   */
		"WSANOTUSED",             /*  <WSABASEERR+82>   */
		"WSANOTUSED",             /*  <WSABASEERR+83>   */
		"WSANOTUSED",             /*  <WSABASEERR+84>   */
		"WSANOTUSED",             /*  <WSABASEERR+85>   */
		"WSANOTUSED",             /*  <WSABASEERR+86>   */
		"WSANOTUSED",             /*  <WSABASEERR+87>   */
		"WSANOTUSED",             /*  <WSABASEERR+88>   */
		"WSANOTUSED",             /*  <WSABASEERR+90>   */
		"WSASYSNOTREADY",         /*  (WSABASEERR+91)   */
		"WSAVERNOTSUPPORTED",     /*  (WSABASEERR+92)   */
		"WSANOTINITIALISED",      /*  (WSABASEERR+93)   */
		"WSAEDISCON",             /*  (WSABASEERR+101)  */
		"WSAENOMORE",             /*  (WSABASEERR+102)  */
		"WSAECANCELLED",          /*  (WSABASEERR+103)  */
		"WSAEINVALIDPROCTABLE",   /*  (WSABASEERR+104)  */
		"WSAEINVALIDPROVIDER",    /*  (WSABASEERR+105)  */
		"WSAEPROVIDERFAILEDINIT", /*  (WSABASEERR+106)  */
		"WSASYSCALLFAILURE",      /*  (WSABASEERR+107)  */
		"WSASERVICE_NOT_FOUND",   /*  (WSABASEERR+108)  */
		"WSATYPE_NOT_FOUND",      /*  (WSABASEERR+109)  */
		"WSA_E_NO_MORE",          /*  (WSABASEERR+110)  */
		"WSA_E_CANCELLED",        /*  (WSABASEERR+111)  */
		"WSAEREFUSED"             /*  (WSABASEERR+112)  */
};
    wsa_error = WSAGetLastError();
    if ((wsa_error >= WSA_MIN_ERROR) && (wsa_error <=WSA_MAX_ERROR))
      sprintf(buf, "WSAGetLastError() = %d (%s)", wsa_error, wsa_error_names[wsa_error-WSA_MIN_ERROR]);
    else
      sprintf(buf, "WSAGetLastError() = %d (no error name avail)", wsa_error);
    WSASetLastError(0);
   
    return buf;
}

#endif /* WIN32 */
