//
// class wlFetchPage
//
// FUNCTION:
// The wlFetchPage class will fetch the indicated web page,
// automatically handling cookies, following redirects, and 
// fetching any embedded gifs.  It collects timing statistics.
//
// The ClearCache() method clears out the gif cache and the 
//    cookie jar.  It also closes any sockets that might be 
//    lingering open.


#ifndef __WL_FETCH_PAGE_H__
#define __WL_FETCH_PAGE_H__

#include "checksum.h"
#include "cookie.h"
#include "fetchurl.h"
#include "pool.h"
#include "request.h"
#include "stats.h"
#include "super.h"
#include "sysdep.h"
#include "webopts.h"

class wlFetchPage 
{
   public:
      wlFetchPage (int nthreads = 4);
      ~wlFetchPage ();
      int FetchPage (char *server, NETPORT port, 
                     char *proxy_server, NETPORT proxy_port, 
                     wlOpts &);

      void ResetNetTimes (void);
      void ResetSessionCounts (void);
      void ClearCache (void);

   public:
      wlRequest  request;
      wlResponse reply;
      int simple_check_sum;
      check_sum_info_t  cs_info;

      // timing statistics rollups
      time_struct TCPConnectTime;
      time_struct SSLConnectOvhd;
      time_struct SSLNetDelayConnect;
      time_struct NetDelayHeader;
      time_struct NetDelayTransfer;

      wlPageTimer ptimer;

   private:
      int num_threads;
      wlCache     gif_cache;
      wlCookieJar cookie_jar;
      wlFetchURL *furl;
      wlThreadPool *pool;
};

void url_replace_handles (wlString &url, char **fields, char **values);

#endif /* __WL_FETCH_PAGE_H__ */
