//
// FILE:
// fetchurl.C
//
// FUNCTION:
// Implements the FetchURL class.  See the header file for 
// additional documentation.
//

/**************************************************************************
 *                                                                        *
 *               Copyright (C) 1995 Silicon Graphics, Inc.                *
 *                                                                        *
 *  These coded instructions, statements, and computer programs were      *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.                 *
 *                                                                        *
 **************************************************************************/
/* ========================== BEWARE ==================================== */
/* =================== HERE BE CONRAD VEIDT ============================= */
/* The code herein is a horrible, ugly hack of code that originally was
 * a part of SGI's WebStone.  It has spent a goodly portion of it's life
 * in the Laboratory of Dr. Frankenstein, who unmercifully sliced & diced
 * it the most unmentionable, despicable fashion.  In an attempt to remove
 * this code from its befouled birthing pen, management has given it to
 * me, Dr. Caligari.  My somnambulist has been doing well, as I have been
 * applying salves & ointments to heal its horrid wounds.  However, I
 * recognize my only mortal talents, and thus before your gaze rests
 * upon my Cesare,  be forewarned that your wits and faculties may 
 * be so repulsed by the sight that you may never recover status quo
 * ante bellum.  Five cents, please, and you may enter the tent.          */
/* ========================== BEWARE ==================================== */
/* THIS IS WHERE WE GO OUT AND FETCH A URL */

#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>

#ifndef WIN32
#include <netdb.h>
#include <netinet/in.h>
#include <sys/errno.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <unistd.h>
#endif /* WIN32 */

#ifdef WIN32
#include <io.h>
#include <winsock.h>
#include <windows.h>
#endif /* WIN32 */


#include "cookie.h"
#include "errexit.h"
#include "fetchurl.h"
#include "generic.h"
#include "socket.h"
#include "sysdep.h"
#include "timefunc.h"
#include "webopts.h"

#ifdef USE_SKIT
#include "skit.h"
#endif /* USE_SKIT */

#define MAXCOMMANDLEN   256

#ifdef USE_SKIT
#define CHECK_SKIT_NONERROR() {						\
	/* this is considered normal behavior for skit toolkit.... */	\
	if ((use_ssl) && (SKIT_ERROR_BAD_MESSAGE == bytesread)) break;	\
}
#else /* USE_SKIT */
#define CHECK_SKIT_NONERROR()
#endif /* USE_SKIT */


#ifndef WIN32

#define CHECK_FOR_INTERRUPT() {						\
	if (alarm_expired) {						\
		PWARN("alarm expired at line %d\n",__LINE__);		\
		status = GET_ALARM_ERROR;				\
		goto throw_error;					\
	}								\
	if (have_been_interrupted) {					\
		PWARN("interrupted at line %d\n",__LINE__);		\
		status = GET_SIGINT_ERROR;				\
		goto throw_error;					\
	}								\
	if (close_io) {							\
		PINFO("close I/O interrupt at line %d\n",__LINE__);	\
		status = GET_SIGHUP_ERROR;				\
		goto throw_error;					\
	}								\
}

#else /* WIN32 */

#define CHECK_FOR_INTERRUPT() {						\
	if (alarm_expired) {						\
		PWARN("alarm expired at line %d\n",__LINE__);		\
		status = GET_ALARM_ERROR;				\
		goto throw_error;					\
	}								\
}

#endif /* WIN32 */


#ifndef WIN32
#define SHORTSLEEP() 	usleep(1000*retries);
#else /* WIN32 */
#define SHORTSLEEP() 	Sleep(1);
#endif /* WIN32 */


#define READSTUFF(mbuf,bufsiz) {				\
   int retries = 0;						\
   int error_count = 0;						\
   while (1) {							\
      bytesread = sock.Read(mbuf, (bufsiz));		 	\
      int norr = errno;						\
      PDBG1("read %d bytes on sock_fd %d at %d\n",		\
         bytesread, sock.sock_fd, __LINE__);			\
      CHECK_SKIT_NONERROR();					\
      if (BADSOCKET(bytesread))					\
      {								\
         if (EINTR == norr) {					\
            errno = 0;						\
            CHECK_FOR_INTERRUPT();				\
            retries++;						\
            if (MAX_IO_RETRIES > retries) {			\
               PDBG ("sleeping on retry %d \n", retries);	\
               SHORTSLEEP ();					\
               continue;					\
            }							\
            PERR("EINTR loop max exceeded!\n");			\
            status = GET_EINTR_ERROR;				\
            goto throw_error;					\
         }							\
         error_count++;						\
         PWARN("Error during read, errcnt=%d\n"			\
               "\t(%d) %s\n", error_count, norr, strerror (norr)); \
         if (10 > error_count) continue;			\
            PERR("Did not receive everything, errno=%d (%s)\n",	\
            norr, strerror (norr));				\
         status = GET_READ_ERROR;				\
         goto throw_error;					\
      }								\
      break;							\
   }								\
}

#define BUFYSIZ 4096
#define HEADERBUFSIZ (4*4096)

#define READHEADER() {						\
   /* read the header and part of the body (perhaps) */		\
   totalbytesread = 0;						\
   header_length = 0;						\
   int tries = 0;						\
   while (HEADERBUFSIZ > totalbytesread)			\
   {								\
      int bytesread = 0;					\
      tries++;							\
      PDBG1("attempt reading header, try %d, %d\n", 		\
          tries, __LINE__);					\
      if (tries > MAX_IO_RETRIES) {				\
         PERR("too many tries to read header\n");		\
         PERR("page contains no data\n");			\
         status = GET_HEADER_TRIES_ERROR;			\
         goto throw_error;					\
      }								\
      char *mbuf = new char[BUFYSIZ];				\
      READSTUFF (mbuf, BUFYSIZ-1);				\
         							\
      if (0 == bytesread) {					\
         PDBG("unexpected EOF while reading header\n");		\
         status = GET_EOF_ERROR;				\
         delete [] mbuf;					\
         goto throw_error;					\
      }								\
         							\
      /* timestamp soon as anything arrives */			\
      TIMESTAMP(&afterheader);					\
      totalbytesread += bytesread;				\
         							\
      /* search for end of header */				\
      mbuf[bytesread] = '\0';					\
      message.message.PutIn (mbuf, bytesread);			\
      header_length = message.HeaderLength();			\
      if (header_length) break;					\
   }								\
   if (HEADERBUFSIZ <= totalbytesread)				\
   {								\
      PERR("unexpectedly large header\n");			\
      perr("\tmax allowed header size=%d\n", HEADERBUFSIZ);	\
      status = GET_HEADER_TRIES_ERROR;				\
      goto throw_error;						\
   }								\
}


/* *********************************************************** */
/* *********************************************************** */

int 
wlFetchURL::ReadMessage (wlMessage &message,
                         size_t expected_body_length)
{
   size_t header_length;
   size_t content_length;
   size_t totalbytesread;
   size_t bodybytesread;
   int stamped_firstdata = 0;
   wlRequest  requ;
   wlResponse resp;
   char *kuril, *metodi;

   timer_ran = 1;
   status = 0; 

   // make sure we start with an empty buffer
   message.message = NULL;

   // attempt to read the entire header
   READHEADER();

   if (0 == header_length) {
      PERR ("Can't find the end of the header\n%s\n", 
         (char *)message.message);
      status = GET_HEADER2_ERROR;
      goto throw_error;
   }

   /* ************************************************************** *\
    * There are a variety of ways to detect the length of an HTTP
    * message. Precedence in the following order: 
    * 1. responses 1xx, 204 and 304 have a zero-length body
    * 2. response 200 to CONNECT requests have a zero-length body
    * 3. Transfer-Econding Field (not supported here)
    * 4. Content-Length filed specifies length
    * 5. multibyte/byteranges (not supported here)
    * 6. remote end closes socket
   \* *************************************************************  */

   content_length = expected_body_length;
   message.Split();

   requ.message = (char *) message.startline; 
   resp.message = (char *) message.startline; 
   requ.Analyze();
   resp.AnalyzeHeader();
   kuril = resp.status;
   metodi = requ.method;  
   
   if ((kuril && ('1' == *kuril)) ||
      (204 == resp.status_code) ||
      (304 == resp.status_code) ||
      (metodi && 
         ((0 == strcmp (metodi, "GET")) ||
          (0 == strcmp (metodi, "CONNECT")) ||
          (0 == strcmp (metodi, "HEAD")))) )
   { 
      content_length = 0;
      PDBG1("expect zero length body\n");
   }
   else 
   {
      // look for a content-length string, so we know how many bytes to read
      char * cls = message.header.GetValue ("Content-Length");
      if (cls)
      {
         content_length = atoi (cls);
         PDBG1("Content-Length: %d\n", content_length );
      } else {
         PDBG1("socket close denotes end-of-message\n");
      }
   }

   /* ************************************************************** */
   /* did we get ANYTHING after the header??  if not then we have   */
   /* not yet gotten any data so we cannot observe the firstdata    */
   /* time stamp. .................................................. */
   /* ************************************************************** */
   bodybytesread = totalbytesread-header_length;
   if (0 == bodybytesread) {
      stamped_firstdata = 0;
   } else {
      stamped_firstdata = 1;
      TIMESTAMP(&firstdata);
   }

   /* record stats for header arrival latency. */
   addtime(&NetDelayHeader, &(sock.ReadTime));
   addtime(&NetDelayHeader, &(sock.WriteTime));
   sock.ResetNetTimes ();

   /* read the body of the page */
   while (bodybytesread < content_length)
   {
      int bytesread = 0;
      char *mbuf = new char[BUFYSIZ];   
      READSTUFF (mbuf, BUFYSIZ-1);
      if (0 ==  bytesread) {
         delete [] mbuf;
         break;
      }

#ifdef USE_SKIT
      /* this is considered normal behavior for skit toolkit....... */
      if (sock.use_ssl && (SKIT_ERROR_BAD_MESSAGE == bytesread)) {
         delete [] mbuf;
         break;
      }
#endif /* USE_SKIT */

      if (!stamped_firstdata) {
         /* *********************************************************** */
         /* if we didn't get any data with the header, then this is    */
         /* the first data we got, so this should be the firstdata time */
         /* *********************************************************** */
         stamped_firstdata = 1;
         TIMESTAMP(&firstdata);
      }

      message.message.PutIn (mbuf, bytesread);
      bodybytesread += bytesread;
      totalbytesread += bytesread;

      PDBG1("at bottom of 'read body' loop: "
         "bodybytesread = %d "
         "content_length = %d "
         "bytesread=%d\n",
         bodybytesread,content_length,bytesread);
   } 

   /* ******************************************************************* */
   /* this SHOULD have happened in the loop above... if not, do it here . */
   /* (only case that could happen: server returns zero body bytes)...... */
   /* ******************************************************************* */
   if (!stamped_firstdata) {
      stamped_firstdata = 1;
      TIMESTAMP(&firstdata);
   }

   /* take a time stamp when reading the body is complete */
   TIMESTAMP(&afterbody);
   
   /* done reading body */
   if ( (HTTP_ANY_SIZE_MSG != content_length)
       && ((totalbytesread - header_length) != content_length))
   {
      PWARN("bytes received (%d) doesn't match Content-Length (%d)\n",
         totalbytesread - header_length, content_length);
   }

   /* record stats for delay in arrival of rest of data */
   addtime(&NetDelayTransfer, &(sock.ReadTime));
   addtime(&NetDelayTransfer, &(sock.WriteTime));
   sock.ResetNetTimes ();

   rqsize.bytesread += totalbytesread;
   rqsize.headbytes += header_length;
   rqsize.bodybytes += totalbytesread - header_length;

   message.Split();

throw_error:
   return status;

}

/* *********************************************************** */
/* *********************************************************** */

wlFetchURL :: wlFetchURL (void)
{
   www_server = 0;
   www_port = 0;
   proxy_server = 0;
   proxy_port = 0;
   keep_alive = 1;
   use_ssl = 0;
   opts = 0;
   ResetSessionCounts();
   ResetNetTimes();
}

wlFetchURL :: ~wlFetchURL ()
{
}

void wlFetchURL :: ResetSessionCounts (void)
{
   timer_ran = 0;
   num_connects = 0;
   num_connection_reused = 0;
   num_failed_reuses = 0;

   sock.ResetSessionCounts();
}

void wlFetchURL :: ResetNetTimes (void)
{
   timer_ran = 0;

   memset(&TCPConnectTime,      0, sizeof(time_struct));
   memset(&SSLConnectOvhd,      0, sizeof(time_struct));
   memset(&SSLNetDelayConnect,  0, sizeof(time_struct));
   memset(&NetDelayHeader,      0, sizeof(time_struct));
   memset(&NetDelayTransfer,    0, sizeof(time_struct));

   memset(&entertime,       0, sizeof(time_struct));
   memset(&beforeconnect,   0, sizeof(time_struct));
   memset(&afterconnect,    0, sizeof(time_struct));
   memset(&beforesend,      0, sizeof(time_struct));
   memset(&afterheader,     0, sizeof(time_struct));
   memset(&afterbody,       0, sizeof(time_struct));
   memset(&exittime,        0, sizeof(time_struct));
   memset(&firstdata,       0, sizeof(time_struct));

   INIT_RQSIZE (rqsize);
}

void 
wlFetchURL :: RunInThread (void)
{
   GoFetch();
}

/* *********************************************************** */
/* *********************************************************** */

#define MAX_RECONNECT_RETRIES 10

int
wlFetchURL :: GoFetch(void)
{
   size_t expected_reply_body_length = HTTP_ANY_SIZE_MSG;
   size_t writelen = 0;
   int    rc;
   int retry_count = 0;

   status = 0;
   if (!opts || !www_server || !www_port) return -1;

   sock.ResetNetTimes();
   TIMESTAMP(&entertime);
   timer_ran = 1;
   progress = 0;
   alarm_expired = 0;

#ifndef WIN32
   if (0 < opts->alarm_time) {
      rc = alarm(opts->alarm_time);
      PDBG1("alarm(%d) rc=%d \n",opts->alarm_time,rc);
      if (rc != 0) {
         PDBG1("no alarm was set.\n");
      }
   }
#endif /* WIN32 */ 
   PDBG1("will fetch url=%s method=%s encryption=%d\n",
      (char *)request.url, (char *)request.method, use_ssl);

try_again:
   retry_count ++;
   if (MAX_RECONNECT_RETRIES < retry_count)
   {
      PERR ("max dead socket reconnect retry count exceeded\n");
      goto error;
   }

   if (0 != strcmp(request.method,"WEBLOAD_RAW_DATA")) 
   {
      /* ******************************************************** */
      /* if we are using a proxy server, then the url needs to    */
      /* be prefixed with  http://www.servername:pp stuff         */
      /* ******************************************************** */
      if (proxy_server) 
      {
         PDBG1("Using proxy server %s:%d\n", proxy_server, proxy_port);
      }

      if (proxy_server && !use_ssl) 
      {
         wlString geturl;
         geturl = "http://";
         geturl += www_server;
         if (www_port != 0) 
         {
            char  ports[10];
            sprintf (ports,":%hu", www_port);
            geturl += ports;
         }
         geturl += request.url;
         request.url = geturl;
         PDBG1("url sent to proxy: %s\n", (char *)request.url);
      }
   }
   
   /* ******************************************************** */
   /* connect to server ... */
   /* ******************************************************** */

   if (proxy_server) {
      PDBG1("trying to connect to proxy %s:%hu\n",
         proxy_server, proxy_port);
   } else {
      PDBG1("trying to connect to %s:%hu\n",
         www_server, www_port);
   }

   TIMESTAMP(&beforeconnect);
   if (proxy_server) {
      rc = sock.Connect(proxy_server, proxy_port, "tcp", keep_alive);
   } else {
      rc = sock.Connect(www_server, www_port, "tcp", keep_alive);
   }

   // Increment the connection count only if old socket wasn't reused.
   if (EISCONN != rc) {
      num_connects ++;
      addtime (&TCPConnectTime, &sock.ConnectTime);
   } else {
      num_connection_reused ++;
   }

   if (0 > rc) {
      if (EINTR == -rc) {
         if (alarm_expired) {
            PWARN("timed out while attempting to connect\n");
            status = GET_ALARM_CONNECT_ERROR;
            goto error;
         }
#ifndef WIN32
         if (have_been_interrupted) {
            PWARN("interrupted while attempting to connect\n");
            status = GET_SIGINT_ERROR;
            goto error;
         }
         if (close_io) {
            PINFO("close I/O interrupt during connect\n");
            status = GET_SIGHUP_ERROR;
            goto error;
         }
#endif /* WIN32 */ 
      } else {
         PERR("unable to connect\n"
             "\terrno=%d %s\n", -rc, strerror (-rc));
         status = GET_CONNECT_ERROR;
         goto error;
      }
   }

   PDBG1("connected on sock_fd %d\n", sock.sock_fd);

   // We need to perform an SSL connection only if we we are not 
   // already on a persistant socket.
   if (use_ssl && (EISCONN != rc)) 
   {
      // When using SSL through proxy, must issue special CONNECT 
      // directive first, so that proxy will connect use to the remote
      // web server, and transparently pass traffic.  Only then can we
      // perform the SSL handshake with the remote web server.
      if (proxy_server) 
      {
         wlString conreq;
         conreq = "CONNECT ";
         conreq += www_server;
         char ports[12];
         // snprintf (ports, 12, ":%hu", www_port);
         sprintf (ports, ":%hu", www_port);
         conreq += ports;
         conreq += " HTTP/1.0\n" 
                   "User-Agent: webmon/4.0\r\n\r\n";
         size_t len = strlen (conreq);
         PDBG1 ("writing connection request to proxy:\n%s",
            (char *) conreq);
         int rc = sock.Write (conreq, len);
         if (len != rc) {
            int norr = errno;
            PERR("Couldn't connect to proxy: errno=%d (%s)\n", 
               norr, strerror (norr));
            status = GET_CONNECT_ERROR;
            goto error;
         }
         rqsize.bytessent += len;

         /* Wait till proxy responds with HTTP/1.0 200 OK */
         /* Note that we expect a size-zero body, with the sock remaining open */
         status = ReadMessage (reply, 0);
         
         if (status) {
            PERR("No response from proxy\n");
            status = GET_CONNECT_ERROR;
            goto error;
         }

         reply.AnalyzeHeader();
         status = reply.status_code;
         if (HTTP_OK != status) {
            PERR("Bad response from proxy\n");
            status = GET_CONNECT_ERROR;
            goto error;
         }

         PDBG1("completed proxy CONNECT request on sock_fd %d\n", 
            sock.sock_fd);
      }
      sock.SSLConnect (opts->client_ssl_opts);
      addtime (&SSLNetDelayConnect, &(sock.SSLConnectTime));
      addtime (&SSLConnectOvhd, &(sock.SSLConnectOvhd));

      PDBG1("completed SSL handshake on sock_fd %d\n", 
            sock.sock_fd);
      if (0 > sock.sock_fd) {
         if (alarm_expired) {
            PWARN("timed out durring SSL connect handshaking\n");
            status = GET_ALARM_CONNECT_ERROR;
            goto error;
         }
         if (have_been_interrupted) {
            PWARN("interrupted during SSL connect handshaking\n");
            status = GET_SIGINT_ERROR;
            goto error;
         }
         if (close_io) {
            PINFO("close I/O interrupt during SSL connect\n");
            status = GET_SIGHUP_ERROR;
            goto error;
         }
         PERR("unknown error durring SSL connect handshaking\n");
         status = GET_CONNECT_ERROR;
         goto error;
      }
   }


   /* after both the tcp and the ssl connect phases */
   TIMESTAMP(&afterconnect);

   /*
    * Format the request message
    * Note that method and url are not \r\n terminated, 
    * while header must be.  
    * post_data is NOT \r\n terminated.
    */
   if ((0 == strcmp(request.method,"OPTIONS")) || 
       (0 == strcmp(request.method,"GET"))     || 
       (0 == strcmp(request.method,"HEAD"))    ||
       (0 == strcmp(request.method,"POST"))    ||
       (0 == strcmp(request.method,"PUT"))     ||
       (0 == strcmp(request.method,"DELETE"))  ||
       (0 == strcmp(request.method,"TRACE"))   ||
       (0 == strcmp(request.method,"CONNECT"))) 
   {
      request.Assemble ();
   } else if (0 == strcmp(request.method,"WEBLOAD_RAW_DATA")) 
   {
      /* no-op */
   } else {
      PERR("Unknown method %s\n", (char *)request.method);
      status = GET_METHOD_ERROR;
      goto error;
   }

   writelen = request.message.Memlen();

   if(opts->trace_server) 
   {
      time_t today;
      time_struct now;
      char *str, *p;

      TIMESTAMP(&now);
      CONVERTTIME(&now);
      today = (time_t) timevaldouble(&now);
      str = ctime (&today);
      p = strchr (str, '\n');
      if (p) *p = 0x0;

      fprintf (opts->trace_file, 
            REQ_START
            "=========== TIME is %12.3f %s ========= \n",
            MS(timevaldouble(&now)), str);
      if (www_server) {
         fprintf (opts->trace_file, 
            "=========== SERVER %s:%d ============= \n",
            www_server, www_port);
      }
      if (proxy_server) {
         fprintf (opts->trace_file,
            "=========== VIA PROXY %s:%d ============\n",
            proxy_server, proxy_port);
      }
      fwrite ((char *) request.message, writelen, 1, opts->trace_file);
      fflush (opts->trace_file);
   }

   PDBG1("Sending request to server\n");
   PDBG1("Request starts right here ==================>>\n"
         "%s", (char *)request.message);
   PDBG1("end of request ==========================\n");

   /* ***************************************************************** */
   /* Note: after this point, until the final message data is received, */
   /* all of our computation is (presumably) overlapped with data xfer  */
   /* so that we don't need to split out overhead times until then.  So */
   /* we just take a start timestamp, a timestamp when the header is    */
   /* received, and then a timestamp at routine exit. ................. */
   /* ***************************************************************** */
   TIMESTAMP(&beforesend);
   status = sock.Write(request.message, writelen);

   if(status != writelen)
   {
      int norr = errno;
      PERR("Can't send HTTP request to server:\n"
         "\terrno=%d (%s)\n",
         norr, strerror (norr));
      status = GET_SEND_ERROR;
      goto error;
   }
   rqsize.bytessent += writelen;

   /* 
    * We have now sent the request successfully.  
    * Wait for the reply and find the header.
    */
   PDBG1("prior to read loop: line %d\n", __LINE__);

   expected_reply_body_length = HTTP_ANY_SIZE_MSG;
   if (0 == strcmp(request.method,"HEAD")) 
   {
      expected_reply_body_length = 0;
   }
   status = ReadMessage (reply, expected_reply_body_length);
   if (GET_EOF_ERROR == status) 
   {
      // Server dropped us.  Force a clean reconnection to take place.
      sock.Close();
      num_failed_reuses ++;
      num_connection_reused --;
      goto try_again;
   }
   if (status) 
   {
      if (!close_io) PERR("Could not read response from server\n");
      goto error;
   }

   reply.AnalyzeHeader ();
   status = reply.status_code;
   if (0 > reply.status_code)
   {
      PERR("Bad HTTP status line received from server:\n"
         "\t%s\n", (char *)reply.startline);
      status = GET_STATUS_ERROR;
      goto error;
   }

   if(opts->trace_server)
   {
      time_t today;
      time_struct now;
      char *str, *p;

      TIMESTAMP(&now);
      CONVERTTIME(&now);
      today = (time_t) timevaldouble(&now);
      str = ctime (&today);
      p = strchr (str, '\n');
      if (p) *p = 0x0;

      fprintf (opts->trace_file, RSP_START
         "=========== TIME is %12.3f %s ========= \n"
         "=========== Response statistics: "
         "total bytes read=%d header length=%d =============\n",
         MS(timevaldouble(&now)), str,
         reply.message.Memlen(),reply.header.Memlen());

      /* if this is an image file, print the header but not the body */
      char * imagestr = is_content_binary (reply.header);
      if (imagestr) {
         fprintf (opts->trace_file, "%s\r\n", (char *)reply.startline);
         fprintf (opts->trace_file, "%s\r\n", (char *)reply.header);
         fprintf (opts->trace_file, IMAGEDATASKIPPED);
      } else {
         fwrite((char *)reply.message, 
            reply.message.Memlen(), 1, opts->trace_file);
      }
      fflush (opts->trace_file);
   }
    

   if (opts->access_log_file)
   {
      /* print an access log file entry of the form:
       * "127.0.0.1 - - [21/Feb/1999:11:54:23 -0500] "GET / HTTP/1.0" 200 345
       * (this should be the industry standard log-file format)
       */
      struct timeval tv;
      struct timezone tz;
      gettimeofday (&tv, &tz);
      struct tm *tm = localtime (&tv.tv_sec);

      /* compute offset from GMT */
#ifdef AIX
      int tzmin = tz.tz_minuteswest;
#else
      int tzmin = timezone / 60;
#endif
      int tzhour = tzmin/60;
      tzmin -= tzhour*60;

      char tmp[60];
      strftime (tmp, 59, "%d/%b/%Y:%H:%M:%S", tm);

      if (0 == strcmp(request.method,"WEBLOAD_RAW_DATA")) 
      {
         request.Analyze();
      }

      fprintf (opts->access_log_file,
               "%s - - [%s -%02d%02d] \"%s %s %s\" %d %d\n",
            inet_ntoa (sock.sin.sin_addr),
            tmp,
            tzhour,
            tzmin,
            (char *)request.method,
            (char *)request.url,
            (char *)request.version,
            reply.status_code,
            reply.message.Memlen()
         );
   }

   /* Hack around the way that cookies are handled between secure
    * and unsecure connections.  This is hard to explain, so listen up:
    *
    * A web server can return the string "Set-cookie:" to a browser.
    * This string is called a "cookie"; it is followed by a URL, and
    * optionally, the word "secure".  
    * Whenever the browser connects to this URL, its supposed to send
    * the indicate cookie.  If the word "secure" shows up, then the
    * browser will only send the cookie if the connection is secure.
    *
    * Note that the chunk of code we have here is used as a quasi-proxy,
    * where the connection to the server may be secure, but the connection
    * back to the client is not.  As a result of this translation, there
    * can be cookie-confusion.  To avoid this confusion, we will strip
    * out the word "secure" from any cookie the server has sent us.
    * This way, the browser will always send the cookie it needs to,
    * and the server will always get the cookie it wants. 
    */
   {
      char * secure = reply.header.GetValue (SET_COOKIE);
      while (secure) 
      {
         char * eol = strchr (secure, '\n');
         if (eol) *eol = 0x0;
         secure = strcasestr (secure, "secure");
         if (secure) {
            for (int i=0;i<6;i++) { secure[i]=' '; }
         }
         if (eol) *eol = '\n';
         if (!secure) break;
         secure = reply.header.GetValue (SET_COOKIE);
      }
   }

   // Determine whther to keep the socket open or closed.
   {

      // if the protocol is HTTP/1.0, then default is close, unless
      // unless Keep-Alive is in the response header
      if (0 == opts->protocol_minor_version) 
      {
         keep_alive = 0;
         if (reply.header.GetValue ("Keep-Alive")) keep_alive = 1;
      } 
      else
      {
         keep_alive = 1;
      }

      // Determine if the response header had a Connection: close in it
      char * close_it = reply.header.GetValue ("Connection");
      if (close_it) 
      {
         if (0 == strncasecmp (close_it, "close", 5)) keep_alive = 0;
         if (0 == strncasecmp (close_it, "keep-alive", 10)) keep_alive = 1;
      }

   }

   if (0 == keep_alive) {
      rc = sock.Close();
      if (rc) {
         PWARN("unable to close socket\n"
               "\terrno=%d (%s)\n", -rc, strerror(-rc));
         status = GET_NETCLOSE_ERROR;
         goto error;
      }
   }

   progress = 2;

#ifndef WIN32
   if (0 < opts->alarm_time) {
      rc = alarm(0);
      if (rc < 0) {
         PWARN("alarm(0) returned %d.\n",rc);
      } else {
         PDBG1("alarm(0) returned %d.\n",rc);
      }
   }
#endif /* WIN32 */ 

   TIMESTAMP(&exittime);
   CONVERTTIME(&entertime);   
   CONVERTTIME(&beforeconnect); 
   CONVERTTIME(&afterconnect); 
   CONVERTTIME(&beforesend);  
   CONVERTTIME(&afterheader);
   CONVERTTIME(&afterbody); 
   CONVERTTIME(&exittime); 
   CONVERTTIME(&firstdata);

   PDBG1("finish without abend http status=%d\n", status);
   return status;

error:

#ifndef WIN32
   if (0 < opts->alarm_time) {
      rc = alarm(0);
      PDBG("alarm(0) returned rc=%d\n",rc);
   }
#endif /* WIN32 */

   TIMESTAMP(&exittime);
   CONVERTTIME(&entertime);   
   CONVERTTIME(&beforeconnect); 
   CONVERTTIME(&afterconnect); 
   CONVERTTIME(&beforesend);  
   CONVERTTIME(&afterheader);
   CONVERTTIME(&afterbody); 
   CONVERTTIME(&exittime); 
   CONVERTTIME(&firstdata);

   if(opts->trace_server)
   {
      time_t today;
      time_struct now;
      char *str, *p;

      TIMESTAMP(&now);
      CONVERTTIME(&now);
      today = (time_t) timevaldouble(&now);
      str = ctime (&today);
      p = strchr (str, '\n');
      if (p) *p = 0x0;

      /* if we have part of the file already, save that part */
      reply.Split();

      fprintf (opts->trace_file, 
         RSP_START
         RSP_ERROR
         "=========== TIME is %12.3f %s ========= \n"
         "=========== Response statistics: "
         "total bytes read=%d header length=%d =============\n",
         MS(timevaldouble(&now)), str,
         reply.message.Memlen(),reply.header.Memlen());
      if (0 == reply.message.Memlen()) {
         fprintf (opts->trace_file, EMPTY_RSP_MSG);
      } else {
         fwrite ((char *) reply.message, reply.message.Memlen(), 
            1, opts->trace_file);
      }
      fflush(opts->trace_file);
   }

   return status;
}  

/* =================================================== */
/* look for binary content-types */

char * 
is_content_binary (wlHeader &hdr)
{
   char *content = hdr.GetValue ("Content-Type");
   if (!content) return 0x0;

   size_t len = strcspn (content, "\r\n\v");
 
   char *retval = strncasestr (content, "image", len);
   if (retval) return retval;
   retval = strncasestr (content, "audio", len);
   if (retval) return retval;
   retval = strncasestr (content, "video", len);
   if (retval) return retval;

   /* Content-Type: www/unknown is used by Lotus Go to signify binary data */
   retval = strncasestr (content, "www/unknown", len);
   if (retval) return retval;

   /* Assume most application data is binary. 
    * except for ofx which we know is not */
   retval = strncasestr (content, "application/x-ofx", len);
   if (retval) return NULL;
   retval = strncasestr (content, "application/ofx", len);
   if (retval) return NULL;
   retval = strncasestr (content, "application/x-ns-proxy-autoconfig", len);
   if (retval) return NULL;
   retval = strncasestr (content, "application", len);
   if (retval) return retval;

   return NULL;
}

/* ============= END OF FILE =========================== */
