// 
// FILE:
// fetchurl.h
//
// FUNCTION:
// The wlFetchURL class provides the resources needed to fetch an 
// individual URL.
//
// The GoFetch() method will formulate a request, send it to the
//    server, (possibly using the proxy), and obtain the reply message.
//    If an error occured, status will be set to a non-null value.
//
// The ReadMessage() method will read a reply from the server
//    (it does not formulate a request, it assumes that 
//    something is there on the socket to be read).
//
// The sock member of wlFetchURL is the socket that is used
// to actually get the indicated URL.  Note that the socket 
// has the network timing stats associated with it ...
//
// Both methods return negative values if an error occured, or
// if the operation was interrupted. Among the returned error values are:
//    GET_SIGINT_ERROR -- was interrupted during network i/o
//
// The ResetNetTimes() method will reset the various timing statistics 
//    that are gathered during a URL fetch.
//
// The ResetSessionCounts() method will reset back to zero the socket
//    connect & keep-alive counts.
//
// int num_connects: counts the number of times that a real tcpip
//    conection was done to the server.  
//
// int num_connection_reused: counts the number of times an existing
//    (aka KeepAlive or Persistent) connection was successfully reused.
//
// int num_failed_reuses: counts the number of times that a Persistant
//    (aka KeepAlive) connection to the server had been unexpectedly 
//    closed by the server.  Use of such a socket causes a failure
//    and requires the tcpip connection to be renegotiated.
//    It is a crude measure of how busy the server is: idle servers
//    don't normally drop persistant connections.
//
// HISTORY:
// Abstracted from the SGI/Ray Bryant code by Linas Vepstas 1998,1999

#ifndef __WL_FETCH_URL_H__
#define __WL_FETCH_URL_H__

#include "generic.h"
#include "pool.h"
#include "request.h"
#include "stats.h"
#include "super.h"
#include "sysdep.h"
#include "webopts.h"

class wlFetchURL :
   public wlThread
{
   public:
      wlFetchURL (void);
      virtual ~wlFetchURL ();

      int ReadMessage (wlMessage &mess,
                       size_t expected_message_size);

      int GoFetch (void);

      // These need to be set up before GoFetch is called
      char *www_server;
      NETPORT www_port;
      char *proxy_server;
      NETPORT proxy_port;
      int keep_alive;
      int use_ssl;
      wlOpts *opts;


      // These are used internally to accomplish the tasks,
      // but are visible externally for setup and read-only type ops.
      wlSocket   sock;
      wlRequest  request;
      wlResponse reply;

      // Misc session statistics
      void ResetSessionCounts(void);
      int num_connects;         // zero if persistant connection reused
      int num_connection_reused;// num of times persistant conn'n reused
      int num_failed_reuses;    // num times persistant socket was dead

      // misc elapsed times ...
      void ResetNetTimes (void);
      short timer_ran;          // non-zero if this class has been used.
      time_struct TCPConnectTime;
      time_struct SSLConnectOvhd;
      time_struct SSLNetDelayConnect;
      time_struct NetDelayHeader;
      time_struct NetDelayTransfer;

      // misc time stamps ...
      time_struct entertime;     // when we entered the get subroutine
      time_struct beforeconnect; // just before connect.
      time_struct afterconnect;  // just after connect. 
      time_struct beforesend;    // just before we send the request. 
      time_struct afterheader;   // after the header was read. 
      time_struct afterbody;     // after the body was read. 
      time_struct exittime;      // when we returned from get subroutine 
      time_struct firstdata;     // when first msg with body contents arrived

      // byte stats
      request_size_t  rqsize;

      // progress monitor 
      // working == 0
      // done == 2
      short progress;

      // return status
      short status;

   protected:
      virtual void RunInThread (void);

};

/* message length a tad shy of 2GB means arbitrary message size */
#define HTTP_ANY_SIZE_MSG	2000123123


#endif /* __WL_FETCH_URL_H__ */
