
/* 
 * FILE:
 * SOCKS over-ride file.
 */

#ifndef __WEBLOAD_SOCKIFY_H_
#define __WEBLOAD_SOCKIFY_H_

#ifdef USE_SOCKS
/* Version 4 (unauthenticated) socks */

#ifndef AIX
#define connect       Rconnect
#define getsockname   Rgetsockname
#define bind          Rbind
#define accept        Raccept
#define listen        Rlisten
#define select        Rselect

#else /* AIX */
/* 
 * Once again, AIX screws the pooch on unix compliance. 
 * Once again, program correctness & completeness has become 
 * almost impossible to verify.  Go play this incredibly  
 * stupid game anyway. Arghhh. They should fire the guy who 
 * allowed this to happen.  No wonder Microsoft NT is winning.
 * Why can't management keep this under control???  Arghhh.
 */

#define connect       Rconnect
#define ngetsockname  Rgetsockname
#define bind          Rbind
#define naccept       Raccept
#define listen        Rlisten
#define select        Rselect
#endif /* AIX */

#ifdef __cplusplus
extern "C" {
#endif
extern void SOCKSinit (const char *);
#ifdef __cplusplus
};
#endif

#ifdef USE_SOCKS5

/* Version 5 (authenticated, accountable) socks */
#define Rconnect		SOCKSconnect 
#define Rgetsockname	SOCKSgetsockname 
#define Rgetpeername	SOCKSgetpeername
#define Rbind			SOCKSbind
#define Raccept			SOCKSaccept 
#define Rlisten			SOCKSlisten 
#define Rselect			SOCKSselect 
#define recvfrom		SOCKSrecvfrom 
#define sendto			SOCKSsendto 
#define recv			SOCKSrecv 
#define send			SOCKSsend 
#define read			SOCKSread 
#define write			SOCKSwrite 
#define rresvport		SOCKSrresvport 
#define shutdown		SOCKSshutdown 
#define listen			SOCKSlisten 
#define close			SOCKSclose 
#define dup				SOCKSdup 
#define dup2			SOCKSdup2 
#define fclose			SOCKSfclose 
#define gethostbyname	SOCKSgethostbyname 

#endif /* USE_SOCKS5 */
#endif /* USE SOCKS */

#endif /* __WEBLOAD_SOCKIFY_H_ */
