#ifndef __SYSDEP_H__ 
#define __SYSDEP_H__
/**************************************************************************
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.                        *
 *                                                                        *
 *  These coded instructions, statements, and computer programs were	  *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.                 *
 *                                                                        *
 **************************************************************************/

/* include config.h, output from autoconf */
#ifdef HAVE_CONFIG_H
#ifndef __CONFIG_H__
#define __CONFIG_H__
#include "config.h"
#endif
#endif

#include <stdlib.h>

#ifndef WIN32
#include <sys/param.h>
#endif /* WIN32 */

#ifdef WIN32
#include <ctype.h>
#include <winsock.h>
#include <windows.h>
#include <winbase.h>
#include <winnt.h>
#include <math.h>
#include "config.h"
#endif /* WIN32 */


/* MAXHOSTNAMELEN is undefined on some systems */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

/* SunOS doesn't define NULL */
#ifndef NULL
#define NULL 0
#endif

#define MAXPATHLENGTH       MAXPATHLEN

/* ======================================================= */
/* encapsulation of minor UNIX/WIN NT differences */
#ifdef WIN32
#define MAXPATHLEN			1024
#define NETREAD(sock,buf,len)		\
	((0 > expire_alarm (sock, alarm_time)) ? (-1): (recv(sock, buf, len, 0)));

#define NETWRITE(sock, buf, len) 	send(sock, buf, len, 0)
#define NETCLOSE(sock)     		closesocket(sock)
#define	BADSOCKET(sock)			((sock) == INVALID_SOCKET)
#define	BADSOCKET_ERRNO(sock)		BADSOCKET(sock)
#define	BADSOCKET_VALUE			INVALID_SOCKET
#define S_ADDR				S_un.S_addr

typedef unsigned short			NETPORT;
#define	THREAD				__declspec ( thread )
#define FILENAME_SIZE			256
#define HAVE_VPRINTF			1

#define	SIGCHLD				0	/* dummy value */
#define	SIGALRM				0	/* dummy value */
typedef int				pid_t;
typedef	unsigned short			ushort;

#ifndef INADDR_NONE
#define INADDR_NONE 			-1
#endif

#else /* not WIN32 */
#define NETREAD(sock, buf, len)		read(sock, buf, len)
#define NETWRITE(sock, buf, len)	write(sock, buf, len)
#define	NETCLOSE(sock)			close(sock)
#define BADSOCKET(sock)			((sock) < 0)
#define BADSOCKET_ERRNO(sock)		(BADSOCKET(sock) || errno)
#define	BADSOCKET_VALUE			(-1)
#define S_ADDR				s_addr

typedef unsigned short			NETPORT;
#define	THREAD
#define	FILENAME_SIZE			1024
#define HAVE_VPRINTF			1

typedef int				SOCKET;
#endif /* WIN32 */

#ifndef min
#define min(a,b)			(((a) < (b)) ? a : b)
#endif /* min */
#ifndef max
#define max(a,b)			(((a) > (b)) ? a : b)
#endif /* max */
#ifndef MIN
#define MIN(a,b)			min(a,b)
#endif /* MIN */
#ifndef MAX
#define MAX(a,b)			max(a,b)
#endif /* MAX */

#ifndef FABS
#define FABS(x) 			((0.0<x) ? (x) : (-(x)))
#endif /* FABS */


/* the following definition of SLEEP allows you to pass in either an integer */
/* or a floating point number and rounds the argument to the accuracy of the */
/* underlying sleep routine. ............................................... */
#ifdef   AIX
#define SLEEP(X) usleep((useconds_t) floor(1000000.0*X+0.5))
#else /* AIX */
#ifdef    WIN32
#define SLEEP(X) Sleep(((DWORD) (floor(1000*X+0.5))))
#else  /* WIN32 */
#define SLEEP(X) usleep((unsigned long) floor(1000000.0*X+0.5))
#endif /* WIN32 */
#endif /* AIX */


/* Random number generator conventions.  Use random() where available,
 * as it generates better random numbers that rand().  
 */
#ifdef AIX
#define RANDOM random
#define SRANDOM srandom

/* AIX headers have the value of RAND_MAX defined incorrectly. */
#undef RAND_MAX
#define RAND_MAX 2147483647    /* 2**31 - 1 */
#endif /* AIX */

#ifdef WIN32
/* Windows does not have a high-precision random number generator */
#define RANDOM rand
#define SRANDOM srand
#endif /* WIN32 */

#ifdef OTHER_UNIX
#define RANDOM random
#define SRANDOM srandom
#endif  /* OTHER_UNIX */


/* function prototypes */

#ifndef HAVE_STRERROR
/* strerror() is not available on SunOS 4.x and others */
char *strerror(int errnum); 
#endif


#ifdef AIX
/* AIX mutlithreaded headers fail to define errno correctly */
extern int * _Errno (void);
#endif 

#ifdef OTHER_UNIX
/*
 * fetch & add implements an atomic update of a memory
 * location in shared memory.  The non-aix implementation is slow:
 * it uses a spinlock on a temp file
 */
extern int fetch_and_add (int *, int);

#endif /* OTHER_UNIX */
/* !__SYSDEP_H__ */
#endif
