/**************************************************************************
 *	                  		                                  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.                *
 *                                                                        *
 *  These coded instructions, statements, and computer programs were	  *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.                 *
 *                                                                        *
 **************************************************************************/

/*
 * This would be a lot easier if the Microsoft environments weren't
 * so brain-damaged, and the build environment used more sophisticated
 * tools, e.g. autoconf, automake. Sigh.  
 */

#include <math.h>
#include <stdio.h>
#include <time.h>

#include "sysdep.h"
#include "timefunc.h"

/* ------------------------------------------------------ */
/* ltime is UTC (greenwich mean time)
 * ctime accepts UTC, adjusts for local timezones, and returns string 
 */

char *timeofday (void)
{
	time_t ltime;

	time (&ltime);
	return(ctime(&ltime));
}

/* ------------------------------------------------------ */

#ifdef OTHER_UNIX
#define TICK_TOCK 1000000
#endif /* OTHER_UNIX */

/* use nanosecond, hi-res clock on AIX ... why ??? */
#ifdef AIX
#define tv_sec   tb_high
#define tv_usec  tb_low
#define TICK_TOCK 1000000000
#endif

#ifdef WIN32
#define tv_sec   time
#define tv_usec  millitm
#define TICK_TOCK 1000
#endif /* WIN32 */


double
timevaldouble(time_struct *tin)
{
    return ((double)tin->tv_sec + ((double)tin->tv_usec / TICK_TOCK));
}

void
doubletimeval(const double tin, time_struct *tout)
{
    tout->tv_sec = (long)floor(tin);	
    tout->tv_usec = (long)((tin - tout->tv_sec) * TICK_TOCK );
}

void
addtime(time_struct *OrigTime, time_struct *NewTime)
{
    OrigTime->tv_usec += NewTime->tv_usec;
    if(OrigTime->tv_usec >= TICK_TOCK)
    {
        /*
         * NEED TO CARRY 1.
         */
        OrigTime->tv_sec++;
        OrigTime->tv_usec -= TICK_TOCK;
    }
    OrigTime->tv_sec += NewTime->tv_sec;
}

void
wl_difftime(time_struct *EndTime, time_struct *StartTime, time_struct *DiffTime)
{
    time_struct endtime = *EndTime;

      if(endtime.tv_usec < StartTime->tv_usec)
      {
         /*
          * NEED TO BORROW.
          */
          endtime.tv_usec += TICK_TOCK;
          endtime.tv_sec--;
      }
      DiffTime->tv_usec = endtime.tv_usec - StartTime->tv_usec;
      DiffTime->tv_sec =  endtime.tv_sec  - StartTime->tv_sec;
}

void
mintime(time_struct *CurrMinTime, time_struct *CheckMinTime)
{
    if(CheckMinTime->tv_sec < CurrMinTime->tv_sec)
    {
       *CurrMinTime = *CheckMinTime;
       return;
    }
    if(CheckMinTime->tv_sec == CurrMinTime->tv_sec)
    {
        if(CheckMinTime->tv_usec < CurrMinTime->tv_usec)
        {
           *CurrMinTime = *CheckMinTime;
           return;
        }
    }
}

void
maxtime(time_struct *CurrMaxTime, time_struct *CheckMaxTime)
{
    if(CheckMaxTime->tv_sec > CurrMaxTime->tv_sec)
    {
       *CurrMaxTime = *CheckMaxTime;
       return;
    }
    if(CheckMaxTime->tv_sec == CurrMaxTime->tv_sec)
    {
        if(CheckMaxTime->tv_usec > CurrMaxTime->tv_usec)
        {
           *CurrMaxTime = *CheckMaxTime;
           return;
        }
    }
}

/* ------------------------------------------------------ */

#ifdef    MICROSOFT_VISUAL_C

long   win32performance_counter_frequency;

double
timevaldouble(time_struct *tin)
{
	return ((double)tin->QuadPart / (double)win32performance_counter_frequency);
}

void
doubletimeval(const double tin, time_struct *tout)
{
	tout->QuadPart = (LONGLONG) (tin * win32performance_counter_frequency);
}

void
addtime(time_struct *OrigTime, time_struct *NewTime)
{
	OrigTime->QuadPart += NewTime->QuadPart;
}

void
wl_difftime(time_struct *EndTime, time_struct *StartTime, time_struct *DiffTime)
{
    time_struct endtime = *EndTime;

	DifferTime->QuadPart = EndTime->QuadPart - StartTime->QuadPart;
}

void
mintime(time_struct *CurrMinTime, time_struct *CheckMinTime)
{
	if (CheckMinTime->QuadPart < CurrMinTime->QuadPart)
		CurrMinTime->QuadPart = CheckMinTime->QuadPart;
}

void
maxtime(time_struct *CurrMaxTime, time_struct *CheckMaxTime)
{
	if (CheckMaxTime->QuadPart > CurrMaxTime->QuadPart)
		CurrMaxTime->QuadPart = CheckMaxTime->QuadPart;
}

#endif /* MICROSOFT_VISUAL_C */

/* ------------------------------------------------------ */

#ifdef NOTDEF
void
avgtime(time_struct *TotalTime, int NumTimes, time_struct *AvgTime)
{
    double	meantime;

    meantime = mean(timevaldouble(TotalTime), NumTimes);

    doubletimeval(meantime, AvgTime);
}


void
sqtime(time_struct *Time, time_struct *SqTime)
{
    double 	sec;

    sec = timevaldouble(Time);
    sec *= sec;	 /* square */

    doubletimeval(sec, SqTime);
}


void
variancetime(time_struct *SumTime, double SumSquareTime, int NumTimes, time_struct *VarianceTime)
{
    double	result;

    result = variance(timevaldouble(SumTime), SumSquareTime, NumTimes);

    doubletimeval(result, VarianceTime);
}


void
stddevtime(time_struct *SumTime, double SumSquareTime,
	   int NumTimes, time_struct *StdDevTime)
{
    double	result;

    result = stddev(timevaldouble(SumTime), SumSquareTime, NumTimes);

    doubletimeval(result, StdDevTime);
}

double
thruputpersec(const double n, time_struct *t)
{
    double tv;
    
    tv = timevaldouble(t);
    if (tv != 0)
	return n / timevaldouble(t);
    else
	return 0;
}
#endif /* NOTDEF */

/* ------------------ END OF FILE ----------------------- */
