/**************************************************************************
 *               Copyright (C) 1995 Silicon Graphics, Inc.                *
 *                                                                        *
 *  These coded instructions, statements, and computer programs were      *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.                 *
 *                                                                        *
 **************************************************************************/

/* Notes:
 * Why AIX was done differently than other UNIX, I don't know.  
 * I do not beleive there is a technical reason for this gratuitous
 * difference.
 *
 * Why the WIN32 folks decided to support an ancient, obsolete
 * BSD UNIX interface for time funcs, we shall never know.  Why
 * can't they modernize?
 *
 * Why the Microsoft Visual Compiler folks fail to support time
 * manipulation routines of any sort, we shall never know. Sigh.
 */

#ifndef __TIMEFUNC_H__
#define __TIMEFUNC_H__

#ifdef __cplusplus
extern "C" {
#endif

#define NSECINSEC       1000000000
#define USECINSEC	    1000000
#define MSECINSEC	    1000

#define ROUND(X,Y) (floor((X)*Y+0.5)/Y)
#define MS(X) ROUND(X,1000.0)

/* ---------------------------------------------------- */

#ifdef OTHER_UNIX
#include <sys/time.h>

typedef struct timeval time_struct;
#define TIMESTAMP(ARG) gettimeofday (ARG, 0x0)
#define CONVERTTIME(ARG) 
#endif /* OTHER_UNIX */

/* ---------------------------------------------------- */

#ifdef    AIX
#include <sys/time.h>

typedef timebasestruct_t time_struct;
#define TIMESTAMP(ARG) read_real_time(ARG, TIMEBASE_SZ)
#define CONVERTTIME(ARG) time_base_to_time(ARG, TIMEBASE_SZ)
#endif /* AIX */

/* ---------------------------------------------------- */

#ifdef WIN32
#include <sys/timeb.h>

typedef struct timeb time_struct;
#define TIMESTAMP(ARG) ftime(ARG)
#define CONVERTTIME(ARG) 
#endif /* WIN32 */

/* ---------------------------------------------------- */

#ifdef MICROSOFT_VISUAL_C
#include <time.h>

typedef LARGE_INTEGER time_struct;
#define TIMESTAMP(ARG) QueryPerformanceCounter(ARG)
#define CONVERTTIME(ARG) 
#endif /* MICROSOFT_VISUAL_C */

/* ---------------------------------------------------- */

#define TAKETIME(ARG) {TIMESTAMP(ARG); CONVERTTIME(ARG);}




extern double   timevaldouble(time_struct *);
extern void     doubletimeval(const double, time_struct *);

extern void     addtime(time_struct *, time_struct *);
extern void     compdifftime(time_struct *, time_struct *, time_struct *);
extern void     mintime(time_struct *, time_struct *);
extern void     maxtime(time_struct *, time_struct *);
extern void     avgtime(time_struct *, int, time_struct *);
extern void     variancetime(time_struct *, double, int, time_struct *);
extern void     stddevtime(time_struct *, double, int, time_struct *);
extern void     sqtime(time_struct *, time_struct *);
extern double   thruputpersec(const double, time_struct *);
extern char     *timeofday (void);
extern void 	wl_difftime(time_struct *, time_struct *, time_struct *);

#ifdef MICROSOFT_VISUAL_C
extern long   win32performance_counter_frequency;
#endif /* MICROSOFT_VISUAL_C */

#ifdef __cplusplus
};
#endif

#endif /* !__TIMEFUNC_H__ */
