#include <stdio.h>
#include <stdlib.h>
#include <sys/shm.h>

/* **************************************************** */
/* the perl5 shmwrite() routine has a bug that causes it*/
/* to fail with a segmentation fault if it used more    */
/* than one time to write a single integer into the     */
/* shared memory area.  So, we have this little program */
/* to do that function instead. ....................... */
/* **************************************************** */

/* call as: shmupdate shmid offset value                */
/* stores the value (assumed to be a decimal integer) at*/
/* the offset in the shared memory region identified by */
/* shmid (another decimal integer)......................*/
/* offset must be precisely divisible by 4. ........... */
/* (since we address using an integer array based a the */
/* start of the shared memory segment) .................*/

int
main(int argc, char *argv[]) 
{
	int shmid, offset, value;
	int *base;

	if (3 > argc) 
	{
		printf("usage: %s shmid offset value\n", argv[0]);
		return 1;
	}
	shmid  = atoi (argv[1]);
	offset = atoi (argv[2]);
	value  = atoi (argv[3]);
	base = (int *) shmat(shmid,0,0);
	if ((0 != ((int) base)) && (-1 != ((int)base))) 
	{
		offset = offset/4;
		base[offset] = value;
		shmdt(base);
	} 
	else 
	{
		printf("Error: %s: shmat returned %p\n",argv[0], base);
		return 1;
	}
	return 0;
}
