/* 
 * FILE:
 * webclient.c
 *
 * FUNCTION:
 * Implements tools to performing timing, throughput, and latency
 * measurements on a web server.  Will submit a set of HTTP requests 
 * to webserver, and time the results.
 *
 */
 
/**************************************************************************
 *          Copyright (C) 1995 Silicon Graphics, Inc.                     *
 *                                                                        *
 *  These coded instructions, statements, and computer programs were      *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.                 *
 *                                                                        *
 **************************************************************************/
/* ========================== BEWARE ==================================== */
/* =================== HERE BE CONRAD VEIDT ============================= */
/* The code herein is a horrible, ugly hack of code that originally was
 * a part of SGI's WebStone.  It has spent a goodly portion of it's life
 * in the Laboratory of Dr. Frankenstein, who unmercifully sliced & diced
 * it the most unmentionable, despicable fashion.  In an attempt to remove
 * this code from its befouled birthing pen, management has given it to
 * me, Dr. Caligari.  My somnambulist has been doing well, as I have been
 * applying salves & ointments to heal its horrid wounds.  However, I
 * recognize my only mortal talents, and thus before your gaze rests
 * upon my Cesare,  be forewarned that your wits and faculties may 
 * be so repulsed by the sight that you may never recover status quo
 * ante bellum.  Five cents, please, and you may enter the tent.          */
/* ========================== BEWARE ==================================== */

/* socks redefinition must preceed system headers */
#include "sockify.h"

#ifdef WIN32
#include <winsock.h>
#include <windows.h>
#include <process.h>
#include <io.h>
#endif /* WIN32 */

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <math.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>

#ifndef WIN32
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/errno.h>
#include <sys/file.h>
#include <sys/ipc.h>
#include <sys/param.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/shm.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <unistd.h>
#endif /* WIN32 */

#ifdef AIX
#include <sys/atomic_op.h>
#include <sys/mode.h>

/* beats me, aix doesn't define flock, even though the man 
 * pages say its supported */
extern int flock (int, int);

#endif /* AIX */

#include "checksum.h"
#include "cookie.h"
#include "errexit.h"
#include "fetchpage.h"
#include "fetchurl.h"
#include "generic.h"
#include "header.h"
#include "shhopt.h"
#include "socket.h"
#include "stats.h"
#include "sysdep.h"
#include "timefunc.h"
#include "webopts.h"


/* EXPECTED_PARENT_VERSION is the 4 char version name set by run.workload */
#define EXPECTED_PARENT_VERSION "4.1 "

#define MAXINPUTLINELENGTH  4096

class request_entry_t 
{
public:
    char        *method;    /* method: GET or PUT (char string)... */
    char        *url;       /* the url ........................... */
    char        *data;      /* the data from the request. ........ */
    int         check_sum;  /* saved checksum to check response... */
    double	fraction;   /* fraction of times (out of 1.0) to . */
                            /* run this request (randomization) .. */
    double	saved_fraction;
    check_sum_info_t expected_check_sum_info;
    int         have_expected_check_sum_info;
    int         ran_request_this_trial;  /* keeps track of whether */
                            /* or not this request was actually    */
                            /* run this trial (randomization) .... */
    wlString    comments;   /* comments that preceed this .........*/
                            /* request in the input file ......... */
    wlString    header;     /* header that follows this .......... */
                            /* request in the input file ......... */
    int		mark;       /* which group to summarize stats with */
    double	thinks;	    /* seconds to pause before this request*/
    int		distro;	    /* type of random distribution to use. */
};


/* global variables */
double sum_of_think_times = 0.0;
double sum_of_getpage_times = 0.0;

#define SHMSIZE 65536

typedef struct shm_entry {
    int  trial;       /* which trial are we on?                */
    int  dry;         /* which try are we on?                  */
    int  request;     /* which request are we on               */
    int  requests;    /* number of requests run thus far       */

    int  connects;    /* number of tcpip connections to server */
    int  gif_files;   /* number of gif files received          */
    int  first_response; /* millisecs to first byte of response*/
    int  end_to_end;     /* millisecs total end-to-end time    */

    int  total_bytes; /* total bytes received, incl headers    */
    int  html_bytes;  /* number of html bytes received, w/o header */
    int  gif_bytes;   /* number of gif bytes received, w/o header  */

    char running[4];  /* RUNb for running; STOP for stopped    */
                      /* INIT for initial state                */
} shm_entry_t;


/* ****************************************************************** */
/* Generate an exponentially distributed random variable. ........... */
/* Used to generate "think times" delays between each request as .... */
/* well as the time between trials................................... */
/* Actually, the distribution is p = l exp ( - lt)  ................. */
/* where l = 1 / m and m == mean  ................................... */
/* Note that stddev = m  ............................................ */
/* ****************************************************************** */

double
random_exponential(double m)
{
    double terval;
    double u;
    long r;

    /* if no avg think time specified, we wait zero seconds. ....... */
    if (0.0 == m) return(0.0);

    /* use negative number to denote a fixed interval */
    if (0.0 > m) return -m;

    /* otherwise, do an expnential decay of probability */
    do {
        u = ((double)(r=RANDOM()))/((double) RAND_MAX);
    } while (r == 0);
    terval = - log(u);

    /* hardwall peg it to a max so that by a fluke we don't wait
     * a very, very very long time. */
    if (8.0 < terval) terval = 8.0;

    terval *= m;
    return(terval);
}


/* ****************************************************************** */
/* Generate a random vairable with gaussian distribution. ........... */
/* Actually, the distribution is p = 2 l^2 t exp ( - (lt)^2)  ....... */
/* where l^2 = pi / (4 m^2) and == mean  ............................ */
/* Note that stddev = m sqrt ((4/pi)-1) ............................. */
/* ****************************************************************** */
double
random_gaussian(double m)
{
    double terval;
    double u;
    long r;

    /* if no avg think time specified, we wait zero seconds. ....... */
    if (0.0 == m) return(0.0);

    /* use negative number to denote a fixed interval */
    if (0.0 > m) return -m;

    /* otherwise, do an gaussian probability */
    do {
        u = ((double)(r=RANDOM()))/((double) RAND_MAX);
    } while (r == 0);
    terval = - log(u);
    terval = 2.0 * sqrt (terval/M_PI);

    /* hardwall peg it to a max so that by a fluke we don't wait
     * a very, very very long time. */
    if (8.0 < terval) terval = 8.0;

    terval *= m;
    return(terval);
}


/* ================================================================= */
/* ================================================================= */
/* ================================================================= */
/* ================================================================= */

void
wl_initialize_stats (stats_t &rstats)
{
    /* initialize the request statistics entry for this request.... */
    memset(&rstats, 0, sizeof(stats_t));

    INIT_RQSIZE (rstats.total_setup);
    INIT_RQSIZE (rstats.total_lastpage);
    INIT_RQSIZE (rstats.total_gif);

    INIT_STATS(rstats,first_data_response_time);
    INIT_STATS(rstats,end_to_end_time);
    INIT_STATS(rstats,think_time);
    INIT_STATS(rstats,request_time);

    INIT_STATS(rstats,get_times);
    INIT_STATS(rstats,get_overhead_times);
    INIT_STATS(rstats,response_times);
    INIT_STATS(rstats,html_get_times);
    INIT_STATS(rstats,html_ovhd_times);
    INIT_STATS(rstats,html_response_times);
    INIT_STATS(rstats,connect_times);
    INIT_STATS(rstats,header_delays);
    INIT_STATS(rstats,transfer_times);
    INIT_STATS(rstats,gif_response_times);
    INIT_STATS(rstats,gif_get_times);
    INIT_STATS(rstats,gif_ovhd_times);
    INIT_STATS(rstats,getpage_overhead);
    INIT_STATS(rstats,tcp_connect_times);
    INIT_STATS(rstats,ssl_connect_ovhd);
    INIT_STATS(rstats,ssl_net_delay_connect);
    INIT_STATS(rstats,ssl_header_ovhd);
    INIT_STATS(rstats,ssl_net_delay_header);
    INIT_STATS(rstats,ssl_transfer_ovhd);
    INIT_STATS(rstats,ssl_net_delay_transfer);
    INIT_STATS(rstats,net_delay);
    INIT_STATS(rstats,ssl_ovhd);
    INIT_STATS(rstats,html_net_delay);
    INIT_STATS(rstats,html_ssl_ovhd);
    INIT_STATS(rstats,gif_net_delay);
    INIT_STATS(rstats,gif_ssl_ovhd);

    INIT_STATS(rstats,trial_duration);
    INIT_STATS(rstats,sum_of_think_times);
    INIT_STATS(rstats,sum_of_ovhd_times);

    /* fix up the names so they print indented to please the eye... */
    rstats.tcp_connect_times.title      = " tcp_connect_times";
    rstats.ssl_connect_ovhd.title       = " ssl_connect_ovhd";
    rstats.ssl_net_delay_connect.title  = " ssl_net_delay_connect";
    rstats.ssl_header_ovhd.title        = " ssl_header_ovhd";
    rstats.ssl_net_delay_header.title   = " ssl_net_delay_header";
    rstats.ssl_transfer_ovhd.title      = " ssl_transfer_ovhd";
    rstats.ssl_net_delay_transfer.title = " ssl_net_delay_transfer";
    rstats.net_delay.title              = " net_delay";
    rstats.ssl_ovhd.title               = " ssl_ovhd";
    rstats.html_net_delay.title         = " html_net_delay";
    rstats.html_ssl_ovhd.title          = " html_ssl_ovhd";
    rstats.gif_net_delay.title          = " gif_net_delay";
    rstats.gif_ssl_ovhd.title           = " gif_ssl_ovhd";
}

void
wl_obs_stats (stats_t &rstats, wlPageTimer &pagetimer, 
              int dry, int this_request, int trial,
              wlOpts &opts)
{
    OBS_STATS1(rstats,first_data_response_time, pagetimer);
    OBS_STATS1(rstats,end_to_end_time, pagetimer);
    OBS_STATS1(rstats,think_time, pagetimer);
    OBS_STATS1(rstats,request_time, pagetimer);
    OBS_STATS(rstats,response_times, pagetimer);
    OBS_STATS(rstats,connect_times, pagetimer);
    OBS_STATS(rstats,header_delays, pagetimer);
    OBS_STATS(rstats,transfer_times, pagetimer);
    OBS_STATS(rstats,get_times, pagetimer);
    OBS_STATS(rstats,get_overhead_times, pagetimer);
    OBS_STATS(rstats,html_get_times, pagetimer);
    OBS_STATS(rstats,html_ovhd_times, pagetimer);
    OBS_STATS(rstats,html_response_times, pagetimer);
    OBS_STATS(rstats,gif_get_times, pagetimer);
    OBS_STATS(rstats,gif_ovhd_times, pagetimer);
    OBS_STATS(rstats,gif_response_times, pagetimer);
    OBS_STATS(rstats,getpage_overhead, pagetimer);
    if (opts.client_ssl_opts.use_ssl) {
        OBS_STATS(rstats,tcp_connect_times, pagetimer);
        OBS_STATS(rstats,ssl_connect_ovhd, pagetimer);
        OBS_STATS(rstats,ssl_net_delay_connect, pagetimer);
        OBS_STATS(rstats,ssl_header_ovhd, pagetimer);
        OBS_STATS(rstats,ssl_net_delay_header, pagetimer);
        OBS_STATS(rstats,ssl_transfer_ovhd, pagetimer);
        OBS_STATS(rstats,ssl_net_delay_transfer, pagetimer);
        OBS_STATS(rstats,net_delay, pagetimer);
        OBS_STATS(rstats,ssl_ovhd, pagetimer);
        OBS_STATS(rstats,html_net_delay, pagetimer);
        OBS_STATS(rstats,html_ssl_ovhd, pagetimer);
        OBS_STATS(rstats,gif_net_delay, pagetimer);
        OBS_STATS(rstats,gif_ssl_ovhd, pagetimer);
    }
}

void
wl_xfer_stats (stats_t &rstats, wlPageTimer &pagetimer)
{
    rstats.total_tries         += 1;
    rstats.total_connects      += pagetimer.number_of_connects;
    rstats.total_reuses        += pagetimer.number_of_conn_reuses;
    rstats.total_refails       += pagetimer.number_of_reuse_fails;
    rstats.total_redirects     += pagetimer.number_of_redirects;
    rstats.total_num_gifs      += pagetimer.num_gifs_fetched;
    rstats.total_gif_hits      += pagetimer.num_gifs_cached;
    
    ACCUM_RQSIZE (rstats.total_setup, pagetimer.setup);
    ACCUM_RQSIZE (rstats.total_lastpage, pagetimer.last);
    ACCUM_RQSIZE (rstats.total_gif, pagetimer.gif);

    if (rstats.max_connects < pagetimer.number_of_connects)
    {
        rstats.max_connects = pagetimer.number_of_connects;
    }
}

void
wl_print_stats (stats_t &rstats)
{
    sub_stats_t     *onestat;
    int nobs = 0;

    prt(
"                            Mean    StdDev   Nobs    Min     Try    Max     Try\n");

    /* ********************************************************  */
    /* loop over each stat and print it .......................  */
    /* ********************************************************  */
    for(onestat = &(rstats.first_data_response_time);
        onestat <= &(rstats.getpage_overhead);
        onestat++) 
    {
        double avg, var, dev;

        /* don't print statistics for internal measures if       */
        /* tdebug is off                                         */ 
        if ((0 == tdebug) && (onestat >= &(rstats.get_times))) break;

        if (1 > onestat->count) continue;
        if (0.0 == onestat->sum) continue;

        if (nobs < onestat->count) nobs = onestat->count;

        avg = (onestat->sum) / (onestat->count);

        /* if only one observation, variance won't make sense so skip.*/
        if (1 < onestat->count) {
            var  = (onestat->sumsq)/(onestat->count) - avg*avg;
            dev  = sqrt(var);
        } else {
            var  = 0.0;
            dev  = 0.0;
        }
        avg = MS(avg);
        var = MS(var);
        dev = MS(dev);

        prt("%-24s %8.3f %8.3f %5d %8.3f %5d %8.3f %5d\n",
            onestat->title, avg, dev, onestat->count, MS(onestat->min),
            onestat->min_try,MS(onestat->max),onestat->max_try);
    }

    if (nobs > 0) 
    {
        prt("\n");
        prt("(Avg) Number of Connections to Server:   %8.3f\n",
            ((double)rstats.total_connects)/nobs);

        prt("(Avg) Num of Persistant Connect Reuses:  %8.3f\n",
            ((double)rstats.total_reuses)/nobs);

        prt("(Avg) Num of Persist Connect Failures:   %8.3f\n",
            ((double)rstats.total_refails)/nobs);

        prt("(Avg) Persist Connection Hit Rate:       %8.3f%%\n",
            (100.0 * (double)rstats.total_reuses)/
            (double)(rstats.total_reuses+rstats.total_connects));

        prt("(Avg) Persist Connection Failure Rate:   %8.3f%%\n",
            (100.0 * (double)rstats.total_refails)/
            (double)(rstats.total_reuses+rstats.total_connects));

        prt("    (Avg) Number of web pages:           %8.3f\n", 
            ((double)rstats.total_tries)/nobs);

        prt("    (Avg) Number of Redirects:           %8.3f\n",
            ((double)rstats.total_redirects)/nobs);

        prt("    (Avg) Number of gif files fetched:   %8.3f\n",
            ((double)rstats.total_num_gifs)/nobs);

        prt("    (Avg) Number of gif cache hits:      %8.3f\n",
            ((double)rstats.total_gif_hits)/nobs);

        prt("    (Avg) Gif cache hit ratio:           %8.3f%%\n",
            (100.0 * (double)rstats.total_gif_hits)/
             (double)(rstats.total_num_gifs+rstats.total_gif_hits));

        prt("     Max  Connect Tries:                    %d\n",
            rstats.max_connects);

        prt("(Avg) Number of gif bytes fetched:       %8.3f\n",
            ((double)rstats.total_gif.bodybytes)/nobs);
        prt("(Avg) Number of bytes on displayed page: %8.3f\n",
            ((double)rstats.total_lastpage.bodybytes)/nobs);
    } 

    prt("\n");
}

/* ================================================================= */
/* ================================================================= */
/* ================================================================= */
/* ================================================================= */

#define WHITESPACE " \t\v\r\n"

int 
wl_read_requests (char *in_file_name,      /* file tro read reqs from */
                  request_entry_t *reqs,   /* request array to be filled in */
                  int *nreqs,              /* length of request array */
                  int *nmarks,             /* number of summary marks */
                  int *nsess,              /* number of sessions (trials) */
                  double *ugly_think,      /* the mean and the ugly   */
                  int *cuss_think,         /* the foul-mouthed        */
                  int needchk              /* need checksums */
                  )
{
    FILE *in_file;
    wlString methode;
    wlString earl;
    wlString post_data;
    wlString heather;
    wlString comets;
    int num_reqs;
    int next_req = 0;
    int	num_summary_marks = 0;
    int	custom_think = 0;
    int num_sessions = 0;
    double  mean_thinky_time = 0.0;
    double  request_repeat_count = 1.0;
    int i;
    int     have_expected_check_sum_info = 0;
    int     expected_check_sum = 0;
    check_sum_info_t expected_check_sum_info = {0,0,0,0};
    int oldstyle = 1;
    int firsttime = 1;
    int lasttime = 0;
    int cktime = 0;
    int in_header = 0;
    int in_postdata = 0;

    if (!nreqs || !reqs) {
        PFATAL ("Request array and its size must be specified!\n"); 
        exit (1);
    }
    num_reqs = *nreqs;
    if (0 > num_reqs) return 0;

    /* ************************************************************* */
    /* initialize the requests array. .............................. */
    /* ************************************************************* */
    for(i=0; i<num_reqs; i++) {
        reqs[i].method = 0x0;
        reqs[i].url = 0x0;
        reqs[i].check_sum = -1;
        reqs[i].fraction = 0.0;
        reqs[i].saved_fraction = 0.0;
        reqs[i].have_expected_check_sum_info = 0;
        reqs[i].ran_request_this_trial = 0;
        reqs[i].comments = 0x0;
        reqs[i].header = 0x0;
        reqs[i].mark = 0;
        reqs[i].thinks = 0.0;  /* do not change this value !!! */
        reqs[i].distro = wlOpts::THINK_EXPONENTIAL; 
    }

    if (!in_file_name) return 0;

    in_file = fopen(in_file_name,"r");
    if (NULL == in_file)
    {
        int norr = errno;  /* avoid having printfs mangle errno value */
        PFATAL ("Can't open input file: %s \n\t%d %s\n", 
            in_file_name, norr, strerror(norr)); 
        exit (1);
    }

    /* ******************************************************** */
    /* input file format (one of the following):                */
    /* # comment                                                */
    /* <<START>>                                                */
    /* GET url_plus_arguments_url_encoded req_count csum        */
    /* HEAD url_plus_arguments_url_encoded req_count csum       */
    /* POST url data_url_encoded req_count csum                 */
    /* <<END>> num_sessions think_time                          */
    /* "uri" here is the file name on the web server .......... */
    /* csum (checksum) is optionl and is not used if not found. */
    /* req_count is number of times to run this request per the */
    /*      entire sequence. .................................. */
    /* num_sessions is the number of times to run the           */
    /*      entire sequence. .................................. */
    /* think_time is the avg delay time between requests.       */
    /*      (exponentially distributed) ....................... */
    /* ******************************************************** */

    /* loop over the lines in the input file................... */
    char * tok = NULL;
 
    while (!feof (in_file)) 
    {
        char    input [MAXINPUTLINELENGTH];
        char    saved_input [MAXINPUTLINELENGTH];

        if (tok) tok = strtok (NULL, WHITESPACE);
        if (!tok) 
        {
            char *p = fgets(input, MAXINPUTLINELENGTH, in_file);
            if (!p) input[0] = 0;

            /* scan for maximum line length excesses */
            if (MAXINPUTLINELENGTH-2 <= strlen(input)) {
                PFATAL ("input line length exceeds supported maximum of %d \n",
                    MAXINPUTLINELENGTH-2);
                exit (42);
            }

            /* is this a comment line?  if so, print it & continue  */
            /* note well that comments can only appear between well  */
            /* formed URL requests in the input file. ............  */
            if ('#' == input[0]) 
            {
                /* save these comments away on the next request.... */
                comets.Strcat (input);
                tok = NULL;
                continue;
            }
            strcpy (saved_input, input);
            tok = strtok (input, WHITESPACE);
        }

        if (0 == strcmp(tok,"<<START>>")) 
        {
            next_req = 0;
            num_summary_marks = 1;
            continue;
        }

        if (0 == strcmp(tok,"<<END>>")) 
        {
            lasttime = 1;
            continue;
        }

        /* if we haven't seen a start yet, just loop until next line */
        if (0 > next_req) continue;

        if (0 == strcmp(tok,"<<MARK>>")) 
        {
            num_summary_marks ++;
            continue;
        }

        if (0 == strcmp(tok,"<<THINK>>")) 
        {
            double dink_dime = -1.0e20;

            if (0 > (next_req-1)) continue;

            /* look for an optional think time following the token   */
            /* if the token is missing, then -1 is assumed           */
            tok = strtok (NULL, WHITESPACE);
            if (tok) dink_dime = atof (tok);
            reqs[next_req-1].thinks = dink_dime;
            custom_think = 1;
            continue;
        }


        /* read header data from a file */
        if (strcmp(tok,"<<HEADERFILE>>")==0) 
        {
            FILE *fdata;
            tok = strtok (NULL, WHITESPACE);
            if (!tok) {
                PERR("failed to specify header file for <<HEADERFILE>> token\n");
                continue;
            }
            fdata = fopen (tok, "r");
            if (!fdata) {
                PERR("cannot open data file %s \n", tok);
                continue;
            }
            while (fgets(input, MAXINPUTLINELENGTH, fdata)) 
            {
                heather.Strcpy (input);
            }
            fclose (fdata);

            tok = NULL; // force a new line to be read
            continue;
        }

        /* read body data from a file */
        if (strcmp(tok,"<<BODYFILE>>")==0) 
        {
            FILE *fdata;
            tok = strtok (NULL, WHITESPACE);
            if (!tok) {
                PERR ("failed to specify header file for <<BODYFILE>> token\n");
                continue;
            }
            fdata = fopen (tok, "r");
            if (!fdata) {
                PERR ("cannot open data file %s \n", tok);
                continue;
            }
            while (fgets(input, MAXINPUTLINELENGTH, fdata)) 
            {
                post_data.Strcat(input);
            }
            fclose (fdata);

            tok = NULL; // force a new line to be read
            continue;
        }

        if (0 == strcmp(tok,"<<COUNT>>")) 
        {
            tok = strtok (NULL, WHITESPACE);
            if (!tok) {
                PERR ("<<COUNT>> token missing count number\n"
                    "\tWill use count of 1.0 \n");
                request_repeat_count = 1.0;
            } else {
                request_repeat_count = atof (tok);
            }
            continue;
        }

        if (0 == strcmp(tok,"<<HEADER>>")) 
        {
            in_header = 1;
            continue;
        }

        if (0 == strcmp(tok,"<</HEADER>>")) 
        {
            in_header = 0;
            continue;
        }

        if ((0 == strcmp(tok,"<<BODY>>")) ||
            (0 == strcmp(tok,"<<POSTDATA>>"))) 
        {
            in_postdata = 1;
            continue;
        }

        if ((0 == strcmp(tok,"<</BODY>>")) ||
            (0 == strcmp(tok,"<</POSTDATA>>")))
        {
            in_postdata = 0;
            continue;
        }

        if ((0 == strcmp(tok,"OPTIONS" )) || 
            (0 == strcmp(tok,"GET" )) || 
            (0 == strcmp(tok,"HEAD")) || 
            (0 == strcmp(tok,"POST")) ||
            (0 == strcmp(tok,"PUT"))  ||
            (0 == strcmp(tok,"DELETE")) ||
            (0 == strcmp(tok,"TRACE")) ||
            (0 == strcmp(tok,"CONNECT")) ) 
        {
            int bad = 0;

            methode = tok;

            earl = NULL;
            tok = strtok (NULL, WHITESPACE);
            if (tok) earl = tok;  else bad = 1;

            if (oldstyle) {
                post_data = NULL;
                if (strcmp(methode,"POST") == 0) 
                {
                    tok = strtok (NULL, WHITESPACE);
                    if (tok) post_data = tok; else bad = 1;
                }

                tok = strtok (NULL, WHITESPACE);
                if (tok) {
                    request_repeat_count = atof (tok);
                } else {
                    bad = 1;
                }
                cktime = 1;
            }

            if (bad) {
                PERR("bad request in following input line, skipping\n"
                    "\t%s\n", input);
                continue;
            }
            if (!oldstyle) continue;
        } 

        /* ****************************************************** */
        /* Common processing for GET, HEAD and POST continues here*/
        /* ****************************************************** */

        if (cktime || (0 == strcmp(tok,"<<CKSUM>>"))) 
        {
            cktime = 0;
            /* ****************************************************** */
            /* check to see if there is a checksum present .......... */
            /* -1 == checksum absent                                  */
            /* 0 == checksum present but should be ignored            */
            /* ****************************************************** */
            tok = strtok (NULL, WHITESPACE);
    
            if (tok)
            {
                expected_check_sum = atoi (tok);
    
                /* check to see if the checksum info is there as well */
                have_expected_check_sum_info = 1;
                tok = strtok (NULL, WHITESPACE);
                if (tok) expected_check_sum_info.sum = atoi(tok); 
                    else have_expected_check_sum_info = 0;
                tok = strtok (NULL, WHITESPACE);
                if (tok) expected_check_sum_info.size = atoi (tok);
                    else have_expected_check_sum_info = 0;
                tok = strtok (NULL, WHITESPACE);
                if (tok) expected_check_sum_info.line = atoi (tok);
                    else have_expected_check_sum_info = 0;
                tok = strtok (NULL, WHITESPACE);
                if (tok) expected_check_sum_info.length = atoi (tok);
                    else have_expected_check_sum_info = 0;
    
            } else {
                expected_check_sum = -1;
            }
    
            if (needchk && ((-1 == expected_check_sum) || 
                            (0 == have_expected_check_sum_info))) 
            {
                PERR ("Unable to read checksum info ... \n"
                      "\tinput line skipped.\n");
                continue;
            }

            if (0 == needchk) 
            {
                expected_check_sum = 0;
                have_expected_check_sum_info = 0;
                expected_check_sum_info.sum = 0;
                expected_check_sum_info.size = 0;
                expected_check_sum_info.line = 0;
                expected_check_sum_info.length = 0;
            }
            if (!oldstyle) continue;
        }

        /* ******************************************************* */
        /* if we are here, we have finished reading a request. ... */ 
        /* Record it and move to the next request. ............... */
        /* ******************************************************* */
        if ((oldstyle && !lasttime) || (!oldstyle && lasttime) ||
            (0 == strcmp(tok,"<<REQUEST>>")) )
        {
            if (0 == strcmp(tok,"<<REQUEST>>")) {
                oldstyle = 0;
                if (firsttime) {
                    firsttime = 0;
                    continue;
                }
            }

            if (0 == strlen (methode)) continue;

            PDBG ("<<REQUEST>> %s %s\n", (char *)methode, (char *)earl);
            if (debug && post_data.Memlen()) {
            	prt ("<<BODY>>\n%s\n<</BODY>>\n", (char *)post_data);
            }
            PDBG ("<<COUNT>> %5.3f <<CKSUM>> %u %d %d %d %d\n",
                request_repeat_count, expected_check_sum,
                    expected_check_sum_info.sum,
                    expected_check_sum_info.size, 
                    expected_check_sum_info.line,
                    expected_check_sum_info.length);

            /* ******************************************************* */
            /* store the information collected for this request in the */
            /* request structure. .................................... */
            /* ******************************************************* */
            reqs[next_req].method = strdup (methode);
            methode = NULL;

            reqs[next_req].url = strdup (earl);
            earl = NULL;
    
            reqs[next_req].header = heather;
            /* the current header applies to future requests as well */
            /* heather = NULL; so don't null out the heather */
    
            reqs[next_req].comments = comets;
            comets = NULL;
            
            if (post_data.Memlen()) {
                reqs[next_req].data = strdup (post_data);
            } else {
                reqs[next_req].data = NULL;
            }
            post_data = NULL;

            reqs[next_req].fraction = request_repeat_count;
            request_repeat_count = -1.0;

            reqs[next_req].check_sum = expected_check_sum;
            reqs[next_req].have_expected_check_sum_info = have_expected_check_sum_info;
            reqs[next_req].expected_check_sum_info = expected_check_sum_info;

            expected_check_sum = -1;
            have_expected_check_sum_info = 0;
            expected_check_sum_info.sum = 0;
            expected_check_sum_info.size = 0;
            expected_check_sum_info.line = 0;
            expected_check_sum_info.length = 0;

            reqs[next_req].mark = num_summary_marks - 1;
    
            if (num_reqs > next_req) {
                next_req++;
            } else {
                PERR("Too many requests in trial... Max allowed is %d\n",
                    num_reqs);
                break;
            }
            if (!lasttime) continue;
        }

        if (lasttime)
        {
            num_sessions = 0;
            mean_thinky_time = 0.0;

            if (tok) num_sessions = atoi (tok);
            tok = strtok (NULL, WHITESPACE);
            if (tok) mean_thinky_time = atof (tok);

            PDBG("<<END>> num_sessions=%d mean_think_time=%8.3f\n\n",
                num_sessions, mean_thinky_time);
            num_reqs = next_req;

            /* OK, we've got everything we wanted; cleanup and return */
            break;
        }

        if (!oldstyle && !lasttime)
        {
            /* word we found was not GET, HEAD, POST, <<START>> or <<END>> */
            /* assume that we treat it as a comment */
            if (in_postdata) {
                post_data.Strcat(saved_input);
                tok = NULL;
                continue;
            }
            if (in_header) {
                heather.Strcat (saved_input);
                tok = NULL;
                continue;
            }
            /* add a comment char out in front just to be sure. */
            if (strlen (saved_input) !=
                strspn (saved_input, WHITESPACE)) comets.Strcat ("# ");
            comets.Strcat (saved_input);
            tok = NULL;
            continue;
        }

    }

    /* close up shop */
    fclose (in_file);

    *nreqs = next_req;
    if (nmarks) *nmarks = num_summary_marks;
    if (nsess) *nsess = num_sessions;
    if (ugly_think) *ugly_think = mean_thinky_time;
    if (cuss_think) *cuss_think = custom_think;
    return num_reqs;
}

/* ================================================================= */
/* ================================================================= */
/* ================================================================= */

void
wl_print_requests (int nreq, request_entry_t *requests)
{
    /* print out the requests.  Note that the perl scripts used for 
     * data analysis expects the printout to be in this format, including
     * the "number of requests this trial" heading up this section.
     */
    prt("\nnumber of requests this trial %d\n", nreq);
    for (int i=0; i<nreq; i++) 
    {
        if (strcmp(requests[i].method,"GET")==0) {
            prt("%2d: %s %s fraction:%5.3f check_sum:%u\n",i,
                requests[i].method, 
                requests[i].url, 
                requests[i].fraction, 
                requests[i].check_sum);
        } else {
            prt("%2d: %s %s %s fraction:%5.3f check_sum:%u\n",i,
                requests[i].method, 
                requests[i].url, 
                requests[i].data, 
                requests[i].fraction, 
                requests[i].check_sum);
        }
    }
}

/* ================================================================= */
/* ================================================================= */
/* ================================================================= */

void
wl_validate_requests (int nreq, request_entry_t *requests, wlOpts &opts)
{
    // validate the requests -- if no global web server was specified,
    // then all requests must begin with http:// or https://
    int no_default_server = (0 == opts.webserver.Memlen());

    for (int i=0; i<nreq; i++) 
    {
        char * earl = requests[i].url;

        if (strncasecmp (earl, HTTP_STRING, strlen (HTTP_STRING)) &&
            strncasecmp (earl, HTTPS_STRING, strlen (HTTPS_STRING)))
        {
            if (no_default_server) {
                PFATAL("invalid request %s %s\n"
                    "\tspecify either the -w (--webserver) flag, or\n"
                    "\tmake all requests begin with http:// or https://\n",
                    (char *)requests[i].method, earl);
                exit (33);
            } 
            else
            if ('/' != earl[0]) {
                PFATAL("url needs to begin with a slash or http\n"
                    "\trequest was %s %s\n",
                    (char *)requests[i].method, earl);
                exit (33);
            }
        }
    }
}

/* ================================================================= */
/* ================================================================= */
/* ================================================================= */
/* ================================================================= */
/* this routine goes through a block of requests, collecting stats */

int 
run_requests (int            start_req,
              int            num_req, 
              wlOpts&        global_opts,
              wlFetchPage&   global_fetch,
              request_entry_t *requests,
              time_t         stats_start_time,
              stats_t       *request_stats,
              stats_t       *mark_stats,
              stats_t       &trial_stats,
              int            trial,
              int            try_id,
              int           *ignored_check_sum_errors,
              int            custom_think,
              time_struct   *heartbeat
)
{
    int     i;
    int     this_request;
    int     error_in_trial = 0;
    time_struct request_start;
    time_struct pre_think, post_think;
    time_struct now, duran;

    int     child_number = global_opts.child_number;
    shm_entry_t *shm_info = (shm_entry_t *) (global_opts.shm_base + 4);

    /* ******************************************************** */
    /* now actually run the trial. ............................ */
    /* ******************************************************** */
    for(this_request = start_req; this_request < start_req+num_req; )
    {
        int     dry = -1;

        if (0 < global_opts.shm_key) 
        {
            shm_info[child_number].request = this_request;
        }

        /* Check to see if we have a block of URL's that
         * need to be run in unison.  If so, then determine 
         * the size of the block, and teh number of times to 
         * run the block.  If the block length is "1", then 
         * just run the request. Otherwise, make a recursive call.
         */


        /* find the length of the sub block of requests */
        int block_len = 1;
        while ((block_len < num_req) && 
               (0.0 > requests[this_request+block_len].fraction)) 
        { 
            block_len ++; 
        }

        /* find the number of times to run the request.  For 
         * for fractional values, use a random number generator
         */
        double request_repeat_count = requests[this_request].fraction;
        int ntries = (int) (request_repeat_count + 0.0000001); 
        double urand = ((double)RANDOM())/((double) RAND_MAX);
        double frac = request_repeat_count - (double) ntries;
        if (urand < frac) { ntries ++; }

        /* if we are in "retraining mode" (only running through the 
         * requests to recompute the check sum), then run each url 
         * only once.
         */
        if (global_opts.url_out_file) ntries = 1;

        /* If we have a block of requests to run, run them 
         * by invoking ourselves recursively
         */
        if (1 < block_len) 
        {
            PDBG1 ("found block at %d of len %d\n", this_request, block_len);

            /* avoid bogus recursion */
            for (i = 0; i<block_len; i++) {
                requests[this_request+i].saved_fraction = 
                    requests[this_request+i].fraction;
                requests[this_request+i].fraction = 1.0;
            }

            /* run the block over & over ... */
            for (dry=0; dry < ntries; dry++) 
            {
                error_in_trial = run_requests (this_request, block_len,
                                       global_opts,
                                       global_fetch,
                                       requests,
                                       stats_start_time,
                                       request_stats,
                                       mark_stats,
                                       trial_stats,
                                       trial,
                                       try_id + dry,
                                       ignored_check_sum_errors,
                                       custom_think,
                                       heartbeat
                                       );
                if (error_in_trial || have_been_interrupted) return (error_in_trial);
            }

            /* restore the correct count */
            for (i = 0; i<block_len; i++) {
                requests[this_request+i].fraction = 
                    requests[this_request+i].saved_fraction;
                requests[this_request+i].saved_fraction = 0.0;
            }
            this_request += block_len;
            continue;  /* thats it for this block */
        } 

        if (0 == ntries) 
        {
            PDBG1 ("skipped this request.\n");
            if (global_opts.write_completion_times) {
                prt("TPUT <SKIP>  trial=%d req=%d\n", trial, this_request);
            }
            this_request ++;
            continue;
        }

        PDBG1 ("run request %d %d times\n", this_request, ntries);

        /* **************************************************** */
        /* get values for this request out of the request array */
        /* **************************************************** */
        int expected_check_sum = requests[this_request].check_sum;
        char * method = requests[this_request].method;
        check_sum_info_t expected_check_sum_info =
            requests[this_request].expected_check_sum_info;
        int have_expected_check_sum_info = 
            requests[this_request].have_expected_check_sum_info;
        int current_mark = requests[this_request].mark;
    
        wlString post_data;
        if (0 == strcmp(method,"POST"))
        {
            /* ************************************************ */
            /* handle substitution of user, userpin, userpasswd */
            /* in POST data ................................    */
            /* ************************************************ */
            post_data = requests[this_request].data;
            post_data.SubMulti (global_opts.substitution_key,
                            global_opts.substitution_value);
        }

        /* ******************************************************* */
        /* handle substitution of user, userpin, userpasswd in url */
        /* ******************************************************* */
        wlString url;
        url = requests[this_request].url;
        url.SubMulti (global_opts.substitution_key,
                  global_opts.substitution_value);


        /* Build the header string.  Do this by concatenating the  */
        /* global header with the per-uri header.                  */
        wlHeader header;
        header = global_opts.header;
        header.Strcat (requests[this_request].header);

        /* Over-ride any header field values, including, possibly */
        /* the "Host:" tag, which is why we subst every time.     */
        char    tmp[MAXINPUTLINELENGTH];
        sprintf(tmp,"%s:%hu", (char *)global_opts.webserver, 
            global_opts.web_portnum);
        header.ReplaceField ("Host", tmp);
        header.ReplaceFields (
            global_opts.header_subst_field,
            global_opts.header_subst_value);
            header.ReplaceOrAddFields (
            global_opts.header_add_field,
            global_opts.header_add_value);

        PDBG("\n\t====================================\n"
             "\tthis_request=%d: %s %s fraction:%5.3f check_sum:%u\n" 
             "\t====================================\n",
            this_request, (char *)method, (char *)url, 
            request_repeat_count, expected_check_sum);

        for (dry=0; dry < ntries; dry++) 
        {
            if (0 < global_opts.shm_key) 
            {
                shm_info[child_number].dry = dry;
            }

            TIMESTAMP(&request_start);
            CONVERTTIME(&request_start);
            if (global_opts.write_completion_times) {
                prt ("TPUT <START> try=%d req=%d trial=%d date=%12.3f\n",
                    try_id+dry, this_request, trial, MS(timevaldouble(&request_start)));
            }

            /* ******************************************************** */
            /* submit the request. .................................... */
            /* ******************************************************** */
            if (global_opts.write_url_progress) {
                prt ("TPUT <URL>   try=%d req=%d trial=%d url=%s\n", 
                    try_id+dry, this_request, trial, (char *)url);
            }
            /* XXX hack alert ?? do we really need to copy in a new url, etc.
             * every time? we could save some CPU cycles ...  */
            global_fetch.request.method = method;
            global_fetch.request.url = url;
            global_fetch.request.header = header;
            global_fetch.request.body = post_data;
            global_fetch.request.bug_compat = global_opts.bug_compat;
            int getpagerc = global_fetch.FetchPage ( 
                global_opts.webserver, global_opts.web_portnum,
                global_opts.proxyserver, global_opts.proxy_portnum, 
                global_opts);

            TIMESTAMP(&pre_think);
            requests[this_request].ran_request_this_trial ++;

            if (0 < global_opts.shm_key) {
                shm_info[child_number].requests++;
                shm_info[child_number].total_bytes += 
                    global_fetch.ptimer.setup.bytesread +
                    global_fetch.ptimer.last.bytesread +
                    global_fetch.ptimer.gif.bytesread;

                shm_info[child_number].html_bytes += 
                    global_fetch.ptimer.last.bodybytes;
                shm_info[child_number].gif_bytes += 
                    global_fetch.ptimer.gif.bodybytes;

                shm_info[child_number].connects += 
                    global_fetch.ptimer.number_of_connects;
                shm_info[child_number].gif_files += 
                    global_fetch.ptimer.num_gifs_fetched;

                shm_info[child_number].first_response += 
                    MS(timevaldouble(&global_fetch.ptimer.first_data_response_time));
                shm_info[child_number].end_to_end += 
                    MS(timevaldouble(&global_fetch.ptimer.getpage_time));
            }

            sum_of_getpage_times += timevaldouble(&global_fetch.ptimer.getpage_time);

            /* append the error information and a copy of the request 
              * to the log file. But do this only if this wasn't the
              * "let's quit now" signal, since that's not an error,
              * its just a request to exit cleanly */
            if ((0 != getpagerc) &&
                (GET_SIGINT_ERROR != getpagerc) &&
                (GET_SIGHUP_ERROR != getpagerc) &&
                (GET_SIGFIN_ERROR != getpagerc)) 
            {
                errlck();
                if (0 < getpagerc)
                {
                    pfatal("*********** FetchPage received HTTP Status %d ***********\n",
                        getpagerc);
                    pfatal("\tHTTP response: %s\n", 
                        (char *) global_fetch.reply.status);
                }
                else 
                {
                    pfatal("*********** FetchPage returned error=%d ***********\n",
                        getpagerc);
                    pfatal("\tError text: %d %s\n", 
                        getpagerc, webload_error(getpagerc));
                }
                pfatal ("\tError ocurred at %s", timeofday());
                pfatal ("\tError occurred on try %d of request %d "
                        "of trial %d.\n",
                        dry, this_request, trial);

                if (global_opts.shm_key > 0) {
                    pfatal("\tThis error is from child number %d\n",
                        child_number);
                }
                pfatal ("%s", REQ_START);
                /* rebuild the request */
                global_fetch.request.Assemble();
                pfatal ("%s\n", (char *) global_fetch.request.message);
                pfatal ("%s", ERROR_END);
                pfatal("************trial is being aborted**********\n");
                errunlck();


                /* only negative return values count as true errors */
                /* not true; we want 500 Server Error to end it all */
                /* if (0 > getpagerc) {  */
                    error_in_trial++;
                    return (error_in_trial);
                /* } */
            } /* end of if-getpage-rc-not-zero */
            else
            if (GET_SIGINT_ERROR == getpagerc) 
            {
                PINFO("interrupted on try %d of request %d of trial %d\n",
                    dry, this_request, trial);
                perr ("\tcurrent request was %s %s \n",
                    (char *)method, (char *)url);
                perr("\tInterrupt ocurred at %s", timeofday());
                perr("\tWill exit cleanly \n");
                perr("************trial is being aborted**********\n");
                error_in_trial++;
                return (error_in_trial);
            }
            else
            if (GET_SIGHUP_ERROR == getpagerc) 
            {
                PINFO("received SIGHUP on try %d of request %d of trial %d\n",
                    dry, this_request, trial);
                perr ("\tcurrent request was %s %s \n",
                    (char *)method, (char *)url);
                perr ("\twill retry this request\n");
                dry --;
                continue;
            }

            else
            if (GET_SIGFIN_ERROR == getpagerc) 
            {
                PINFO("received SIGFIN on try %d of request %d of trial %d\n",
                    dry, this_request, trial);
                perr ("\tcurrent request was %s %s \n",
                    (char *)method, (char *)url);
                perr ("\tabandoning this page, moving to next page\n");
                continue;
            }

            if ((!(global_opts.ignore_checksum_errors)) && 
                (expected_check_sum != global_fetch.simple_check_sum)) 
            {
                /* value of zero means skip this compare */
                if (0 == expected_check_sum) 
                {
                    PINFO ("Skipping checksum compare for %s\n", 
                        (char *)url);
                    (*ignored_check_sum_errors)++;
                } 
                else 
                {
                    if (global_opts.warn_checksum_errors)
                    {
                        PINFO ("Ignoring checksum error for %s\n" 
                               "\tactual checksum %u expected checksum %u\n",
                            (char *)url,
                            global_fetch.simple_check_sum,expected_check_sum);
                        (*ignored_check_sum_errors)++;
                    }
                    else
                    {
                        /* else ... if we are not ignoring checksums, and we
                         * aren't flagging them as warnings, then they are fatal.
                         * print full diagnostics and exit
                         */
                        errlck();
                        pfatal ("%s",CHKSUMERRMSG);
                        pfatal ("\tError ocurred at %s", timeofday());
                        pfatal ("\tError occurred on try %d of request %d "
                            "of trial %d. getpagerc=%d\n",
                            dry, this_request, trial, getpagerc);
                        if (0 <global_opts.shm_key) 
                        {
                            pfatal ("\tThis error is from child number %d\n",
                                child_number);
                        }
                        pfatal ("\tactual checksum %u expected checksum %u\n",
                            global_fetch.simple_check_sum,expected_check_sum);
                        pfatal ("\tcheck_sum_info:          checksum:%8d sum=%8d "
                            "size=%8d line=%8d length=%8d\n", 
                            global_fetch.simple_check_sum,
                            global_fetch.cs_info.sum, 
                            global_fetch.cs_info.size, 
                            global_fetch.cs_info.line,
                            global_fetch.cs_info.length);
                        if (have_expected_check_sum_info) 
                        {
                            pfatal ("\texpected_check_sum_info: checksum:%8u "
                                "sum=%8d size=%8d line=%8d length=%8d\n", 
                                expected_check_sum, 
                                expected_check_sum_info.sum, 
                                expected_check_sum_info.size,
                                expected_check_sum_info.line, 
                                expected_check_sum_info.length);
                        }
                        if (global_opts.trace_file) {
                            fprintf (global_opts.trace_file,CHKSUMERRMSG);
                            fprintf (global_opts.trace_file,
                                "\tcheck_sum_info:          sum=%8d "
                                "size=%8d line=%8d length=%8d\n",
                                global_fetch.cs_info.sum, 
                                global_fetch.cs_info.size, 
                                global_fetch.cs_info.line,
                                global_fetch.cs_info.length);
                            if (have_expected_check_sum_info) {
                                fprintf (global_opts.trace_file,
                                    "\texpected_check_sum_info: checksum:%8u "
                                    "sum=%8d size=%8d line=%8d length=%8d\n", 
                                    expected_check_sum, 
                                    expected_check_sum_info.sum, 
                                    expected_check_sum_info.size,
                                    expected_check_sum_info.line, 
                                    expected_check_sum_info.length);
                            }
                            fflush (global_opts.trace_file);
                        }
    
                        /* append the checksum info, a copy of the request, 
                         * a copy of the response to the log file */

                        pfatal ("%s", REQ_START);
                        global_fetch.request.Assemble();
                        pfatal ("%s", (char *) global_fetch.request.message);
                        pfatal ("%s", RSP_START);
                        pfatal ("%s", (char *) global_fetch.reply.message);
                        pfatal ("%s", ERROR_END);
    
                        pfatal("\t************trial is being aborted**********\n");
                        errunlck();
                        error_in_trial++;
                        return (error_in_trial);
                    }
                }
            } /* end if-bad-checksum */

            /* fall out of the loop if we have been interrupteted... */
            /* or we have encountered an error ..................... */
            if (have_been_interrupted || error_in_trial) return error_in_trial;

            /* ***************************************************** */
            /* write the output file, if requested. ................ */
            /* we set count to 1 to make sure this happens only once */
            /* (added: check on iter == 1). ........................ */
            /* ***************************************************** */
            if (global_opts.url_out_file) 
            {
                /* if there are any comments stored with this URL,   */
                /* write them into the new url file now. ........... */
                fprintf(global_opts.url_out_file,"%s\n",
                    (char *)requests[this_request].comments);

                fprintf (global_opts.url_out_file,"<<REQUEST>> %s %s\n", 
                    requests[this_request].method,
                    requests[this_request].url);

                fprintf(global_opts.url_out_file,"%s\n",
                        (char *)requests[this_request].header);

                if (0 ==  strcmp(method,"POST")) {
                    fprintf(global_opts.url_out_file,
                        "<<POSTDATA>>\n%s\n<</POSTDATA>>\n",
                        requests[this_request].data);
                } 
                fprintf(global_opts.url_out_file, 
                    "<<COUNT>> %8.3f\n<<CKSUM>> %u %d %d %d %d\n",
                    requests[this_request].fraction, 
                    global_fetch.simple_check_sum,
                    global_fetch.cs_info.sum, 
                    global_fetch.cs_info.size, 
                    global_fetch.cs_info.line,
                    global_fetch.cs_info.length);


                /* write out the custom think times */
                if (custom_think) 
                {
                    if (! FEQ (0.0, requests[this_request].thinks))
                    {
                        if (! FEQ (global_opts.mean_think_time, requests[this_request].thinks))
                        {
                            fprintf (global_opts.url_out_file, "<<THINK>> %f \n",
                                requests[this_request].thinks);
                        }
                        else 
                        {
                            fprintf (global_opts.url_out_file, "<<THINK>>\n");
                        }
                    }
                }

                /* put down statistics markers */
                if (((this_request-1) == start_req+num_req) || 
                    (((this_request-1) < start_req+num_req) &&
                    (requests[this_request].mark != 
                     requests[this_request+1].mark)))
                {
                    fprintf (global_opts.url_out_file, "<<MARK>>\n");
                }

            } /* end of if-new-url-file */

            /* Don't print statistics, don't have a think time, none  */
            /* of that is done if in training mode ...................*/
            else
            {
                /* ************************************************** */
                /* simulate the user's think time. .................. */
                /* Positive think times use randomized think time.    */
                /* Negative think times denote a fixed interval       */
                /* ************************************************** */
                double dinky = 0.0;
                dinky = requests[this_request].thinks;

                switch (requests[this_request].distro)
                {
                    case wlOpts::THINK_FIXED:
                        dinky = FABS(dinky);
                        break;
                    case wlOpts::THINK_EXPONENTIAL:
                        dinky = random_exponential(dinky);
                        break;
                    case wlOpts::THINK_GAUSSIAN:
                        dinky = random_gaussian(dinky);
                        break;
                }
                sum_of_think_times += dinky;
                if (0.0 < dinky) {
                    PDBG("Sleeping for %8.3fs\n", dinky);
                    SLEEP (dinky);
                    if (have_been_interrupted) 
                    {
                        PINFO("interrupted during sleep after "
                            "try %d of request %d of trial %d\n",
                            dry, this_request, trial);
                        perr ("\tlast request was %s %s \n",
                            (char *)method, (char *)url);
                        perr("\tInterrupt ocurred at %s", timeofday());
                        perr("\tWill exit cleanly \n");
                        perr("************trial is being aborted**********\n");
                        error_in_trial++;
                    }
                    PDBG("Awake......\n");
                }

                /* Measure the actual think time. Also measure the total request time
                 * including the think time. Note that the end_to_end_time should equal,
                 * to within microseconds, the ptimer.getpage_time.  That's because both
                 * measure the same thing.  We use this value here so that we can have 
                 * an exact math equivalence of think + end_to_end = request_time
                 * rather than something that is off by a few microseconds.  Cleanliness 
                 * you know.
                 */
                TIMESTAMP(&post_think);
                CONVERTTIME(&pre_think);
                CONVERTTIME(&post_think);
                wl_difftime(&pre_think,&request_start,&global_fetch.ptimer.end_to_end_time);
                wl_difftime(&post_think,&pre_think,&global_fetch.ptimer.think_time);
                wl_difftime(&post_think,&request_start,&global_fetch.ptimer.request_time);

                /* ****************************************************** */
                /* now record and update statistics. .................... */
                /* ****************************************************** */
    
                DT_PRINTF1("number_of_redirects:%d "
                    "number_of_connects:%d\n",
                    global_fetch.ptimer.number_of_redirects, 
                    global_fetch.ptimer.number_of_connects);
                DT_PRINTF1("bytes_xferred:%d "
                    "gif bytes:%d\n",
                    global_fetch.ptimer.last.bytesread, 
                    global_fetch.ptimer.gif.bytesread);

                for(i=0;i<NPTIMER_TIME_STRUCT;i++) {
                    DT_PRINTF1("%s=%f\n",global_fetch.ptimer.timer_names[i],
                        timevaldouble(& ((time_struct *) &global_fetch.ptimer.getpage_entry)[i]));
                }
                DT_PRINTF1("number_of_gif_files:%d number_of_gif_btyes:%d\n",
                    global_fetch.ptimer.num_gifs_fetched, 
                    global_fetch.ptimer.gif.bodybytes);

                /* make a record of the statistics.                      */
                /* however, for multi-client runs (shm_key non-zero)     */
                /* do *not* record any statistics until the rampup has   */
                /* completed. Rampup is done when (global_com_area[2]>0) */
                if ((0 == global_opts.shm_key) || (0 != stats_start_time)) 
                {


                    wl_obs_stats (request_stats[this_request], 
                                  global_fetch.ptimer, 
                                  dry, this_request, trial, global_opts);
                    wl_xfer_stats (request_stats[this_request], 
                                   global_fetch.ptimer);
                    wl_xfer_stats (mark_stats[current_mark], 
                                   global_fetch.ptimer);
                    wl_xfer_stats (trial_stats, 
                                   global_fetch.ptimer);

                } /* end of if on (shm_key==0) || (global_com_area[2]>0) */


                TIMESTAMP(&now);
                CONVERTTIME(&now);
                wl_difftime(&now,heartbeat,&duran);
                if (timevaldouble(&duran) > 60.0) {
                    time_t today = (time_t) timevaldouble (&now);
                    
                    prt("Working... try=%d req=%d trial=%d date=%s", 
                        try_id+dry, this_request, trial, ctime (&today));
                    *heartbeat = now;
                }

                /* write the individual request data out */
                if (global_opts.write_completion_times) {
                    prt ("TPUT <END>   try=%d req=%d trial=%d date=%12.3f\n",
                        try_id+dry, this_request, trial, MS(timevaldouble(&now)));
                }

            } /* end of print-stats */

            /* fall out of the loop if we have been interrupteted... */
            /* or we have encountered an error ..................... */
            if (have_been_interrupted || error_in_trial) return error_in_trial;

        } /* end of loop on request-repeat-count */

        if (have_been_interrupted || error_in_trial) return error_in_trial;
        this_request ++;
    } /* end of loop over all requests */
    return error_in_trial;
}

/* ================================================================= */
/* ================================================================= */
/* ================================================================= */
/* ================================================================= */

#define PROGNAME global_opts.progname
#define MAX_URL_PER_TRIAL 1000

int
main(int argc, char *argv[])
{
    int 	i, rc;
    int	    custom_think = 0;
    double  ugly_think_time;
    int     needchks;

    int     session_repetitions, saved_session_repetitions = -1;
    int     trial = -1;
    int     successful_trials = 0;
    int     error_in_trial = 0;

    /* The requests array is used to store a copy of the list
     * of URL's & other data that were read from the input file.
     * The "requests" are what will be played back to the web server.
     */
    request_entry_t *requests=NULL;
    int     number_of_requests_per_session = 0;
    int     this_request = -1;

    request_entry_t *clean_exit_requests=NULL;
    int     number_of_clean_exit_requests = 0;

    /* request_stats, etc are the structures in which the data
     * about each trial are collected.  The _save versions of 
     * these are used to retain a clean copy, just in case the 
     * test is exited mid-trial, as a result of a user interrupt.
     */
    stats_t     *request_stats=NULL;
    stats_t     *request_stats_save=NULL;

    stats_t     *mark_stats=NULL;
    stats_t     *mark_stats_save=NULL;
    int         number_of_marks = 0;

    stats_t     trial_stats;
    stats_t     trial_stats_save;
    time_t		stats_save_time = 0;
    time_t		stats_start_time = 0;

    /* misc stats */
    int     ignored_check_sum_errors = 0;

    time_struct trial_start, trial_end, trial_duration;
    time_struct heartbeat;
    time_struct when_interrupted;


    int child_number = -1; 
    shm_entry_t *shm_info = NULL;

    /* global_com_area is a 4 word array used to synch starts   */
    /* of the clients                                           */
    /* word 0 is the number of children that are ready to start */
    /* word 1 is the global start flag -- it is set by the      */
    /* parent to control when children start.  It is initialized*/
    /* to -1; during ramp up, it has value N to indicate that   */
    /* all children up through child N should start submitting  */
    /* requests.  This is used to "ramp up" the workload so     */
    /* that everyone is not running exactly the same transaction*/
    /* at the same time. ...................................... */
    /* word 2 is used to indicate that rampup is complete...... */
    /* during rampup, response time statistics are not collected*/
    /* word 2 is zero during ramp up and 1 after rampup. ...... */
    /* word 3 is used for version synchronization ...........   */

    volatile int *global_com_area = NULL;

    setbuf(stdout,NULL);
    prt("Info: %s: begins..............\n", argv[0]);

    /* 
     * Parse the command line options
     */
    wlOpts global_opts;
    global_opts.ParseArgs (&argc, argv);
    quiet_stdout = global_opts.quiet_stdout;
    debug = global_opts.debug;
    tdebug = global_opts.tdebug;
    rc = global_opts.ProcessOpts ();
    if (rc) exit (rc);
    error_log = global_opts.error_log;
    error_log_file = global_opts.error_log_file;
    report_file = global_opts.report_file;
    global_opts.PrintOptionsSummary ();

    /* set up old-fashioned global vars, for now */
    child_number = global_opts.child_number;

    /* ************************************************************ */
    /* initialize the error message array. .........................*/
    /* ************************************************************ */
    init_webload_errors();

    /* ******************************************************** */
    /* build the header string, including the "host" tag....... */
    /* ******************************************************** */
    wlHeader header;
    header = global_opts.header;
    header.ReplaceFields (
        global_opts.header_subst_field,
        global_opts.header_subst_value);
    header.ReplaceOrAddFields (
        global_opts.header_add_field,
        global_opts.header_add_value);

#ifdef USE_SOCKS
    SOCKSinit(PROGNAME);
#endif /* USE_SOCKS */

#ifndef WIN32
    /* attach to the shared memory region (if needed) .............. */
    /* (the shared memory region must be created by the parent) .... */
    if (0 < global_opts.shm_key) 
    {
        int shm_id=0;
        char tmp[6];

        if ((0>child_number) || 
           (((SHMSIZE/sizeof(shm_entry_t))-3) < child_number))
        {
            PFATAL("child number out of range\n"
                "\tchild_num=%d minallowed=0, maxallowed=%d\n",
                child_number, (SHMSIZE/sizeof(shm_entry_t))-3); 
            global_opts.CloseFiles();
            return 3;
        }
        shm_id = shmget(global_opts.shm_key,SHMSIZE,S_IRUSR | S_IWUSR);
        if (0 > shm_id) 
        {
            int norr = errno;
            PFATAL("shmget failed, giving up\n"
                "\terrno=%d (%s)\n", norr, strerror (norr));
            global_opts.CloseFiles();
            return 3;
        }
        PDBG ("shmget returned shm_id=%d\n",shm_id);
        global_opts.shm_base = (int *)shmat(shm_id,0,0);
        if (0x0 == global_opts.shm_base) 
        {
            int norr = errno;
            PFATAL("shmat shared memory attach faild \n" 
                "\terrno=%d (%s)\n", norr, strerror (norr));
            global_opts.CloseFiles();
            return 3;
        }
        PDBG("shmat returned %p\n", global_opts.shm_base);

        /* there are 4 integers (16 bytes) in the global_com_area */
        /* word zero is the number of children who are ready to start */
        /* word one  is the global start flag -- it is set by the     */
        /* parent to control when children start.  It is initialized  */
        /* to -1; during ramp up, it has value N to indicate that all */
        /* children up through child N should start submitting        */
        /* requests. ................................................ */
        /* word two is used to indicate that rampup is complete...... */
        /* during rampup, response time statistics are not collected. */
        /* word two is zero during ramp up and 1 after rampup. ...... */
        /* word three is used for version synchronization ........... */
        global_com_area = global_opts.shm_base;

        shm_info = (shm_entry_t *) (global_com_area + 4);
        shm_info[child_number].trial   = 0; 
        shm_info[child_number].dry     = -1;
        shm_info[child_number].request = -1;
        shm_info[child_number].requests    = 0;
        shm_info[child_number].connects    = 0;
        shm_info[child_number].gif_files   = 0;
        shm_info[child_number].first_response = 0;
        shm_info[child_number].end_to_end  = 0;
        shm_info[child_number].total_bytes = 0;
        shm_info[child_number].html_bytes  = 0;
        shm_info[child_number].gif_bytes   = 0;
        shm_info[child_number].running[0] = 'M';
        shm_info[child_number].running[1] = 'A';
        shm_info[child_number].running[2] = 'I';
        shm_info[child_number].running[3] = 'N';
        tmp[0] = '\0';
        strncpy(tmp,(char *)&global_com_area[3],4);
        tmp[4] = '\0';
        if (strcmp(tmp,EXPECTED_PARENT_VERSION) != 0) {
            PFATAL ("Version mismatch between run.workload and %s\n"
                "\tFound version: %s "
                "Expected version: " EXPECTED_PARENT_VERSION "\n", 
                argv[0], tmp);
            global_opts.CloseFiles();
            shm_info[child_number].running[0] = 'S';
            shm_info[child_number].running[1] = 'T';
            shm_info[child_number].running[2] = 'O';
            shm_info[child_number].running[3] = 'P';
            return 3;
        }
    }
#endif /* WIN32 */

#if (defined (USE_SKIT) || defined (USE_SSLEAY))
    global_opts.client_ssl_opts.Init(0);
    global_opts.server_ssl_opts.Init(1);
#endif /* USE_SKIT || USE_SSLEAY */

    requests = new request_entry_t[MAX_URL_PER_TRIAL];

    number_of_requests_per_session = MAX_URL_PER_TRIAL;
    needchks = 1;
    if (global_opts.url_out_file) needchks = 0;
    if (global_opts.ignore_checksum_errors) needchks = 0;
    wl_read_requests (global_opts.input_file_name, 
                      requests, 
                      &number_of_requests_per_session,
                      &number_of_marks,
                      &session_repetitions,
                      &ugly_think_time,
                      &custom_think,
                      needchks);

    /* let the command line override the mean think time      */
    /* specified in the file.                                 */
    /* if the mean think time is not large and negative,      */
    /* then it was specified on a command-line flag, and the  */
    /* value in the file should be ignored.  ................ */
    if (-1.0e19 > global_opts.mean_think_time) {
        global_opts.mean_think_time = ugly_think_time;
    }

    /* doctor up the think times, in a backwards compatible way. */
    if (custom_think) 
    {
        for (i=0; i<number_of_requests_per_session; i++) 
        {
            if (-1.0e19 > requests[i].thinks)
            {
                requests[i].thinks = global_opts.mean_think_time;
            }
        }
    }
    else
    {
        for (i=0; i<number_of_requests_per_session; i++) 
        {
            requests[i].thinks = global_opts.mean_think_time;
        }
    }
    for (i=0; i<number_of_requests_per_session; i++) 
    {
        if (0.0 > requests[i].thinks) {
            requests[i].distro = wlOpts::THINK_FIXED;
            requests[i].thinks = - requests[i].thinks;
        } else {
            requests[i].distro = global_opts.think_distribution;
        }
    }

    if (global_opts.clean_exit_file_name) {
        clean_exit_requests = new request_entry_t [MAX_URL_PER_TRIAL];

        number_of_clean_exit_requests = MAX_URL_PER_TRIAL;
        wl_read_requests (global_opts.clean_exit_file_name, 
                          clean_exit_requests, 
                          &number_of_clean_exit_requests,
                          NULL, NULL, NULL, NULL, 0);
    }

    // validate the requests -- if no global web server was specified,
    // then all requests must begin with http:// or https://
    wl_validate_requests (number_of_requests_per_session, 
        requests, global_opts);
    wl_validate_requests (number_of_clean_exit_requests,
        clean_exit_requests, global_opts);

    // print the requests. Note that the perl data analysis scripts need this
    wl_print_requests (number_of_requests_per_session, requests);

    // if (global_opts.clean_exit_file_name) {
    //    PINFO ("the following cleanup script will run:\n");
    // }

    /* let the command line override what was found in the config file */
    if (-1 < global_opts.num_sessions) {
        session_repetitions = global_opts.num_sessions;
    } else {
        global_opts.num_sessions = session_repetitions;
    }
    prt("\nnumber of times to run this session: %d \n",
        session_repetitions);
        
    if (0.0 >= global_opts.mean_think_time) {
        prt("fixed think_time: %8.3f seed: %d\n\n",
        FABS(global_opts.mean_think_time), global_opts.seed);
    } else {
        prt("random think_time: %8.3f seed: %d\n\n",
        global_opts.mean_think_time, global_opts.seed);
    }
        
    /* initialize statistics. ......................................... */
    /* request_stats, etc are the structures in which the data
     * about each trial are collected.  The _save versions of 
     * these are used to retain a clean copy, just in case the 
     * test is exited mid-trial, as a result of a user interrupt.
     */
    request_stats = (stats_t *) 
        malloc ((number_of_requests_per_session +1) * sizeof (stats_t));
    request_stats_save = (stats_t *) 
        malloc ((number_of_requests_per_session +1) * sizeof (stats_t));
    mark_stats = (stats_t *) 
        malloc ((number_of_marks+1) * sizeof (stats_t));
    mark_stats_save = (stats_t *) 
        malloc ((number_of_marks+1) * sizeof (stats_t));

    for(i=0;i<(number_of_requests_per_session+1);i++) 
    {
        wl_initialize_stats (request_stats[i]);
    }
    for(i=0;i<(number_of_marks+1);i++) 
    {
        wl_initialize_stats (mark_stats[i]);
    }
    wl_initialize_stats (trial_stats);

#ifndef WIN32
    /* If we got to here, the basic setup must have succeeded.  */
    /* fork and run in background   ........................... */
    if (global_opts.run_in_background) {
        pid_t pid;

        /* avoid having multiple copies of buffered stuff being
         * written to the report file.  Flush the buffers *before* 
         * we fork. */
        if (global_opts.trace_file) fflush(global_opts.trace_file);
        if (global_opts.report_file) fflush(global_opts.report_file);
        if (global_opts.url_out_file) fflush(global_opts.url_out_file);
        if (error_log_file) fflush(error_log_file);
        fflush (stdout);
        fflush (stderr);

        pid = fork();
        if (0 > pid) {
            PFATAL("can't fork to run in background\n");
            global_opts.CloseFiles();
            exit (4);
        }

        /* if the parent, then exit with return value of success */
        if (pid) exit (0);
    }
#endif /* WIN32 */

    /* We cannot create the threads until after the fork; otherwise, */
    /* when the parent exits, it takes the threads down with it.     */
    wlFetchPage global_fetch (global_opts.nthreads);

    /* ******************************************************* */
    /* coordinate startup of all children if multiple user run */
    /* ******************************************************* */
    if (0 < global_opts.shm_key) 
    {
        /* indicate that we are ready to begin. .............. */
        fetch_and_add((int *)&global_com_area[0],1);
        shm_info[child_number].running[0] = 'W';
        shm_info[child_number].running[1] = 'A';
        shm_info[child_number].running[2] = 'I';
        shm_info[child_number].running[3] = 'T';
        PINFO("child %d waiting for start notice\n", child_number);
        i=0;
        while (global_com_area[1] < child_number) 
        {
            SLEEP(2);
            i += 2;
            if (0 == i%20) {
                time_t now;
                now = time (0);
                PWARN("child %d still waiting for start signal %s", 
                    child_number, ctime (&now));
            }

            if (3000 < i) {
                PFATAL ("start message not received "
                    "after %d seconds. Aborting run \n", i);
                goto exit;
            }
        }
        shm_info[child_number].running[0] = 'R';
        shm_info[child_number].running[1] = 'U';
        shm_info[child_number].running[2] = 'N';
        shm_info[child_number].running[3] = ' ';
        PINFO("child %d starting now.\n",child_number);
    }

    {
        time_t	today;
        today = time (0);
        prt ("Trial started at %s\n", ctime (&today));
    }

    TIMESTAMP(&heartbeat);
    CONVERTTIME(&heartbeat);

    if (global_opts.write_completion_times) 
        prt ("TPUT <<START>> date=%12.3f\n", 
            MS(timevaldouble(&heartbeat)));

    /* in "training" mode we want to run everything once; 
     * but we still want to write the <<END>> directive 
     * out in the new file........ */
    if (global_opts.url_out_file) {
        fprintf(global_opts.url_out_file,"<<START>>\n");
        saved_session_repetitions = session_repetitions;
        session_repetitions = 1;
    }
    PDBG2 ("session_repetitions=%d saved_rep=%d\n",
        session_repetitions, saved_session_repetitions);

    /* ************************* */
    /* ok, now go run the trials */
    /* ************************* */
    for (trial=0; trial < session_repetitions; trial++) 
    {
        /* reset these in case we have run a previous trial  */
        /* and they were non-zero at the end of that */
        error_in_trial = 0;

        global_fetch.ResetSessionCounts();

        if (0 < global_opts.shm_key) 
        {
            shm_info[child_number].trial = trial;
            shm_info[child_number].dry = -1;
        }

        PDBG("\n\t==============================================\n"
             "\tstarting trial %d:\n\tnumber of requests this trial %d\n",
            trial, number_of_requests_per_session);


#if (defined (USE_SKIT) || defined (USE_SSLEAY))
        /* *********************************************************** */
        /* close the SSL connection so we get a clean start on next    */
        /* iteration (ie. get the true timing of the first request,    */
        /* without falling back to using the session of the last SSL   */
        /* connectiona ............................................... */
        /* *********************************************************** */
        if (global_opts.client_ssl_opts.use_ssl) {
            PDBG("clearing SSL server session cache\n");
            global_opts.client_ssl_opts.FlushContext();
        }
#endif /* USE_SKIT || USE_SSLEAY */

        /* start with an empty gif cache, empty cookie jar */
        global_fetch.ClearCache();

        sum_of_think_times = 0.0;
        sum_of_getpage_times = 0.0;

        /* ******************************************************** */
        /* because we may get intrerrupted (via SIGINT) and we want */
        /* to respond to an interrupt quickly, we don't finish the  */
        /* trial we get interrupted in.  This leaves the stats in a */
        /* not so complete state (ugh, messy).  Sooo..... what we do*/
        /* is to save the statistics state and revert to that state */
        /* if we get interrupted.   So save the state here......... */
        /* ******************************************************** */
        /* also used to handle the case where a trial fails and we  */
        /* want to report statistics for the trials that have thus  */
        /* far succeeded. ......................................... */
        /* ******************************************************** */
        for(i=0; i <number_of_requests_per_session; i++) 
        {
            request_stats_save[i] = request_stats[i];
            requests[i].ran_request_this_trial = 0;
        }
        for(i=0; i <number_of_marks; i++) 
        {
            mark_stats_save[i] = mark_stats[i];
        }
        trial_stats_save = trial_stats;
        stats_save_time = time (0);

        if ((0 != global_opts.shm_key) && 
            (0 == stats_start_time) && 
            (global_com_area[2]>0)) 
        {
            stats_start_time = stats_save_time;
            PINFO("Start collecting stats at %d %s \n",
                stats_start_time, ctime (&stats_start_time));
        }

        TIMESTAMP(&trial_start);
        CONVERTTIME(&trial_start);

        if(global_opts.write_completion_times) {
            prt ("TPUT <<START>> trial=%d date=%12.3f\n", 
                trial, MS(timevaldouble(&trial_start)));
        }

        /* now run the requests */
        error_in_trial = run_requests (0,  number_of_requests_per_session,
                                       global_opts,
                                       global_fetch,
                                       requests,
                                       stats_start_time,
                                       request_stats,
                                       mark_stats,
                                       trial_stats,
                                       trial,
                                       0,
                                      &ignored_check_sum_errors,
                                       custom_think,
                                      &heartbeat
                                       );

        if (error_in_trial || have_been_interrupted) goto abort_trial;

#if (defined (USE_SKIT) || defined (USE_SSLEAY))
        /* ********************************************************** */
        /* close the SSL session so we get a clean start on next      */
        /* iteration . .............................................. */
        /* ********************************************************** */
        if (global_opts.client_ssl_opts.use_ssl) {
            PDBG("flushing SSL server session\n");
            global_opts.client_ssl_opts.FlushContext();
        }
#endif /* USE_SKIT || USE_SSLEAY */

        if (global_opts.url_out_file) 
        {
            /* if there are any comments stored in the NEXT request, */
            /* put them in the new url file now....  (these comments */
            /* follow the LAST url in the input file-- we store them */
            /* in the NEXT request entry, but there is nothing else  */
            /* in with that entry................................... */
            this_request = number_of_requests_per_session;
            fprintf(global_opts.url_out_file,"%s\n", 
                (char *)requests[this_request].comments);

            /* now put out the ending record in the new url file. .. */
            fprintf(global_opts.url_out_file,"<<END>> %d %f\n", 
                saved_session_repetitions, global_opts.mean_think_time);
        } 

        if ((!(global_opts.skip_stats)) &&
            ((0 == global_opts.shm_key) || (0 != stats_start_time)) )
        /* ********************************************************* */
        /* revert to the stats as they were at the start of the      */
        /* trial if we got interrupted and we didn't finish the      */
        /* current trial or if we had an error in a trial that       */
        /* caused us to abort the test. ............................ */
        /* ********************************************************* */

        /* ******************************************************** */
        /* we don't collect statistics if we are running under      */
        /* control of run.workload and we have not yet completed    */
        /* ramp up. ................................................*/
        /* ******************************************************** */
        {
            /* **************************************************** */
            /* record the webclient specific per trial statistics . */
            /* **************************************************** */
            TIMESTAMP(&trial_end);
            CONVERTTIME(&trial_start);
            CONVERTTIME(&trial_end);
            wl_difftime(&trial_end,&trial_start,&trial_duration);
#define opts global_opts
            OBS_STATS2(trial_stats,trial_duration);
            OBS_STATS3 (trial_stats,sum_of_think_times, 
                sum_of_think_times);

            double main_overhead = timevaldouble(&trial_duration);
            main_overhead -= sum_of_getpage_times-sum_of_think_times;
            OBS_STATS3(trial_stats,sum_of_ovhd_times, main_overhead);
#undef opts 

            /* record the individual data in the report file. ......*/
            if (global_opts.write_completion_times) {
                prt ("TPUT <<END>> trial=%d date=%12.3f\n",
                    trial, MS(timevaldouble(&trial_end)));
            }
             
            /* ******************************************************/
               /* calculate the rest of the per trial statistics from  */
            /* the per request statistics                           */
            /* ******************************************************/
            /* we base an array in the statistics structure here    */
            /* and address using it. ...............................*/

            for(i=0; i<NUMBER_OF_DCL_STATS; i++) 
            {
                double dacc = 0.0;
                int ireq;
                sub_stats_t *dcl_stat;

                for (ireq=0; ireq < number_of_requests_per_session; ireq++) 
                {
                    /* skip observation if we did not run this request */
                    /* this trial. also handles the comment case. .... */
                    if (requests[ireq].ran_request_this_trial) 
                    {
                        sub_stats_t     *dcl_req_stat;

                        /* get address of the request structure....... */
                        dcl_req_stat = 
                            &request_stats[ireq].first_data_response_time;
                        /* add its value in to the running sum ....... */
                        dacc += dcl_req_stat[i].last_val;
                    }
                }

                   dcl_stat = &trial_stats.first_data_response_time;
                OBS_STATS_DBL(dcl_stat[i],dacc);
            }

            /* OK, do it again, but this time for the marked stats */
            for(i=0; i<NUMBER_OF_DCL_STATS; i++) 
            {
                double dacc = 0.0;
                int ireq;
                int next_mark = 0;

                for (ireq=0; ireq <= number_of_requests_per_session; ireq++) 
                {
                    /* record summary statistics for a subset        */
                    /* of requests, based on the "mark" group.       */
                    if ((next_mark != requests[ireq].mark)  ||
                        (ireq == number_of_requests_per_session)) 
                    {
                        sub_stats_t *dcl_stat;
                        /* don't record a stat if we didn't run 
                         * any portion of it. */
                        if (1.0e-20 < dacc) {
                               dcl_stat = 
                            &mark_stats[next_mark].first_data_response_time;
                            OBS_STATS_DBL(dcl_stat[i],dacc);
                        }
                        dacc = 0.0;
                        next_mark = requests[ireq].mark;
                    }

                    /* skip observation if we did not run this request */
                    /* this trial. also handles the comment case. .... */
                    if (requests[ireq].ran_request_this_trial) 
                    {
                        sub_stats_t     *dcl_req_stat;

                        /* get address of the request structure....... */
                        dcl_req_stat = 
                            &request_stats[ireq].first_data_response_time;
                        /* add its value in to the running sum ....... */
                        dacc += dcl_req_stat[i].last_val;
                    }
                }
            }
        } /* end if-skip-stats */

abort_trial:
        if (have_been_interrupted || error_in_trial)
        {
            int icnt;

            /* If we failed to complete the entire session,
             * roll back the statistics, so that we have a 
             * uniform sampling of all URL's in the session.
             */
            for(icnt=0; icnt < number_of_requests_per_session; icnt++) 
            {
                request_stats[icnt] = request_stats_save[icnt];
            }
            for(icnt=0; icnt < number_of_marks; icnt++) 
            {
                mark_stats[icnt] = mark_stats_save[icnt];
            }
            trial_stats = trial_stats_save;
        } 

        PDBG1("\n\t==========================\n"
              "\tend of trial %d\n" 
              "\t==========================\n",
             trial);

        /* fall out of the loop if we have been interrupteted..... */
        /* or if we have encountered an error .................... */
        if (have_been_interrupted || error_in_trial) break;


        /* ******************************************************** */
        /* if we were given a wait_interval, wait until the next time*/
        /* to start before starting the trial. .................... */
        /* ******************************************************** */
        if (0 < global_opts.wait_interval) 
        {
            PINFO("Sleeping for %d seconds\n", global_opts.wait_interval);
            SLEEP(global_opts.wait_interval);
            PINFO("Awake at %s", timeofday());
        }

      /* ************************ */
    } /* end of for loop on trial */
      /* ************************ */

    PDBG1("==========================================\n");
    prt ("\n");
    if (!have_been_interrupted) {
        if (!error_in_trial) {
            PINFO("Successfully completed trial %d\n\n",trial);
            successful_trials = trial;
        } else {
            PWARN("Error in trial %d\n\n", trial);
            successful_trials = trial -1;
        }
    } else {
        if (global_opts.report_file && global_opts.write_completion_times) 
        {
            TIMESTAMP(&when_interrupted);
            CONVERTTIME(&when_interrupted);
            if (global_opts.write_url_progress) {
                prt ("TPUT <<INTERRUPTED>> %12.3f\n",
                MS(timevaldouble(&when_interrupted)));
            }
        }
        PINFO("Interrupted during trial %d\n\n",trial);
        successful_trials = trial -1;
    }

    if (have_been_interrupted || error_in_trial)
    {
        PINFO("Last complete stats taken at %d %s\n", 
            stats_save_time, ctime (&stats_save_time));

        /* the goal of cleanup on exit is to try to run some URL's
         * (typically, a logoff sequence) to the web server no matter
         * what. Therefore, we'll just pound them out there, no matter
         * what kind of errors/inconsitencies get in our way. 
         */
        if (global_opts.clean_exit_file_name) {
            int clean_request;

            PINFO("Attempting to recover and exit cleanly\n");

            for(clean_request = 0; 
                clean_request <number_of_clean_exit_requests;
                clean_request++)
            {
                /* disable all frills */
                global_opts.ignore_checksum_errors = 1;
                global_opts.fetch_gifs = 0;

                PINFO("will cleanup with %s %s\n",
                    clean_exit_requests[clean_request].method,
                    clean_exit_requests[clean_request].url);

                /* pound on it */
                global_fetch.request.method = clean_exit_requests[clean_request].method;
                global_fetch.request.url = clean_exit_requests[clean_request].url;
                global_fetch.request.header = header;
                global_fetch.request.body = clean_exit_requests[clean_request].data;
                global_fetch.request.bug_compat = global_opts.bug_compat;
                int rc = global_fetch.FetchPage ( 
                    global_opts.webserver, global_opts.web_portnum,
                    global_opts.proxyserver, global_opts.proxy_portnum, 
                    global_opts);

                if (0 != rc) {
                    PERR("unable to cleanup on exit:\n\t%d %s\n"
                        "\tFailing request was %s %s\n",
                        rc, webload_error(rc),
                        clean_exit_requests[clean_request].method,
                        clean_exit_requests[clean_request].url);
                }
            }
        }
    }
    {
        time_t	today;
        today = time (0);
        PINFO("Trial completed at %s\n", ctime (&today));
    }

    /* ********************************************************** */
    /* don't print stats if there were no observations.  all of   */
    /* the stats actually have the same count, so we can use any  */
    /* one of them for this test. ............................... */
    /* ********************************************************** */
    if ((!(global_opts.skip_stats)) &&
        (1 <= trial_stats.first_data_response_time.count))
    {
        int ir;
        int next_mark;
        int last_req;

        PDBG1("==========================================\n\n");

        /* ********************************************************* */
        /* ********************************************************* */
        /* print out the per request statistics for this trial ..... */
        /* ********************************************************* */
        /* ********************************************************* */
        for(ir=0; ir<number_of_requests_per_session; ir++) 
        {
            prt("\nStatistics Summary for request: %d\n",ir);
            if (0 == strcmp(requests[ir].method,"GET")) {
                prt("%2d: %s %s\n fraction:%8.3f check_sum:%u\n\n",
                    ir,
                    requests[ir].method,
                    requests[ir].url, 
                    requests[ir].fraction, 
                    requests[ir].check_sum);
            } else {
                prt("%2d: %s %s\n %s\n fraction:%8.3f check_sum:%u\n\n",
                    ir,
                    requests[ir].method, 
                    requests[ir].url, 
                    requests[ir].data, 
                    requests[ir].fraction,
                    requests[ir].check_sum);
            }

            wl_print_stats (request_stats[ir]);
        } 

        /* *********************************************************** */
        /* Now summarize and print the per mark statistics ........... */
        /* *********************************************************** */
        next_mark = 0;
        last_req = 0;
        /* intentionally overflow loop to print last request */
        for(ir=0; ir <=number_of_requests_per_session; ir++) 
        {
            if ((next_mark != requests[ir].mark)  ||
                (ir == number_of_requests_per_session)) 
            {
                int j;
                prt("\n");
                prt("*******************************************************\n");
                prt("Statistics Summary for Requests %d thru %d \n", 
                    last_req, ir-1);
                for (j=last_req; j<ir; j++) {
                    prt("%2d: %s %s\n", j, 
                    requests[j].method, requests[j].url); 
                }
                prt("*******************************************************\n");

                wl_print_stats (mark_stats[next_mark]);
                next_mark = requests[ir].mark;
                last_req = ir;
            }
        }

        prt("\n");
        prt("*******************************************************\n");
        prt("Statistics Summary for Trial: %d\n", trial);
        prt("*******************************************************\n");

        /* *********************************************************** */
        /* Now summarize and print the per trial statistics .......... */
        /* *********************************************************** */
        wl_print_stats (trial_stats);

        prt ("Trial Duration: %8.3f seconds\n", 
            MS(trial_stats.trial_duration.sum));
        prt ("Sum of think times: %8.3f seconds\n", 
            MS(trial_stats.sum_of_think_times.sum));
        prt ("\n");

        /* ************************************************************ */
        /* write out the "raw" statistics data so we can merge it       */
        /* together if we are running the throughput measurement cases  */
        /* (we probably have multiple copies of this program running in */
        /* that case) ................................................. */
        /* ************************************************************ */
        /* needs finished!!! .......................................... */
        /* ************************************************************ */
        if (global_opts.write_completion_times) {
        }
    
    } /* end of "if(trial_stats.first_data_response_time.count >= 1)" */


exit:
    PINFO("trials attempted: %d, successful trials: %d\n",
        trial, successful_trials);
    PINFO("ignored_check_sum_errors:  %d\n", ignored_check_sum_errors);
    global_opts.CloseFiles();

    if (0 < global_opts.shm_key) 
    {
        shm_info[child_number].running[0] = 'S';
        shm_info[child_number].running[1] = 'T';
        shm_info[child_number].running[2] = 'O';
        shm_info[child_number].running[3] = 'P';
    }
    printf("%s: ends.........\n",PROGNAME);
    return 0;
} /* end main() */

