/*
 * FILE:
 * webmon.c
 *
 * FUNCTION:
 * webmon: sit between a browser and a server and record what goes on 
 * between them.  Write a trace log file for later analysis.
 *
 */

/**************************************************************************
 *        Copyright (C) 1995 Silicon Graphics, Inc.                         *
 *                                                                        *
 *  These coded instructions, statements, and computer programs were      *
 *  developed by SGI for public use.  If any changes are made to this code*
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modifications and changes to the code and release it.                 *
 *                                                                        *
 **************************************************************************/

/* ========================== BEWARE ==================================== */
/* =================== HERE BE CONRAD VEIDT ============================= */
/* The code herein is a horrible, ugly hack of code that originally was
 * a part of SGI's WebStone.  It has spent a goodly portion of it's life
 * in the Laboratory of Dr. Frankenstein, who unmercifully sliced & diced
 * it the most unmentionable, despicable fashion.  In an attempt to remove
 * this code from its befouled birthing pen, management has given it to
 * me, Dr. Caligari.  My somnambulist has been doing well, as I have been
 * applying salves & ointments to heal its horrid wounds.  However, I
 * recognize my only mortal talents, and thus before your gaze rests
 * upon my Cesare,  be forewarned that your wits and faculties may 
 * be so repulsed by the sight that you may never recover status quo
 * ante bellum.  Five cents, please, and you may enter the tent.          */
/* ========================== BEWARE ==================================== */
/* More seriously folks:
 * The code that extracts web server names, URL's, paths, etc. 
 * needs to be completely redesigned & re-written.  It is constantly 
 * tripping over it's own feet, looking for slashes and dashes and colons 
 * and what not, getting it wrong half the time. It's a sick patched joke 
 * right now, and I'm getting $%^&* tired of patching it, and I'm too lazy
 * to redesign from scratch.  If you take over this code, it is strongly
 * recommended that you do this.
 *
 * Things that need doing:
 * 1) Design and implement a generic URI parsing library.  
 *    This library needs indicate: 
 *    -- was there a leading http:// or https:// in the URI? which?
 *    -- was the port number explicitly provided? what was it?
 *    -- does the URI have a trailing slash?
 *    -- does URI have a machine name in it, or was it a simple file-path?
 *    -- split URI into machine name and path parts.
 *
 * 2) Need to parse & fetch framesets
 * 
 * 3) change API's to stop using fixed-length global buffers, and use
 *    variable-length local, malloced buffers instead.
 */


/* socks redefinition must preceed system headers */
/* Actually, we DO NOT want to sockify any of the code here.
 * This is because the code here is involved only in listening
 * to connections from the browser, which will never be going 
 * through the socks server. Only outbound sockets needs socksification,
 * and those are handled entirely in socket.c */
/* #include "sockify.h" */

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <math.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

#ifdef WIN32
#include <winsock.h>
#include <windows.h>
#include <process.h>
#include <io.h>
#endif /* WIN32 */

#ifndef WIN32
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <strings.h>
#include <sys/errno.h>
#include <sys/file.h>
#include <sys/ipc.h>
#include <sys/param.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <unistd.h>
#endif /* WIN32 */

#include "checksum.h"
#include "cookie.h"
#include "errexit.h"
#include "fetchurl.h"
#include "generic.h"
#include "parse.h"
#include "shhopt.h"
#include "socket.h"
#include "stats.h"
#include "sysdep.h"
#include "timefunc.h"
#include "webopts.h"

/* global variables */

#define MAX_LINKS 5000
int number_of_links = 0;
char   *real_link_list[MAX_LINKS];
char   *fake_link_list[MAX_LINKS];

/* fqdn == fully qualified domain name */
char    local_fqdn_host_name[MAXPATHLEN];
char    local_fqdn_sock_name[MAXPATHLEN];
char    local_host_name[MAXPATHLEN];
char    local_sock_name[MAXPATHLEN];
NETPORT local_portnum    = 0;

char    base_host_name[MAXPATHLEN];
char    base_sock_name[MAXPATHLEN];
NETPORT base_portnum  = 80;
int     base_encryption = 0;

char    webserv_host_name[MAXPATHLEN];
char    webserv_sock_name[MAXPATHLEN];
NETPORT webserv_portnum = 80;
int     webserv_encryption = 0;

#ifdef WIN32
#ifndef EADDRINUSE
#define EADDRINUSE WSAEADDRINUSE
#endif
#endif /* WIN32 */

#ifdef USE_SOCKS
#ifdef __cplusplus
extern "C" {
#endif
extern void SOCKSinit (const char *);
#ifdef __cplusplus
};
#endif
#endif /* USE_SOCKS */

/* ************** */
/* End of globals */
/* ************** */

/* ================================================================== */
/* ================================================================== */
/* ================================================================== */
/* ================================================================== */


/* ****************************************************************** */
/* do the processing required when we are directed to a new host      */
/* ****************************************************************** */
void
extract_webserv_host_name(char *new_host_url) 
{
   wlURI uri;

   PDBG1("url=%s port=%hu\n", new_host_url,webserv_portnum);

   uri.uri = new_host_url;
   uri.host = new_host_url;  /* allow bare hostnames, without leading http: */
   uri.encrypt = base_encryption;
   uri.portno = webserv_portnum;
   uri.Parse ();

   webserv_encryption = uri.encrypt;
   webserv_portnum = uri.portno;

   strncpy (webserv_host_name, uri.host, uri.host_len);
   webserv_host_name [uri.host_len] = 0x0;
   sprintf(webserv_sock_name,"%s:%hu",
         webserv_host_name,webserv_portnum);

   PDBG ("found server %s with encryption=%d\n", 
      webserv_sock_name, webserv_encryption);

}

/* *********************************************************************** */
/* search an array of strings (ignoring case) and find one that matches,   */
/* or return -1                                                            */
/* *********************************************************************** */
int 
searchreals(char **list, int entries, const char *lookfor) 
{
   int index;
   int collate;

   for (index=0; index<entries; index++) 
   {
      collate = strcasecmp (list[index], lookfor);
      if (0 == collate) return(index);
   }
   return(-1);
}

int 
searchfakes (char **list, int entries, const char *lookfor) 
{
   int index;
   int collate;
   char * tail;
   size_t looklen;

   /* reject any urls that obviously haven't been encoded */
   collate = strncmp (lookfor, "/webmon_", 8);
   if (collate) return -1;

   tail = strchr (lookfor, 'X');
   while ('X' == *tail) tail ++;
   looklen = tail - lookfor;

   for (index=0; index<entries; index++) 
   {
      collate = strncmp (list[index], lookfor, looklen);
      if (0 == collate) return(index);
   }
   return(-1);
}

/* *********************************************************************** */
int 
patch_link (wlString &page, char * start, char *end)
{
   char new_link[MAXLINELENGTH];
   char print_link[MAXLINELENGTH];
   size_t i, longth = 0;
   char * tmp_link;
   int index = -1;

   longth = end-start;
   if (0 == longth) return -1;

   /* we now have the link name; start and end point to its start and end.. */
   /* does the link name start with http:// or https:// ?? ................ */

   if ((0 == strncasecmp (start,HTTP_STRING, strlen(HTTP_STRING ))) || 
       (0 == strncasecmp (start,HTTPS_STRING,strlen(HTTPS_STRING))) ) 
   {
      /* ***************************************************************** */
      /* yes, we have a cross machine link ............................... */
      /* ***************************************************************** */
      strncpy (new_link, start, longth);
      new_link [longth] = '\0';

      /* if the link ends with a slash, we want to preserve that.  If      */
      /* If we don't preserve it, then the browser will improperly         */
      /* any gif's that are embeded as relative urls (i.e. without a       */
      /* leading slash to indicate an absolute location.                   */
      if ('/' == new_link[longth-1]) {
         --longth;
         new_link [longth] = '\0';
      }

      PDBG1("found a cross machine link: %s\n", new_link);

      /* pull out the link and search to see if we have seen it before.... */
      index = searchreals(real_link_list, number_of_links, new_link);
      /* if we found the link, searchlist returned the index in the table  */
      /* if not, it returns -1 ........................................... */
      if (index == -1) {
         PDBG1 ("This is a new link we have not seen before.\n");
         /* ************************************************************* */
         /* not found.... create a new entry in the link table .......... */
         /* ************************************************************* */
         tmp_link = (char *) malloc(longth+1);
         strcpy (tmp_link, new_link);
         real_link_list[number_of_links] = tmp_link;
         /* ************************************************************* */
         /* now manufacture a name for the link in the document.          */
            /* To avoid copying the page, we make the tmp link exactly       */
            /* same length as the link we are replacing. ...... ............ */
         /* ************************************************************* */
         tmp_link = (char *) malloc(longth+1);
         /* we prefix the fake name with a / to keep it from looking      */
         /* like a relative link to the browser. ........................ */
         sprintf (tmp_link,"/webmon_%X_",number_of_links);
         for (i=strlen(tmp_link);i<longth;i++) tmp_link[i]='X';
         tmp_link [longth] = '\0';
         fake_link_list[number_of_links] = tmp_link;

         index = number_of_links;
         number_of_links++;
         if (number_of_links > MAX_LINKS) {
            PERR("Need to increase size of real to fake "
               "link mapping table\n");
            perr("\tCurrent value of MAX_LINKS=%d, Needed:%d\n",MAX_LINKS,
               number_of_links);
         }
         PDBG1("new link name is:%s\n",tmp_link);
      } 

      strncpy (print_link, start, longth);
      print_link [longth] = 0x0;
      PDBG("Translating link:\n"
         "\tFrom: %s\n"
         "\tTo:   %s\n",
          print_link, fake_link_list[index]);
      strncpy (start,fake_link_list[index], longth);
      strncpy (print_link, start, longth);
      PDBG2 ("After translation=%s\n", print_link);
   } else

   /* try to patch up JavaScript links.
    * These are harder to handle because of the richer syntax.
    */
   if (0 == strncasecmp (start, "Java", 4))
   {
      strncpy (print_link, start, longth);
      print_link [longth] = 0x0;
      PDBG("attempt translating JavaScript link: %s \n",
         print_link);
      start = strchr (start, '(');
      if (start) {
         int rc;
         start ++;
         rc = wl_extract_link (&start, &end); 
         if (rc) {
            PWARN("unable to find matching delimiters \n");
         } else {
            index = patch_link (page, start, end);
         }
      }
   } else

   /* try to patch up comma-separated lists of VALUE= parameters to 
     * java or tcl applets.  Yes, this is a hack, but what the hey ... */

   if ( strncasestr (start, "http://", longth) || 
        strncasestr (start, "https://", longth) )
   {
      char *current;
      char *restart = start;
      char *reend = end;
      
      current = restart;
      current = strncasestr (current, "http://", reend-current);
      while (current)
      {
         int rc;
         start = current;
         rc = wl_extract_link (&start, &end); 
         if (rc) {
            PWARN("unable to find matching delimiters BBBBB \n");
         } else {
            index = patch_link (page, start, end);
         }
         current = strncasestr (current, "http://", reend-current);
      }

      current = restart;
      current = strncasestr (current, "https://", reend-current);
      while (current)
      {
         int rc;
         start = current;
         rc = wl_extract_link (&start, &end); 
         if (rc) {
            PWARN("unable to find matching delimiters CCCC \n");
         } else {
            index = patch_link (page, start, end);
         }
         current = strncasestr (current, "https://", reend-current);
      }
   }


    return index;
}

/* *********************************************************************** */

void 
patch_base (wlString &page, char * start, char *end)
{
   /* make a temporary copy */
   wlString oldlink;
   oldlink.Memcpy (start, end-start);

   wlURI uri;
   uri.uri = oldlink;
   uri.Parse();

   if (uri.access) 
   {
      /* ******************************************************** */
      /* yes, we have a cross machine link ...................... */
      /* ******************************************************** */

      /* record new host name as new base name ...................*/
      /* do this *before* mangling the buffers ...................*/
      base_portnum = uri.portno;
      base_encryption = uri.encrypt;
      strncpy (base_host_name, uri.host, uri.host_len);
      base_host_name [uri.host_len] = 0x0;
      sprintf(base_sock_name,"%s:%hu",
         base_host_name, base_portnum);
      PDBG("using new URL base: %s\n", base_sock_name);

      /* insert the local machine name    ....................... */
      start = uri.access;

      wlString newlink;
      newlink = "http://";
      newlink += local_fqdn_sock_name;
      if (uri.path) {
         newlink.Memcat (uri.path, uri.path_len);
      } else {
         newlink += "/";
      }

      page.Substitute (oldlink, newlink);
   }
}

/* ------------------------------------------------------------------ */
void
spoof_passthru (wlSocket &connection, wlSSLInfo &sinfo)
{
   char resp_buf[1000];
   char * ptr;
   size_t len;
   int rc;

    /* at this point, we are not yet encrypted.   Reply to browser
     * that we have been able to make an encrypted connection to the
     * remote server.  */
   ptr = stpcpy (resp_buf, "HTTP/1.0 200 Connection Established\r\n");
   ptr = stpcpy (ptr, "Proxy-Agent: webmon/4.0\r\n\r\n");
   len = strlen (resp_buf);

   rc = connection.Write (resp_buf,len);
   if (0 >= rc) {
      PERR("NETWRITE returned %d\n", rc);
      return;
   }

   /* OK, and now convert the socket over to encryption. */

   sinfo.be_server = 1;
   sinfo.use_ssl = 1;
   rc = connection.StartSSL (sinfo);
   if (0 >= rc) {
      PERR("couldn't go over to SSL %d\n", rc);
      return;
   }

   PDBG("done\n");
}

/* ------------------------------------------------------------------ */

typedef void (*cb_t)(wlString &, char*, char*);

#define PROGNAME global_opts.progname

int
main(int argc, char *argv[])
{
   int     rc,get_rc;
   SOCKET  s;
   SOCKET  connection;
   struct  sockaddr_in s_addr_inet;
   struct  protoent *prot;
   wlRequest orig_request, saved_request;
   char   *current;
   int     sleep_time = -1;
   size_t  len;
   int     have_been_redirected = 0;
   int     have_written_start = 0;
   int     have_written_end = 0;

   time_struct first_data_response;
   time_struct response_time;
   time_struct transfer;
   time_struct headerdelay;
   time_struct connecttime;
   time_struct HeaderOvhd, TransferOvhd;

   double dbl_connecttime, dbl_headerdelay, dbl_transfer, dbl_first_data_response;
   double dbl_SSLNetDelayConnect, dbl_NetDelayHeader, dbl_NetDelayTransfer;
   double dbl_SSLConnectOvhd, dbl_HeaderOvhd, dbl_TransferOvhd;
   double dbl_response_time, dbl_NetDelay, dbl_SSLOvhd;
   int index;
   int retry=0;
   int checksum;

   setbuf(stdout,NULL);

   /* 
    * Parse the command line options
     */
   wlOpts global_opts;
   global_opts.ParseArgs (&argc, argv);
   quiet_stdout = global_opts.quiet_stdout;
   debug = global_opts.debug;
   tdebug = global_opts.tdebug;
   rc = global_opts.ProcessOpts ();
   if (rc) exit (rc);
   report_file = global_opts.report_file;
   global_opts.PrintOptionsSummary ();

    /* set up the old-fashioned globals, for now ... */
#if (defined (USE_SKIT) || defined (USE_SSLEAY))
   webserv_encryption = global_opts.client_ssl_opts.use_ssl;
   base_encryption    = global_opts.client_ssl_opts.use_ssl;
#endif /* USE_SKIT || USE_SSLEAY */

   local_portnum = global_opts.local_portnum;
   webserv_portnum = global_opts.web_portnum;
   int use_proxyserver = (NULL != (char *)global_opts.proxyserver);

   extract_webserv_host_name (global_opts.webserver);
   strcpy (base_host_name, webserv_host_name);
   strcpy (base_sock_name, webserv_sock_name);
   base_portnum = webserv_portnum;
   base_encryption = webserv_encryption;

   /* ******************************************************** */
   /* get the local host name ................................ */
   /* ******************************************************** */
   rc = gethostname(local_fqdn_host_name, MAXPATHLEN);
   if (0 > rc) {
      int norr = errno;
      PWARN("unable to obtain the local hostname\n"
            "\terrno=%d (%s)\n"
            "\tdefaulting to 127.0.0.1 \n",
            norr, strerror(norr));

      /* of course, we could try gethostid() before using localhost,
         * but of course, gethostname only fails on win95, and win95 
         * doesn't support gethostid() or uname() or unamex(), so 
         * its pointless to get fancy here.
       */
      strcpy (local_fqdn_host_name, "127.0.0.1");
      strcpy (local_host_name, "127.0.0.1");
   } else {
      strcpy (local_host_name, local_fqdn_host_name);
      char * start = strchr (local_host_name, '.');
      if (start) *start = 0x0;
   }

    if (0 == local_host_name[0]) {
      PWARN("invalid, blank/empty local hostname\n"
            "\tdefaulting to 127.0.0.1 \n");

      /* of course, we could try gethostid() before using localhost,
         * but of course, gethostname only fails on win95, and win95 
         * doesn't support gethostid() or uname() or unamex(), so 
         * its pointless to get fancy here.
       */
      strcpy (local_fqdn_host_name, "127.0.0.1");
      strcpy (local_host_name, "127.0.0.1");
   }

   sprintf(local_fqdn_sock_name,"%s:%hu",local_fqdn_host_name, local_portnum);
   sprintf(local_sock_name,"%s:%hu",local_host_name, local_portnum);

   /* ******************************************************************** */
   /* print summary of command line options and stuff. ................... */
   /* ******************************************************************** */
#ifdef USE_SOCKS
    SOCKSinit(PROGNAME);
#endif /* USE_SOCKS */

   /* print header in report file so perl script can skip over stuff   */
   /* that print_options_summary just put into the report file....... */
   prt ("===============DATA==============\n");
   prt ("\nAll times below are in seconds, rounded to the nearest millisecond.\n\n");

   /* initialize the error message array. ...............................*/
    init_webload_errors();

#if (defined (USE_SKIT) || defined (USE_SSLEAY))
   global_opts.client_ssl_opts.Init(0);
   global_opts.server_ssl_opts.Init(1);
#endif /* USE_SKIT USE_SSLEAY */
   
   /* ******************************************************** */
   /* create a socket, bind it to the correct adress & port... */
   /* ******************************************************** */
   prot = getprotobyname("tcp");
   if (0 == prot) {
      int norr = errno;
      PFATAL("can't get protocol number for tcpip\n"
         "\terrno=%d (%s)\n", norr, strerror(norr));
      exit(1);
   }
   s = socket(AF_INET, SOCK_STREAM, prot->p_proto);
   if (BADSOCKET (s)) {
      int norr = errno;
      PFATAL("can't create listener socket\n"
         "\terrno=%d (%s)\n", norr, strerror(norr));
      exit (1);
   }
   /* ******************************************************** */
   /* kludge around pesky "address already in use error" ..... */
   /* ******************************************************** */
   retry = 0;
   do  {
      memset((char *)&s_addr_inet, 0, sizeof(s_addr_inet));
      s_addr_inet.sin_family = AF_INET;
      s_addr_inet.sin_port = htons(local_portnum);
      rc = bind(s, (struct sockaddr *) &s_addr_inet, sizeof(s_addr_inet));
      if (rc < 0) {
         int norr = errno;
         PWARN("error binding socket port=%hu\n",
            local_portnum);
         perr ("\terrno=%d (%s) \n", norr, strerror(norr));
         if (errno == EADDRINUSE) {
            /* try again with next higher port number. ....  */
            local_portnum++;
            retry++;
         } else {
            /* give up on other errors. .................... */
            PFATAL("can't bind listen socket\n");
            exit (1);
         }
      }
   } while ((rc < 0) && (retry < 10));
   if (rc < 0) {
      PFATAL("couldn't find a port number "
            "to bind to after 10 tries!!\n");
      exit (1);
   }
   sprintf(local_fqdn_sock_name,"%s:%hu",local_fqdn_host_name, local_portnum);
   sprintf(local_sock_name,"%s:%hu",local_host_name, local_portnum);

   /* ********************************************************* */
   /* listen for connections .................................. */
   /* ********************************************************* */
   PINFO("listening for connections at %s:%hu\n",
         local_host_name,local_portnum);
   rc = listen(s,SOMAXCONN);
   if (0 > rc) {
      int norr = errno;
      PFATAL("error listening on port %hu\n", local_portnum);
      perr ("\terrno=%d (%s)\n", norr, strerror(norr));
      exit (1);
   }

   /* ******************************************************** */
   /* ******************************************************** */
   /* Main loop of the program ............................... */
   /* ******************************************************** */
   /* ******************************************************** */
   while(! have_been_interrupted) 
   {
      struct  sockaddr_in connect_addr;
      size_t  connect_addr_length;
      wlFetchURL browser;
      wlRequest request;
      int spoof;

      /* **************************************************** */
      /* wait for a new connection. ......................... */
      /* **************************************************** */
      retry=0;
try_again:
      connect_addr_length = sizeof(connect_addr);
      PINFO("waiting for a connection......\n");
      connection = accept(s,(struct sockaddr *) &connect_addr,
            &connect_addr_length);
      if (have_been_interrupted) goto exit;
      if (BADSOCKET (connection)) {
         int norr = errno;
         PFATAL("accept error listening to socket\n");
         perr ("\terrno was %d %s \n", norr, strerror(norr));
         exit (1);
      }

      /* we're just being paranoid here. .................... */
      if (connect_addr_length > sizeof(connect_addr)) {
         PFATAL("connect_addr len=%d returned is "
            " > sizeof(connect_addr)=%d\n",
            connect_addr_length, sizeof(connect_addr));
         exit (1);
      }

      PDBG("accepted connection on sockfd=%d\n", connection);

      browser.sock.sock_fd = connection;

      /* act like an SSL server to the client 
       * (but only if not acting as a proxy... ) */
      if (global_opts.server_ssl_opts.use_ssl &&
         !global_opts.act_as_proxy) 
      {
         browser.sock.StartSSL (global_opts.server_ssl_opts);
      }

      /* go through this code only once, unless we've been
       * asked to pass-through */
      spoof = 1;
      while (spoof) {
         spoof = 0;
         rc = browser.ReadMessage (request, HTTP_ANY_SIZE_MSG);
         if (have_been_interrupted) {
            PFATAL("quitting, have been interrupted\n");
            goto exit;
         }
         if (0>rc) {
            browser.sock.Close();
            retry = 0;
            goto try_again;
         }

         request.Analyze();
   
         /* ************************************************************ */
         /* put the request, as received from the browser into the trace */
         /* file if trace is on......................................... */
         /* ************************************************************ */
         if (global_opts.trace_client) {
            fprintf (global_opts.trace_file, BRWS_REQ_START);
            fwrite (request.message, request.message.Memlen(),
               1, global_opts.trace_file);
            fflush (global_opts.trace_file);
         }
   
         /* spoof (man-in-the-middle attack) */
         if ((0 == strcmp (request.method, "CONNECT"))) {
               if (!global_opts.act_as_proxy) 
            {
               PERR ("Recieved unexpected CONNECT directive from browser\n"
                     "\tPerhaps you forgot to specify the -a flag?\n");
            }
            spoof_passthru (browser.sock, global_opts.server_ssl_opts);
            spoof = 1;


            /* record the hostname from the CONNECT request; we'll need
             * it later when assembling/forwarding requests */
            wlURI uri;

            uri.uri = request.url;
            uri.host = request.url;
            uri.encrypt = base_encryption;
            uri.portno = webserv_portnum;
            uri.Parse();
         
            webserv_portnum = uri.portno;
            webserv_encryption = 1;
         
            strncpy (webserv_host_name, uri.host, uri.host_len);
            webserv_host_name [uri.host_len] = 0x0;
            sprintf(webserv_sock_name,"%s:%hu",
                  webserv_host_name,webserv_portnum);
         }
      }

      /* ************************************************************ */
      /* now that we got all of the data, hand it along to the        */
      /* webserver and get the response                               */
      /* ************************************************************ */

      if (global_opts.do_host_translation) 
      {
         /* ************************************************************ */
         /* first we have to massage the request some in order to keep   */
         /* up the masquerade -- that is to keep the server from finding */
         /* out that we are not actually the browser.................... */
         /* ************************************************************ */
   
         /* first, change any refs to "us" to references to the real host.*/
         request.message.Substitute (local_sock_name,base_sock_name);
         request.message.Substitute (local_fqdn_sock_name,base_sock_name);
         request.Analyze();

         /* all fetches will be relative to the base, 
          * unless over-ridden below */
         strcpy (webserv_host_name, base_host_name);
         strcpy (webserv_sock_name, base_sock_name);
         webserv_portnum = base_portnum;
         webserv_encryption = base_encryption;

         /* is the URL requested by the browser one of our "fake" urls   */
         /* indicating a cross machine link of some kind? ...............*/
         index = searchfakes(fake_link_list, number_of_links, request.url);
         if (index >= 0) {
            /* yes it is....  substitute it back to what it should be. .*/
            PDBG("Fake link will be transated :\n"
               "\tFrom: %s\n"
               "\tTo:   %s\n",
               (char *)request.url, real_link_list[index]);
            char * start = strstr(request.message, request.url);
   
            /* we know the lengths of the fake and real URL's match. .. */
            PDBG2 ("Fake request: %s\n", (char *)request.url);
            strncpy(start,real_link_list[index],strlen(real_link_list[index]));
            PDBG2 ("Fake request after fake->real translation: %s\n",
               start);
            request.url = real_link_list[index];
   
            /* print the request so the user can see what happened. ... */
            if (debug) {
               char * end = strpbrk(request.message,"\r\n");
               if (end != NULL) {
                  char tmp [120];
                  len = end - (char *)request.message;
                  if (len>60) {
                     len=60;
                     strncpy(tmp,request.message,len);
                     tmp[len] = '\0';
                     strcat(tmp,"<<truncated>>");
                  } else {
                     strncpy(tmp,request.message,len);
                     tmp[len] = '\0';
                  }
                  PINFO("request translated to: %s\n",tmp);
               }
            }
   
            /* **************************************************** */
            /* now we have to "point" ourselves to the new host ... */
            /* **************************************************** */
            /* extract_webserv_host_name will find the embedded     */
            /* real host name ..................................... */
            extract_webserv_host_name(real_link_list[index]);

            /* **************************************************** */
            /* now we have the http://hostname stuff in the request */
            /* header. But unless one is using a proxy one doesn't  */
            /* actually send the http://etc stuff to the host.      */
            /* If by accident we do, we will almost certainly get   */
            /* a 404 (not found) error.  so we must strip that out  */
            /* of the request. ...................................  */
            /* Note: SSL-proxy requires it to be stripped as well   */
            /* **************************************************** */
            if ((!use_proxyserver) || webserv_encryption) 
            {
               char *start = strcasestr (request.url,"http");
               if (!start) {
                  PFATAL("Can't find http in request\n"
                         "\turl=%s\n"
                         "\trequest=%s\n",
                      (char *)request.url, (char *)request.message);
                  exit (1);
               }
               char *tmp1 = strstr(start,"://");
               tmp1 += strlen("://");
               char *end  = strstr(tmp1,"/");
               if (!end) {
                       /* hack around GET http://some.com HTTP/1.0 */
                       /* which should parse to GET / HTTP/1.0  */
                  end = request.url + request.url.Memlen();
                  *end = '/';   
               }
               end = strdup (end);
               request.url = end;
               free (end);
               PDBG2 ("request after trim: %s\n",
                  (char *)request.url);

               // put the url back into the request
            }
            request.bug_compat = global_opts.bug_compat; 
            request.Assemble();
         }
      }
      {
         /* generate some output to stdout to let user
          * know that things are working */
         char tmpbuf[120];
         char * eol;
         strncpy (tmpbuf, request.message, 119);
         tmpbuf[114]= '.';
         tmpbuf[115]= '.';
         tmpbuf[116]= '.';
         tmpbuf[117]= '.';
         tmpbuf[118]= '.';
         tmpbuf[119]= 0x0;
         eol = strpbrk (tmpbuf, "\n\r");
         if (eol) *eol = 0x0;
         prt("\n");
         PINFO("Request: %s\n", tmpbuf);
      }

      /* substitute the user agent name */
      if (global_opts.user_agent_name.Memlen()) 
      {
         request.header.ReplaceOrAddField ("User-Agent", 
             global_opts.user_agent_name);
         request.bug_compat = global_opts.bug_compat; 
         request.Assemble();
      }

      // save the original request before the code below mangles it
      orig_request = request;

      if (use_proxyserver && (!webserv_encryption)) 
      {
         char *curl = request.url;
         if ('/' == *curl) {
            wlString furl;
            furl = "http://";
            furl += webserv_sock_name;
            furl += curl;
            request.url = furl;
            request.bug_compat = global_opts.bug_compat; 
            request.Assemble();
         } 
      } else

      if (global_opts.act_as_proxy)
      {
          // Allow complex urls, such as 
          // GET https://some.where.com/some/url.html
          // to work correctly; do this by stripping out the host
         char *url = request.url;

         /* check for proxy-style syntax */
         if ((0 == strncasecmp (url, "http://",  7)) ||
             (0 == strncasecmp (url, "https://", 8)) )
         {
            wlURI uri;

            /* parse the URL */
            uri.uri = url;
            uri.host = NULL;
            uri.encrypt = base_encryption;
            uri.portno = webserv_portnum;
            uri.Parse();
         
            webserv_encryption = uri.encrypt;
            webserv_portnum = uri.portno;
         
            strncpy (webserv_host_name, uri.host, uri.host_len);
            webserv_host_name [uri.host_len] = 0x0;
            sprintf(webserv_sock_name,"%s:%hu",
                  webserv_host_name,webserv_portnum);


            /* strip out the host name from the request */
            if (uri.path) 
            {
               /* make tmp copy since new clobbers old memory */
               char * tmp = strdup (uri.path);  
               request.url = tmp;
               free (tmp);
            } 
            else
            {
               request.url = "/";
            }
            
            request.bug_compat = global_opts.bug_compat; 
            request.Assemble();
            PDBG("Request after removing host: %s\n",
               (char *)request.message);
         }
      }

      /* ************************************************************ */
      /* ok, now that we are done with all of that, send the request  */
      /* along to the server......................................... */
      /* ************************************************************ */
      /* get the current time for the report file. .................. */
      char *when = timeofday();
      char *end = strchr (when , '\n');
      *end = '\0';

      PINFO("will connect to %s on port=%d, encryption=%d\n",
         webserv_host_name, webserv_portnum, webserv_encryption);
      wlFetchURL fetch;
      fetch.ResetNetTimes();
      fetch.request.method = "WEBLOAD_RAW_DATA";
      fetch.request.message = request.message;
      fetch.www_server = webserv_host_name;
      fetch.www_port = webserv_portnum;
      fetch.proxy_server = global_opts.proxyserver;
      fetch.proxy_port = global_opts.proxy_portnum;
      fetch.keep_alive = 0;
      fetch.use_ssl = webserv_encryption;
      fetch.opts = &global_opts; 

      get_rc = fetch.GoFetch();
      PDBG("returned HTTP status code=%d reply length=%d\n", 
          get_rc, fetch.reply.message.Memlen());
      if (0 > get_rc) 
      {
         PERR("%d %s\n", get_rc, webload_error(get_rc));
         if ((GET_CONNECT_ERROR == get_rc) ||
             (GET_EOF_ERROR == get_rc))
         {
               perr ("\tcontinuing anyway\n");
         } else
         goto exit;
      } 
      else
      if ((HTTP_OK         != get_rc) && 
          (HTTP_MOVED_PERM != get_rc) && 
          (HTTP_MOVED_TEMP != get_rc) &&
          (HTTP_USE_LOCAL  != get_rc) &&
          (HTTP_AUTH_REQ   != get_rc))
      {
         char tmpbuf[300];
         strncpy (tmpbuf, fetch.reply.message, 299);
         tmpbuf[299] = 0x0;
            PERR ("unexpected HTTP status code %d \n", get_rc);
            perr ("\tfirst 300 bytes were: \n%s\n", tmpbuf);
            perr ("\tcontinuing anyway\n");
        } 
      else
      {
         fetch.reply.Split();
         PINFO("recv'd %d bytes (%d body bytes) %s\n",
            fetch.reply.message.Memlen(), 
            fetch.reply.body.Memlen(), 
            (char *)fetch.reply.startline);
      }

      /* ************************************************************ */
      /* calculate and print statistics, if we have somewhere to      */
      /* write them to. ............................................. */
      /* ************************************************************ */
      if (global_opts.report_file) {

         /* connect time is the time required to complete the connect.. */
         wl_difftime(&fetch.afterconnect, &fetch.beforeconnect, &connecttime);
         time_struct ovhd1;
         wl_difftime(&fetch.beforesend, &fetch.afterconnect, &ovhd1);

         /* headerdelay is the time from send to header arrival ....... */
         wl_difftime(&fetch.afterheader, &fetch.beforesend, &headerdelay);

         /* body transfer time is time from header to end of message... */
         wl_difftime(&fetch.afterbody, &fetch.afterheader, &transfer);

         /* first_data_response time is time from connect to first data */
         /* message after the header is received. ..................... */
         wl_difftime(&fetch.firstdata,&fetch.beforeconnect, &first_data_response);
         /* minus the time between afterconnect and beforesend (which is*/
         /* overhead. ................................................. */
         wl_difftime(&first_data_response,&ovhd1,&first_data_response);

         /* response time is the time from connect until body complete..*/
         wl_difftime(&fetch.afterbody,&fetch.beforeconnect,&response_time);
         /* minus the overhead. ........................................*/
         wl_difftime(&response_time,&ovhd1,&response_time);

         DT_PP("connecttime  :",connecttime);
         DT_PP("headerdelay  :",headerdelay);
         DT_PP("transfer     :",transfer);
         DT_PP("firstdatarsp: ",first_data_response);
         DT_PP("overhead     :",ovhd1);

         /* print the raw stats, to millisecond resolution, to stdout. . */
         dbl_connecttime = timevaldouble(&connecttime);
         dbl_headerdelay = timevaldouble(&headerdelay);
         dbl_transfer    = timevaldouble(&transfer);
         dbl_first_data_response = timevaldouble(&first_data_response);
         dbl_response_time = timevaldouble(&response_time);

          /* print the descriptive information to the report file. ...... */
         request.Analyze();
         prt("\n%srequest: %s %s\n", when, (char *)request.method, (char *)request.url);
         prt("data: %s\n", (char *)request.body);

         /* print the raw statistics, to millisecond resolution  */
         prt("response time  :%8.3f first data response time :%8.3f\n",
            MS(dbl_response_time), MS(dbl_first_data_response));
         prt("connect time   :%8.3f header delay             :%8.3f\n",
            MS(dbl_connecttime), MS(dbl_headerdelay));
         prt("bytes transfrd :%8d transfer time            :%8.3f\n",
            fetch.reply.message.Memlen(), MS(dbl_transfer));

            
          /* if we are using SSL, we print those statistics as well. .... */
          if (webserv_encryption) {
             wl_difftime(&headerdelay,&fetch.NetDelayHeader,  &HeaderOvhd);
             wl_difftime(&transfer,   &fetch.NetDelayTransfer,&TransferOvhd);
             dbl_SSLNetDelayConnect   = timevaldouble(&fetch.SSLNetDelayConnect);
             dbl_NetDelayHeader       = timevaldouble(&fetch.NetDelayHeader);
             dbl_NetDelayTransfer     = timevaldouble(&fetch.NetDelayTransfer);
             dbl_SSLConnectOvhd       = timevaldouble(&fetch.SSLConnectOvhd);
             dbl_HeaderOvhd           = timevaldouble(&HeaderOvhd);
             dbl_TransferOvhd         = timevaldouble(&TransferOvhd);
             dbl_NetDelay = dbl_SSLNetDelayConnect+dbl_NetDelayHeader+dbl_NetDelayTransfer;
             dbl_SSLOvhd  = dbl_SSLConnectOvhd+dbl_HeaderOvhd+dbl_TransferOvhd;
             prt("SSL Overhead   :%8.3f (SSL) Network Delay      :%8.3f\n",
                MS(dbl_SSLOvhd), MS(dbl_NetDelay)); 
             prt("SSLConnectOvhd :%8.3f (SSL) Network Dly Connect:%8.3f\n",
                MS(dbl_SSLConnectOvhd), MS(dbl_SSLNetDelayConnect)); 
             prt("HeaderOvhd     :%8.3f (SSL) Network Dly Header :%8.3f\n",
                MS(dbl_HeaderOvhd), MS(dbl_NetDelayHeader)); 
             prt("TransfrOvhd    :%8.3f (SSL) Network Dly Transfr:%8.3f\n",
                MS(dbl_TransferOvhd), MS(dbl_NetDelayTransfer)); 
          }
          fflush(global_opts.report_file);
#ifdef STATS_PSUEDO_CODE
#error CODE INCOMPLETE
          /* since we are sitting in between the browser and the server, we never know      */
          /* when a web page request is "finished".......  all we can tell is when a new    */
          /* real page is being fetched.... so here is what we do:  we watch the page names */
          /* that come by.  Every image file is assumed to be part of the "total" response  */
          /* time for the last real page that came through.  Every html page is assumed to  */
          /* mean a new page is being fetched (well, redirects complicate this a bit, but   */
          /* we do know when we are processing a redirect, so that means we can deal with   */
          /* them ok....................................................................... */
          if (have_seen_previous_html_page) {
            if (this_page_is_html && not_redirected) {
               /* this page starts a new request. ....................................... */
                /* print out statistics about the previous page........................... */
               /* then reset the cumulative statistics, record the starting time for this */
               /* request, and wait for the next request to come along. ................. */
               have_seen_gif_file = 0;
            } else {
               /* current file is either an image or a redirect.  add times into running  */
               /* sum. .................................................................. */
               if (gif_file && ! have_seen_gif_file) {
                  /* this is the first gif file we have seen this page.................. */
               }
            }
          } else {
            /* we have not yet seen an html page (start up case) ......................... */
            if (this_page_is_html) {
               have_seen_previous_html_page = 1;
               /* record the first connect time for this page. .......................... */
            }
          }
#endif /* STATS_PSEUDO_CODE */
      }

      /* ************************************************************* */
      /* write the request file entry for this request and response 
         * pair, if appropriate.... */
      /* ************************************************************* */
      /* if we have been redirected, then the first request and the 
       * final response (after all redirects have been issued need 
       * to be paired up so that the checksum value for the final 
       * response can be put into the request file with the initial
       * request.  (ugh)...  we handle this here using the 
       * get_rc and the have_been_redirected flag  */
      if ((HTTP_MOVED_PERM == get_rc) ||
          (HTTP_MOVED_TEMP == get_rc))
      {
         if (!have_been_redirected) {
            /* this must have been the first redirect we encountered 
             * so the request info is "current".  save the request 
             * information away for use when we get the final response 
             * page ...................................................*/
            saved_request = orig_request;
            /* set flag to indicate we have been redirected ...........*/
            have_been_redirected = 1;
         }
         /* otherwise we have been redirected more than once so the 
          * originally saved info is still correct and we just need to 
          * keep waiting until we get a real page back from the server. */
      }
      if (have_been_redirected && 
         (HTTP_MOVED_PERM != get_rc) &&
         (HTTP_MOVED_TEMP != get_rc))
      {
         /* we have encountered a page that is not a redirect and we 
          * have been redirected up to this point ......................*/
         have_been_redirected = 0;
         /* restore the saved request information ......................*/
         request = saved_request;
      }

      /* after all of this preparation, we now decide if we should 
         * write a request file entry for this file.  We will write 
         * an entry provided that (1) the user has requested it and 
         * (2) we are not in the process of following a redirect and
         * (3) the file is not an image file. 
         * And ... to every rule, there is an exception.
       * if the user hit "reload" w/ thier browser, the server
       * might return "304 Not Modified" which lacks a content-type ...
       * and so we don't know what the right thing to do is ...
         */
  
      char * content_type = fetch.reply.header.GetValue ("Content-Type");
      if ((HTTP_MOVED_PERM != get_rc) &&
         (HTTP_MOVED_TEMP != get_rc) &&
         (HTTP_USE_LOCAL != get_rc) &&
          content_type &&
         (0 != strncasecmp(content_type, "image", 5)) &&
         (0 != strncasecmp(content_type, "audio", 5)) &&
         (0 != strncasecmp(content_type, "video", 5)) )
      {

         /* record new host name as new base name ...........*/
         strcpy (base_host_name, webserv_host_name);
         strcpy (base_sock_name, webserv_sock_name);
         base_portnum = webserv_portnum;
         base_encryption = webserv_encryption;
         PINFO ("Will use default base: %s encryption=%d\n", 
            base_sock_name, webserv_encryption);

      if (global_opts.url_out_file)
      {
         check_sum_info_t cs_detail;
         request.Analyze();

         /* ********************************************************* */
         /* ok, we will write a request file entry for this request. .*/
         /* ********************************************************* */

         /* we now need to calculate the checksum information.  */
         checksum = calc_simple_check_sum (fetch.reply.message, cs_detail);

         /* now we need to do the substitution for the handle 
             * hack in the request itself... */
         char * start = strcasestr(request.url, "HANDLE=");
         if (start) 
         {
            wlString gurl;
            /* copy everything up to the andle= from url to saved url. .*/
            start += strlen("ANDLE=");
            gurl.Memcpy (request.url, start-((char *)request.url));
            /* append the <<HANDLE>> string to the saved_url ........ */
            gurl += "<<HANDLE>>";
            /* The handle value is either a string of digits or an 
                 * H followed by a string of digits.  Or it is something 
                 * else.  In either of the first 2 cases, we will replace 
                 * the handle value by <<HANDLE>> ....................... */
            /* skip over the digits in the existing handle value. ... */
            start++;
            /* if the handle starts with H, skip over the H as well */
            if ('H' == *start) start++;
            /* if we do not find a digit at this point, 
                 * skip the handle substitution...... */
            if (isdigit(*start)) {
               /* complete the <<HANDLE>> substitution. ............. */
               /* skip over the digits portion of the handle value. . */
               while (isdigit(*start)) start++;
               /* move the rest of the url into saved_url ........... */
               if (start[0]) gurl += start;
               /* print some debugging info ......................... */
               PDBG("\turl before handle hack=%s\n"
                    "\turl after  handle hack=%s\n", 
                   (char *)request.url, (char *)gurl);
               /* move the modified url back in place of the original */
               request.url = gurl;
               request.bug_compat = global_opts.bug_compat; 
               request.Assemble();
            }
         }

         /* try to put a <<START>> entry in the request file at an
          * appropriate place....... */
         if (!have_written_start) {
            have_written_end = 0;
            have_written_start = 1;
            fprintf(global_opts.url_out_file,"<<START>>\n");
         }

         /* we now have all the information we need to write the 
          * request file entry.  We set the fraction to 1.00 
          * (since we don't know any better value to set it to) */
         fprintf (global_opts.url_out_file, "# --- %d \n", have_written_start++);
         fprintf (global_opts.url_out_file, "<<REQUEST>> %s %s\n", 
            (char *)request.method, (char *)request.url);

         /* certain header elements are important to repeat.
             * these include "authorization" for password-protected sites, 
             * and non-standard content-types
          */
         char * authorization = request.header.GetValue ("Authorization");
         if (authorization) 
         {
            fprintf (global_opts.url_out_file,"Authorization: %s\r\n", authorization);
            authorization = 0x0;
         }
         char * wwwauth = request.header.GetValue ("WWW-Authenticate");
         if (wwwauth) 
         {
            fprintf (global_opts.url_out_file,"WWW-Authenticate: %s\r\n", wwwauth);
            authorization = 0x0;
         }
         char * conttype = request.header.GetValue ("Content-Type");
         if (conttype) {
            if (!strcasestr(conttype, "application/x-www-form-urlencoded")) {
               fprintf (global_opts.url_out_file,
                  "Content-Type: %s", conttype);
            }
         }

         if (!strcmp(request.method,"POST")) 
         { 
            fprintf (global_opts.url_out_file,
               "<<BODY>>\n%s<</BODY>>\n", (char *)request.body);
         }
         fprintf(global_opts.url_out_file,"<<COUNT>> 1.00\n");
         fprintf(global_opts.url_out_file,"<<CKSUM>> %u %d %d %d %d\n",
               checksum, cs_detail.sum, 
               cs_detail.size, cs_detail.line,
               cs_detail.length);


         fflush(global_opts.url_out_file);

         /* try to put a <<END>> entry in the request file at 
          * an appropriate place. ....... */
         if ((strstr(request.url,"proclogoff") != NULL) && !have_written_end) {
            have_written_end = 1;
            have_written_start = 0;
            /* output place holders for the count and mean think time */
            fprintf(global_opts.url_out_file,"<<END>> COUNT MEAN_THINK_TIME\n");
            fflush(global_opts.url_out_file);
            /* this seems like as good as place as any to do this. .. */
            if (global_opts.report_file) fflush(global_opts.report_file);
         }

         /* put the check sum info out into the trace file, if present */
         if (global_opts.trace_server) {
            fprintf (global_opts.trace_file,CHECK_SUM_HEADER);
            fprintf (global_opts.trace_file, 
                  "check_sum_info: sum=%d size=%d line=%d length=%d\n",
                  cs_detail.sum, 
                  cs_detail.size, 
                  cs_detail.line,
                  cs_detail.length);
            fprintf (global_opts.trace_file, CHECK_SUM_TRAILER);
            fflush (global_opts.trace_file);
         }

      }
      }


      /* *************************************************************** */
      /* now return the data to the requester........................... */
      /* *************************************************************** */

      if (global_opts.do_host_translation) {
         /* ****************************************************************/
         /* once again, we have to manipulate the response some to make    */
         /* sure that the browser keeps sending requests to "us" and       */
         /* doesn't find out where the server really is and send a request */
         /* directly over to the server. ..................................*/
         /* ****************************************************************/
   
         /* ****************************************************************/
         /* if we are getting redirected with a new host name, change the  */
         /* location so that it still points back to us, then redirect     */
         /* where we will send the next request to the new location .......*/
         /* ****************************************************************/
         if ((HTTP_MOVED_PERM == get_rc) ||
             (HTTP_MOVED_TEMP == get_rc))
         {
            PDBG("processing a redirect response\n");
            char * start = fetch.reply.header.GetValue ("Location");

            if (start) {
               int plain = 0;
               int encr = 0;

               /* if there is a host name in the redirection    */
               /* location, get it out into base_host_name. ....*/
               plain = (0 == strncasecmp (start, "http://", 7));
               encr  = (0 == strncasecmp (start, "https://", 8));

               if (plain || encr)
               {
                  extract_webserv_host_name (start);
                  strcpy (base_host_name, webserv_host_name);
                  strcpy (base_sock_name, webserv_sock_name);
                  base_portnum = webserv_portnum;
                  base_encryption = webserv_encryption;
      
                  PDBG("New base sock_name: %s \n", base_sock_name);
               }
   
               /* OK, now substitute https for https's as needed */
               if (plain) {
                  /* if we have an encrypted connection to browser, but
                   *  a plain connection to the server, then change
                   * http:// to https://  everywhere
                   */
                  if (global_opts.server_ssl_opts.use_ssl) {
                     fetch.reply.message.Substitute (HTTP_STRING, 
                                                   HTTPS_STRING);
                  }
               } else {
                  /* if we do *not* have an encrypted connection to 
                   * browser, then change https:// to http:// otherwise
                   * leave alone. */
                  if (encr  && 
                     (0 == global_opts.server_ssl_opts.use_ssl)) {
                     fetch.reply.message.Substitute (HTTPS_STRING, 
                                                   HTTP_STRING);
                  }
               }
   
               /* now substitute our_host_name for real_host_name    */
               /* in the message. .... ............................. */
               fetch.reply.message.Substitute (base_sock_name,
                                             local_fqdn_sock_name);
               fetch.reply.message.Substitute (base_host_name,
                                             local_fqdn_sock_name);
               // since we changed things, fix up the header
               fetch.reply.AnalyzeHeader();
               PDBG1("results of change:\n%s<<END>>\n", 
                  (char *)fetch.reply.message);
            }

         } else {
            /* ****************************************************** */
            /* this is not a redirect response. ..................... */
            /* ****************************************************** */

            /* ****************************************************** */
            /* If there are any links to another machine, we translate*/
            /* those to a new temp name so that if the user asks for  */
            /* one of those, we can point ourselves at the new host   */
            /* ****************************************************** */

            /* Is this an html file we are looking at?............... */
            char * contype = fetch.reply.header.GetValue ("Content-Type");
            if (0 == strncasecmp(contype, "text/html", 9))
            {
               wlString &scan = fetch.reply.body;
               char *str = (char *) fetch.reply.body;
               size_t len = fetch.reply.body.Memlen();
               /* ************************************************** */
               /* yes: text/html ................................... */
               /* ************************************************** */
               /* ************************************************** */
               /* case 0: search for <BASE HREF= and check to see if */
               /* cross machine link. Do this before scanning for    */
               /* general HREF ..................................... */
               /* ************************************************** */
               wl_scan_for_links (scan, str, len, "base", "href", "=", patch_base);


               /* ************************************************** */
               /* case 1: search for HREF= and check to see if cross */
               /* machine link...................................... */
               /* ************************************************** */
               str = (char *) fetch.reply.body;
               len = fetch.reply.body.Memlen();
               wl_scan_for_links (scan, str, len, "href", "=", NULL, (cb_t) patch_link);


               /* ************************************************** */
               /* case 2: search for SRC= and check to see if cross  */
               /* machine link...................................... */
               /*         Note that can be IMG SRC= or FRAME SRC= or */
               /*         yet other SRC things                       */
               /*         See case 7 for LAYER SRC though ...        */
               /* ************************************************** */
               str = (char *) fetch.reply.body;
               len = fetch.reply.body.Memlen();
               wl_scan_for_links (scan, str, len, "src", "=", NULL, (cb_t) patch_link);


               /* ************************************************** */
               /* case 3: search for <form action="http://foo.com">  */
               /* ************************************************** */
               str = (char *) fetch.reply.body;
               len = fetch.reply.body.Memlen();
               wl_scan_for_links (scan, str, len, "action", "=", NULL, (cb_t) patch_link);


               /* ************************************************** */
               /* case 4: search for JavaScript window open          */
               /* ************************************************** */
               str = (char *) fetch.reply.body;
               len = fetch.reply.body.Memlen();
               wl_scan_for_links (scan, str, len, "window.open", "(", NULL, (cb_t) patch_link);


               /* ************************************************** */
               /* case 4a: search for JavaScript generic             */
               /* ************************************************** */
               /* hack alert -- we don't do it here, but maybe we 
                * should ... search for javascript start and end tags,
                * and then convert *everything* that has http:// in 
                * it to the encoded string.  This will get most funky
                * javascript code without breaking too much.
                */
               /* ************************************************** */
               /* case 5: <META HTTP-EQUIV="REFRESH" CONTENT="NN;    */
               /*          URL=newURL">                              */
               /* ************************************************** */
               sleep_time = -1;
               current = (char *) fetch.reply.body;
               while((current = strcasestr(current, "<META")) != NULL) 
               {
                  PDBG("Found a META header.....\n");

                  char * end = strchr(current,'>');
                  if (!end) {
                     /* its a page source error or server error if */
                     /* matching close brak is missing .........   */
                     PWARN("META Header: Can't find closing '>'\n"
                        "\t%s\n", current);
                     current += strlen(META_STRING);
                     continue;
                  }
                  char *start = current+strlen(META_STRING);
   
                  /* ok, we found "<META" See if this is HTTP-EQUIV  */
                  start = strncasestr(start,HTTP_EQUIV_STRING,end-start);
                  if (!start) {
                     /* no, some other kind of META; skip it. ..... */
                     PDBG("META header not an HTTP-EQUIV header.\n");
                     current = end;
                     continue;
                  }
                  start += strlen(HTTP_EQUIV_STRING);
                  /* ok, is this an HTTP_EQUIV="Refresh"? .......... */
                  start = strncasestr(start,REFRESH_STRING,end-start);
                  if (start == NULL) {
                     /* no, some other kind of HTTP-EQUIV; skip it. */
                     PDBG("META header not a "
                        "HTTP-EQUIV=Refresh header.....\n");
                     current = end;
                     continue;
                  }
                  /* look for the Content=nn; or Content="nn"; string */
                  /* and pull out the sleep time                      */
                  start += strlen(REFRESH_STRING);
                  start = strncasestr(start,CONTENT_EQUAL_STRING,end-start);
                  if (start == NULL) {
                     /* This should not happen to us!!! ........... */
                     PWARN ("Can't find Content= in "
                        "<META HTTP-EQUIV=\"Refresh\"\n" 
                        "\t%s\n", current);
                     current = end;
                     continue;
                  }
                  start += strlen(CONTENT_EQUAL_STRING);
                  start += strspn (start, "\"\' \t\n\r");

                  sleep_time = atoi (start);
                  PDBG("sleep_time=%d\n",sleep_time);

                  /* OK, at this point,  we may or may not have a URL. */
                  /* basically, these refreshes come in two forms:     */
                  /* as a redirect, or as a refresh-current page       */
                  /* <meta http-equiv="Refresh" Content=10>            */
                  /* <meta http-equiv="Refresh" Content="10; url=x.html"> */
                  wl_scan_for_links (scan, start, end-start, "url", "=", NULL, (cb_t) patch_link);

                  current = end;
               }

               /* ************************************************** */
               /* case 6: <APPLET><PARAM VALUE="xxx"></APPLET>       */
               /* ************************************************** */

               current = (char *) fetch.reply.body;
               while((current = strcasestr(current, "<APPLET")) != NULL)
               {
                  PDBG("Found an <APPLET> tag.....\n");

                   char *end = strcasestr (current, "</APPLET>");

                  if (!end) {
                     /* This should not happen to us!!! ........ */
                     PWARN("couldn't find end applet tag \n");
                     current += strlen("<APPLET");
                     continue;
                  }
                  char *start = current+strlen("<APPLET");
   
                  /* ok, we found "<APPLET" See if we can find
                   * <PARAM VALUE = tags */
                  wl_scan_for_links (scan, start, end - start, "Value", "=", NULL, (cb_t) patch_link);

                  current = end;
               }

               /* ************************************************** */
               /* case 7: <LAYER SRC="xxx"></LAYER>                  */
               /* ************************************************** */
               {
                  char * oops = NULL;
                  current = (char *) fetch.reply.body;
                  oops = strcasestr (current, "<layer");
                  if(!oops) oops= strcasestr (current, "<ilayer");
                  if(!oops) oops= strcasestr (current, "<nolayer>");
                  if(!oops) oops= strcasestr (current, "<iframe");
                  if (oops) {
                     PWARN("webmon layer support is poor, "
                        "you may have trouble following links\n");
                  }
               }

            }
         }

         /* ************************************************************ */
         /* put the response, as modified by us, into the trace file     */
         /* before returning it......................................... */
         /* ************************************************************ */
         if (global_opts.trace_client)
         {
            fprintf (global_opts.trace_file, BRWS_RSP_START);
   
            fprintf (global_opts.trace_file, "%s\r\n", (char *)fetch.reply.startline);
            fprintf (global_opts.trace_file, "%s\r\n", (char *)fetch.reply.header);
            /* if this is an image file, don't print the body */
            char * imagestr = is_content_binary(fetch.reply.header);
            if (imagestr) {
               fprintf (global_opts.trace_file, IMAGEDATASKIPPED);
            } else {
               fprintf (global_opts.trace_file, "%s", (char *)fetch.reply.body);
            }
         }
      }

      /* ************************************************************* */
      /* ok, now are are done with all of that, send the response      */
      /* back to the browser.......                                    */
      /* ************************************************************* */
      fetch.reply.Join();
      size_t writelen = fetch.reply.message.Memlen();
      rc = browser.sock.Write (fetch.reply.message, writelen);
      if (rc <= 0) {
         PERR("wlSocket::Write returned %d %s\n",
            rc, strerror (-rc));
         if ((-EINTR != rc) && (-EPIPE != rc)) break;
      }
      if (have_been_interrupted) goto exit;

      PDBG("closing sockfd=%d to browser\n", connection);
      browser.sock.Close();
      PDBG2("finished closing sockfd=%d \n", connection);
   }

exit:
   PDBG("after main loop, closing listen socket\n");
   NETCLOSE(s);
   /* well, this is really the only way to get here, but check anyway....*/
   if (have_been_interrupted) 
   {
      PINFO("caught signal; exiting.\n");
    }
   if (global_opts.trace_file) fclose(global_opts.trace_file);
   global_opts.trace_file = NULL;
   if (global_opts.report_file) {fflush (global_opts.report_file); fclose(global_opts.report_file); }
   global_opts.report_file = NULL;
   if (global_opts.url_out_file) 
   {
      if (!have_written_end) 
      {
         fprintf(global_opts.url_out_file,"<<END>> COUNT MEAN_THINK_TIME\n");
      }
      fclose(global_opts.url_out_file);
   }
   printf("Info: %s: ends.........\n",PROGNAME);
   exit (0);
   return 0;
} /* end main() */
