<?php

# This is a simple example demonstrating how to subclass Weblog
# and extend its functionality via the subst_local() and entry_save_local()
# hooks.

require "weblog.inc";

class LocalWeblog extends Weblog
{
	# This is a contrived example. Usually you will want to use
	# subst_local() to look up an external
	# reference/bookmark/database/whatever and return a HTML link or text.
	# DO NOT return another @REF@, it will abort to prevent looping.
	function subst_local($ref)
	{
		switch ($ref) {
		case 0:
			return "Zero";
		case 1:
			return "One";
		default:
			return "Unknown!";
		}
	}

	# Example extension to email any new posts to a mailing list.
	function entry_save_local($new, $title, $body, $more, $tm)
	{
		# Skip existing entries
		if (!$new)
			return true;

		# subst_external() will substitute in any external
		# references using subst_local()
		$subj = $this->subst_external("[NEW] $title");
		$msg = "$title\n\n$body\n\n$more\n";
		$msg = $this->subst_external($title);

		# !! CHANGE before using this example !!
		mail("list@localhost", $subj, $msg);

		return true;
	}
}

?>
