<?php

# Easy Installer
#
# Copyright 2001  Mark Pulford <mark@kyne.com.au>
# This file is subject to the terms and conditions of the GNU General Public
# License. Read the file COPYING found in this archive for details, or visit
# http://www.gnu.org/copyleft/gpl.html
#
# See http://www.kyne.com.au/~mark/software/weblog.php for the latest version.
#
# $Id: setup.php,v 1.16 2002/07/07 07:39:03 mark Exp $
#

require "weblog.inc";

echo <<< END
<html>
<head><title>Personal Weblog: Easy installer</title></head>
<body bgcolor="#ffffff">
END;

$cgi = cgi_getvars(array("mode", "type", "host", "name",
			 "user", "pass", "prefix"));
if (isset($cgi["mode"]))
	$mode = $cgi["mode"];
if (isset($cgi["prefix"]))
	$prefix = $cgi["prefix"];

if (!isset($mode)) {
	options();
} else if (isset ($prefix) and ereg("[^a-zA-Z0-9_]", $prefix)) {
	echo "<p><b>Error:</b> prefix must not contain any special characters. Use only alphanumberic characters or an underscore</p>";
} else if ($mode == "Install") {
	$sql = load_sql("weblog.sql");

	$dbh = dbconnect($cgi);
	install($dbh, $sql, $prefix);
} else {
	$sql = load_upgrade("upgrade.sql");
	if (is_array($sql[$mode])) {
		$dbh = dbconnect($cgi);
		upgrade($dbh, $sql, $mode, $prefix);
	} else {
		echo "<p><b>Bad mode!</b>\n";
		options();
	}
}

function cgi_getvars($vars)
{
	global $HTTP_GET_VARS, $HTTP_POST_VARS;

	$http_vars = array_merge($HTTP_GET_VARS, $HTTP_POST_VARS);

	$r = array();
	foreach ($vars as $v) {
		if (!isset($http_vars[$v]))
			continue;
		if (get_magic_quotes_gpc())
			$r[$v] = stripslashes($http_vars[$v]);
		else
			$r[$v] = $http_vars[$v];
	}

	return $r;
}

function options()
{
	global $HTTP_SERVER_VARS;

	$self = $HTTP_SERVER_VARS["PHP_SELF"];

	echo "<h1>Easy installer</h1>\n";

	# Cannot select latest version
	$sql = load_upgrade("upgrade.sql");
	if (!$sql) {
		echo "<p>Make sure <tt>weblog.sql</tt> and <tt>upgrade.sql</tt> are ";
		echo "in the same directory as this script, <tt>setup.php</tt>.\n";
		return;
	}
	$versions = array_keys($sql);
	$latest = array_pop($versions);

	echo "<form action=\"$self\" method=\"post\">\n";

	echo "<p>Enter your weblog database details:<br>\n";
	echo "<select name=\"type\">\n";
	echo "<option value=\"mysql\">MySQL\n";
	echo "<option value=\"pg\">PostgreSQL\n";
	echo "</select> Database server<br>\n";
	echo "<input type=\"text\" name=\"host\" value=\"localhost\"> Database host<br>\n";
	echo "<input type=\"text\" name=\"name\"> Database name<br>\n";
	echo "<input type=\"text\" name=\"user\"> Username<br>\n";
	echo "<input type=\"password\" name=\"pass\"> Password<br>\n";
	echo "<input type=\"text\" name=\"prefix\"> Prefix (leave blank unless you want to specify multiple weblogs within a single database)<br>\n";

	echo "<p>You may:\n";

	echo "<ul><li><input type=\"submit\" name=\"mode\" value=\"Install\"></ul>\n";
	echo "OR";
	echo "<ul><li>Upgrade to $latest. Select your current version:<br>\n";
	foreach ($versions as $v)
		echo "<input type=\"submit\" name=\"mode\" value=\"$v\">\n";
	echo "</ul>\n";
	echo "<p>The version of your weblog is recorded at the top of the ";
	echo "weblog.inc file.\n";

	echo "</form>\n";

	echo "<h2>Important!</h2>\n";
	echo "<p>Remove <tt>setup.php</tt>, <tt>weblog.sql</tt> and\n";
	echo "<tt>upgrade.sql</tt> from your web space after the weblog is\n";
	echo "setup.";
}

function dbconnect($cgi)
{
	switch ($cgi["type"]) {
	case "mysql":
		$db = new DB_MySQL($cgi["name"], $cgi["host"],
				    $cgi["user"], $cgi["pass"]);
		break;
	case "pg":
		$db = new DB_pg($cgi["name"], $cgi["host"],
				 $cgi["user"], $cgi["pass"]);
		break;
	default:
		die("Unknown database type");
	}

	if (!$db->connected())
		die("Error: unable to connect to the database");

	return $db;
}

function dbrun($dbh, $sql, $prefix = "")
{
	$clean = true;

	if ($prefix)
		$trans = array(
			"entries" => "{$prefix}entries",
			"topics" => "{$prefix}topics",
			"vars" => "{$prefix}vars");

	foreach ($sql as $cmd) {
		if (isset($trans))
			$cmd = strtr($cmd, $trans);
		$r = $dbh->query($cmd);
		if (!$r) {
			echo "<p><b>Error</b>: " .
			     htmlspecialchars($dbh->error()) . ":<br>\n";
			echo htmlspecialchars($cmd)."\n";
			$clean = false;
		}
	}

	return $clean;
}

function install($db, $sql, $prefix = "")
{
	if (dbrun($db, $sql, $prefix)) {
		echo "<p><b>Installed successfully</b>.\n";
		echo "See README for instructions on how to add the Weblog to your homepage.\n";
	} else {
		echo "<p>Errors occured during the install.\n";
	}
}

function upgrade($db, $sql, $version, $prefix = "")
{
	echo "<h1>Upgrading from $version</h1>\n";

	foreach ($sql as $vk => $vv) {
		if ($vk == $version)
			$inst = true;
		else if ($inst) {
			if (!$vv) {
				echo "<p>Nothing to do for $vk.\n";
			} else {
				if (dbrun($db, $vv, $prefix))
					echo "<p>Upgraded to $vk successfully.\n";
				else
					echo "<p>Errors occured during the $vk upgrade.\n";
			}
		}
	}

	echo "<p>Done\n";
}

function load_sql($fn)
{
	$f = file($fn);
	if (!$f)
		return;

	$max = count($f);

	$sql = "";
	for ($i = 0; $i < $max; $i++) {
		# Skip comments and blank lines
		if (ereg("^( *|#.*)$", chop($f[$i])))
			continue;
		$sql .= $f[$i];
		if (ereg("; *$", chop($sql))) {
			$cmd[] = ereg_replace(";$", "", chop($sql));
			$sql = "";
		}
	}
	if ($sql)
		echo "OOPS, semicolon not found: $sql\n";

	return $cmd;
}

function load_upgrade($fn)
{
	$f = file($fn);
	if (!$f)
		return;

	$max = count($f);

	$sql = "";
	for ($i = 0; $i < $max; $i++) {
		$line = chop($f[$i]);
		# Skip blank lines
		if (ereg("^ *$", $line))
			continue;
		# Set version
		if (ereg("^# (.+)$", $line, $r)) {
			$version = $r[1];
			$cmd[$version] = array();
			continue;
		}	
		$sql .= $f[$i];
		if (ereg("; *$", chop($sql))) {
			$cmd[$version][] = ereg_replace(";$", "", chop($sql));
			$sql = "";
		}
	}
	if ($sql)
		echo "OOPS, semicolon not found: $sql\n";

	return $cmd;
}

echo "</body></html>\n";

?>
