#!/usr/bin/perl
###########################################################################
#    WWWThreads  - Interactive Discussion Forum
#    Copyright (C) 1998  Rick Baker rbaker@techline.com
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
###########################################################################
require 'wwwthread_variables.pl';	
require 'wwwthread_utilities.pl';

#***********************************************************************
# Call the Main Subroutines
#***********************************************************************

&setup;			# Set up the program


#***********************************************************************
# Set up the program
#***********************************************************************

sub setup{
   
   mkdir ("$data_db",0777);
   # Windows Change
   unlink("$data_db/*");

   dbmopen(%DATA, $board_db, 0666)|| die "Couldn't open the database
'$board_db'";

   print "\n\nWWWThreads Version 2.7.1 Program Setup\n";
   print "Copyright (C) 1998 Rick Baker \n\n";
   print "This program is free software; you can redistribute it and/or modify\n";
   print "it under the terms of the GNU General Public License as published by\n";
   print "the Free Software Foundation; either version 2 of the License, or\n";
   print "(at your option) any later version.\n\n";

   print "This program is distributed in the hope that it will be useful,\n";
   print "but WITHOUT ANY WARRANTY; without even the implied warranty of\n";
   print "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n";
   print "GNU General Public License for more details.\n\n";

   print "You should have received a copy of the GNU General Public License\n";
   print "along with this program; if not, write to the Free Software\n";
   print "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n\n";

   print "Creating the Administration User...\n";
   print "Enter a Username: ";
   $user=<STDIN>;
   chop($user);
PASSWORD:  
   print "Enter a Password: ";
   $password=<STDIN>;
   print "Verify Password: ";
   $verify=<STDIN>;
   if ($password ne $verify){
      print "\nPasswords do not match. Please try again.\n\n";
      goto PASSWORD;
   }
   chop($password);
   print"\n";
   $DATA{'USER'}=$user;
   $DATA{'PASSWORD'}=$password;

   print "Creating Discussion Board...\n";
   print "Enter Discussion Board Title:\n";
   $title=<STDIN>;
   chop($title);
   print "Enter Discussion Board Description (all on one line):\n";
   $descrip=<STDIN>;
   chop($descrip);
   print "Enter a one word keyword for the board:\n";
   $keyword=<STDIN>;
   chop($keyword);

   &get_date;

   $DATA{'BOARDS'} = 1;
   $DATA{'BOARD1'} = "$keyword"."\t"."$title"."\t"."$descrip" ;
   $DATA{'DATE1'} = "$fulldate";
   dbmclose(%DATA);

   # Windows Change  
   $message_db = "$data_db/$keyword";
   dbmopen(%DATA, $message_db, 0666)|| die "Couldn't open the database
'$message_db'";
   
   $DATA{'TOTAL'} = "0";
   $DATA{'POSTS'}="0";
   dbmclose(%DATA);

   # Windows Change
   mkdir("$data_db/$keyword$ext",0777);

   # Windows Change
   $user_db = "$data_db/users";
   dbmopen(%USERS,$user_db,0666)|| die "Couldn't open the database
'$user_db'";

   $USERS{'TOTAL'} = "0";
   dbmclose(%USERS);
   print"\nSetup has Completed. Your first WWWThread discussion board is ready for use. Make sure you chmod all files in your data directory to 666\n\n";
   print"Also, don't forget to send your URL to rbaker\@techline.com if you want to be listed on the WWWThreads homepage.\n\n";
}
